/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.configuration.ConfigManagementSupport;
import org.rhq.core.pc.configuration.ConfigurationUpdateException;
import org.rhq.core.pc.configuration.UpdateInProgressException;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;

public class LegacyConfigManagement
extends ConfigManagementSupport {
    private static final Log log = LogFactory.getLog(LegacyConfigManagement.class);

    @Override
    public Configuration executeLoad(int resourceId) throws PluginContainerException {
        Configuration configuration = this.loadConfigFromFacet(resourceId, FacetLockType.READ);
        if (configuration == null) {
            return null;
        }
        ResourceType resourceType = this.componentService.getResourceType(resourceId);
        if (configuration.getNotes() == null) {
            configuration.setNotes("Resource config for " + resourceType.getName() + " Resource w/ id " + resourceId);
        }
        ConfigurationDefinition configurationDefinition = resourceType.getResourceConfigurationDefinition();
        this.configUtilityService.normalizeConfiguration(configuration, configurationDefinition);
        List<String> errorMessages = this.configUtilityService.validateConfiguration(configuration, configurationDefinition);
        for (String errorMessage : errorMessages) {
            log.warn((Object)("Plugin Error: Invalid " + resourceType.getName() + " Resource configuration returned by " + resourceType.getPlugin() + " plugin - " + errorMessage));
        }
        return configuration;
    }

    private Configuration loadConfigFromFacet(int resourceId, FacetLockType lockType) throws PluginContainerException {
        ConfigurationFacet configFacet = this.loadConfigurationFacet(resourceId, lockType);
        try {
            return configFacet.loadResourceConfiguration();
        }
        catch (Exception e) {
            throw new PluginContainerException((Throwable)e);
        }
    }

    @Override
    public void executeUpdate(int resourceId, Configuration configuration) throws PluginContainerException {
        ConfigurationFacet facet = this.loadConfigurationFacet(resourceId, FacetLockType.WRITE);
        ConfigurationUpdateReport report = new ConfigurationUpdateReport(configuration);
        facet.updateResourceConfiguration(report);
        if (ConfigurationUpdateStatus.SUCCESS == report.getStatus()) {
            return;
        }
        if (ConfigurationUpdateStatus.INPROGRESS == report.getStatus()) {
            throw new UpdateInProgressException();
        }
        if (ConfigurationUpdateStatus.FAILURE == report.getStatus()) {
            throw new ConfigurationUpdateException(report.getErrorMessage());
        }
    }
}

