/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.content;

import java.io.InputStream;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.content.ContentServiceResponse;
import org.rhq.core.clientapi.server.content.RetrievePackageBitsRequest;
import org.rhq.core.domain.content.ContentRequestStatus;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pc.content.ContentManager;
import org.rhq.core.util.MessageDigestGenerator;

public class RetrieveContentBitsRunner
implements Runnable {
    private ContentManager contentManager;
    private RetrievePackageBitsRequest request;

    public RetrieveContentBitsRunner(ContentManager contentManager, RetrievePackageBitsRequest request) {
        this.contentManager = contentManager;
        this.request = request;
    }

    @Override
    public void run() {
        InputStream is;
        ResourcePackageDetails pkgDetails;
        ContentServiceResponse response = new ContentServiceResponse(this.request.getRequestId());
        InputStream inputStream = null;
        try {
            inputStream = this.contentManager.performGetPackageBits(this.request.getResourceId(), this.request.getPackageDetails());
            if (inputStream == null) {
                response.setErrorMessage("Null input stream received from plugin");
                response.setStatus(ContentRequestStatus.FAILURE);
            } else {
                response.setStatus(ContentRequestStatus.SUCCESS);
            }
        }
        catch (Throwable throwable) {
            response.setErrorMessageFromThrowable(throwable);
            response.setStatus(ContentRequestStatus.FAILURE);
        }
        ContentServerService serverService = this.contentManager.getContentServerService();
        if (serverService != null) {
            serverService.completeRetrievePackageBitsRequest(response, inputStream);
        }
        if ((pkgDetails = this.request.getPackageDetails()) != null && (pkgDetails.getSHA256() == null || pkgDetails.getSHA256().trim().length() == 0)) {
            try {
                is = this.contentManager.performGetPackageBits(this.request.getResourceId(), this.request.getPackageDetails());
                pkgDetails.setSHA256(new MessageDigestGenerator("SHA-256").calcDigestString(is));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pkgDetails != null && (pkgDetails.getMD5() == null || pkgDetails.getMD5().trim().length() == 0)) {
            try {
                is = this.contentManager.performGetPackageBits(this.request.getResourceId(), this.request.getPackageDetails());
                pkgDetails.setMD5(new MessageDigestGenerator("MD5").calcDigestString(is));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

