/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.inventory.TimeoutException;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.util.exception.ThrowableUtil;

public class AvailabilityExecutor
implements Runnable,
Callable<AvailabilityReport> {
    private static final int GET_AVAILABILITY_TIMEOUT;
    private final Log log = LogFactory.getLog(AvailabilityExecutor.class);
    private InventoryManager inventoryManager;
    private AtomicBoolean sendChangedOnlyReport;
    private final Object lock = new Object();

    public AvailabilityExecutor(InventoryManager inventoryManager) {
        this.inventoryManager = inventoryManager;
        this.sendChangedOnlyReport = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object object = this.lock;
            synchronized (object) {
                AvailabilityReport report = this.call();
                this.inventoryManager.handleReport(report);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Availability report collection failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AvailabilityReport call() throws Exception {
        AvailabilityReport availabilityReport;
        this.log.debug((Object)"Running Availability Scan...");
        Object object = this.lock;
        synchronized (object) {
            availabilityReport = new AvailabilityReport(this.sendChangedOnlyReport.get(), this.inventoryManager.getAgent().getName());
            if (this.inventoryManager.getPlatform().getInventoryStatus() != InventoryStatus.COMMITTED) {
                return null;
            }
            long start = System.currentTimeMillis();
            this.checkInventory(this.inventoryManager.getPlatform(), availabilityReport, availabilityReport.isChangesOnlyReport(), true, false);
            if (availabilityReport.getResourceAvailability().isEmpty()) {
                this.checkInventory(this.inventoryManager.getPlatform(), availabilityReport, false, false, false);
            }
            if (availabilityReport.getResourceAvailability().size() > 1) {
                this.sendChangedOnlyReportNextTime();
            }
            long end = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(availabilityReport);
                this.log.debug((Object)("Built availability report for [" + availabilityReport.getResourceAvailability().size() + "] resources with a size of [" + baos.size() + "] bytes in [" + (end - start) + "]ms"));
            }
        }
        return availabilityReport;
    }

    private void checkInventory(Resource resource, AvailabilityReport availabilityReport, boolean reportChangesOnly, boolean checkChildren, boolean parentIsDown) {
        AvailabilityType current;
        Availability previous;
        AvailabilityFacet resourceComponent;
        if (resource.getId() == 0 || resource.getInventoryStatus() != InventoryStatus.COMMITTED) {
            return;
        }
        ResourceContainer resourceContainer = this.inventoryManager.getResourceContainer(resource);
        if (resourceContainer == null || resourceContainer.getSynchronizationState() != ResourceContainer.SynchronizationState.SYNCHRONIZED) {
            return;
        }
        try {
            resourceComponent = resourceContainer.createResourceComponentProxy(AvailabilityFacet.class, FacetLockType.NONE, GET_AVAILABILITY_TIMEOUT, true, false);
        }
        catch (PluginContainerException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Could not create resource component proxy for " + resource + "."), (Throwable)e);
            }
            return;
        }
        Availability availability = previous = reportChangesOnly ? this.inventoryManager.getAvailabilityIfKnown(resource) : null;
        if (parentIsDown) {
            current = AvailabilityType.DOWN;
        } else {
            block17: {
                current = null;
                try {
                    if (resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                        current = resourceComponent.getAvailability();
                    } else {
                        this.inventoryManager.activateResource(resource, resourceContainer, false);
                        if (resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                            current = resourceComponent.getAvailability();
                        }
                    }
                }
                catch (Throwable t) {
                    ResourceError resourceError = new ResourceError(resource, ResourceErrorType.AVAILABILITY_CHECK, t.getLocalizedMessage(), ThrowableUtil.getStackAsString((Throwable)t), System.currentTimeMillis());
                    this.inventoryManager.sendResourceErrorToServer(resourceError);
                    if (!this.log.isDebugEnabled()) break block17;
                    if (t instanceof TimeoutException) {
                        this.log.debug((Object)("Failed to collect availability on " + resource + " (call timed out)"));
                    }
                    this.log.debug((Object)("Failed to collect availability on " + resource), t);
                }
            }
            if (current == null) {
                current = AvailabilityType.DOWN;
            }
        }
        if (previous == null || previous.getAvailabilityType() != current || !reportChangesOnly) {
            Availability availability2 = this.inventoryManager.updateAvailability(resource, current);
            availabilityReport.addAvailability(availability2);
        }
        if (checkChildren) {
            HashSet children = new HashSet(resource.getChildResources());
            for (Resource child : children) {
                this.checkInventory(child, availabilityReport, reportChangesOnly, true, current == AvailabilityType.DOWN);
            }
        }
    }

    void sendFullReportNextTime() {
        this.sendChangedOnlyReport.set(false);
    }

    void sendChangedOnlyReportNextTime() {
        this.sendChangedOnlyReport.set(true);
    }

    static {
        int timeout;
        try {
            timeout = Integer.parseInt(System.getProperty("rhq.agent.plugins.availability-scan.timeout", "5000"));
        }
        catch (Throwable t) {
            timeout = 5000;
        }
        GET_AVAILABILITY_TIMEOUT = timeout;
    }
}

