/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.ResourceContainer;

public class InventoryFile {
    private Log log = LogFactory.getLog(InventoryFile.class);
    private final File inventoryFile;
    private Resource platform;
    private Map<String, ResourceContainer> resourceContainers;

    public InventoryFile(File inventoryFile) {
        this.inventoryFile = inventoryFile;
    }

    public File getInventoryFile() {
        return this.inventoryFile;
    }

    public Resource getPlatform() {
        return this.platform;
    }

    public Map<String, ResourceContainer> getResourceContainers() {
        return this.resourceContainers;
    }

    public void loadInventory() throws PluginContainerException {
        try {
            FileInputStream fis = new FileInputStream(this.inventoryFile);
            ObjectInputStream ois = new ObjectInputStream(fis);
            HashSet<String> uuidsToIgnore = new HashSet<String>();
            this.platform = (Resource)ois.readObject();
            this.connectTypes(this.platform, uuidsToIgnore);
            this.resourceContainers = (Map)ois.readObject();
            for (ResourceContainer resourceContainer : this.resourceContainers.values()) {
                this.connectTypes(resourceContainer.getResource(), uuidsToIgnore);
            }
            for (String uuidToIgnore : uuidsToIgnore) {
                this.resourceContainers.remove(uuidToIgnore);
            }
            this.removeIgnoredResourcesFromChildren(this.platform, uuidsToIgnore);
            return;
        }
        catch (Exception e) {
            throw new PluginContainerException("Cannot load inventory file: " + this.inventoryFile, (Throwable)e);
        }
    }

    private void removeIgnoredResourcesFromChildren(Resource resource, Set<String> uuidsToIgnore) {
        Set children = resource.getChildResources();
        if (children != null && !children.isEmpty() && !uuidsToIgnore.isEmpty()) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && !uuidsToIgnore.isEmpty()) {
                Resource child = (Resource)iterator.next();
                this.removeIgnoredResourcesFromChildren(child, uuidsToIgnore);
                if (!uuidsToIgnore.contains(child.getUuid())) continue;
                iterator.remove();
                uuidsToIgnore.remove(child.getUuid());
            }
        }
    }

    private void connectTypes(Resource resource, Set<String> uuidsToIgnore) {
        PluginMetadataManager metadataManager = PluginContainer.getInstance().getPluginManager().getMetadataManager();
        ResourceType resourceType = resource.getResourceType();
        if (resourceType != null) {
            ResourceType fullResourceType = metadataManager.getType(resourceType);
            if (fullResourceType != null) {
                resource.setResourceType(fullResourceType);
                Set children = resource.getChildResources();
                if (children != null) {
                    for (Resource child : children) {
                        this.connectTypes(child, uuidsToIgnore);
                    }
                }
            } else {
                this.log.info((Object)("Persisted resource [" + resource + "] has a disabled resource type - will not reconnect it"));
                this.addAllUUIDsToList(resource, uuidsToIgnore);
            }
        } else {
            this.log.error((Object)("Persisted resource [" + resource + "] does not have a resource type - cannot reconnect its type or its children types"));
            this.addAllUUIDsToList(resource, uuidsToIgnore);
        }
    }

    private void addAllUUIDsToList(Resource resource, Set<String> list) {
        list.add(resource.getUuid());
        Set children = resource.getChildResources();
        if (children != null) {
            for (Resource child : children) {
                this.addAllUUIDsToList(child, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInventory(Resource platformResource, Map<String, ResourceContainer> containers) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.inventoryFile);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(platformResource);
            oos.writeObject(containers);
            this.platform = platformResource;
            this.resourceContainers = containers;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

