/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.plugin.PluginComponentFactory;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.util.exception.ExceptionPackage;
import org.rhq.core.util.exception.Severity;

public class RuntimeDiscoveryExecutor
implements Runnable,
Callable<InventoryReport> {
    private Log log = LogFactory.getLog(RuntimeDiscoveryExecutor.class);
    private InventoryManager inventoryManager;
    private PluginContainerConfiguration pluginContainerConfiguration;
    private Resource resource;

    public RuntimeDiscoveryExecutor(InventoryManager inventoryManager, PluginContainerConfiguration pluginContainerConfiguration) {
        this.inventoryManager = inventoryManager;
        this.pluginContainerConfiguration = pluginContainerConfiguration;
    }

    public RuntimeDiscoveryExecutor(InventoryManager inventoryManager, PluginContainerConfiguration pluginContainerConfiguration, Resource resource) {
        this(inventoryManager, pluginContainerConfiguration);
        this.resource = resource;
    }

    @Override
    public void run() {
        this.call();
    }

    @Override
    public InventoryReport call() {
        try {
            String target = this.resource != null ? this.resource.toString() : "platform";
            this.log.info((Object)("Running runtime discovery scan rooted at [" + target + "]"));
            InventoryReport report = new InventoryReport(this.inventoryManager.getAgent());
            report.setRuntimeReport(true);
            report.setStartTime(System.currentTimeMillis());
            this.runtimeDiscover(report);
            report.setEndTime(System.currentTimeMillis());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Runtime discovery scan took %d ms.", report.getEndTime() - report.getStartTime()));
            }
            this.log.info((Object)("Scanned [" + report.getAddedRoots().size() + "] servers and found [" + (report.getResourceCount() - report.getAddedRoots().size()) + "] total descendant Resources."));
            if (this.log.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(report);
                this.log.trace((Object)("Runtime report contains " + report.getResourceCount() + " Resources with a size of " + baos.size() + " bytes"));
            }
            this.inventoryManager.handleReport(report);
            return report;
        }
        catch (Exception e) {
            this.log.error((Object)"Error running runtime report", (Throwable)e);
            return null;
        }
    }

    private void runtimeDiscover(InventoryReport report) throws PluginContainerException {
        this.inventoryManager.executeAvailabilityScanImmediately(true);
        if (this.resource == null) {
            Resource platform = this.inventoryManager.getPlatform();
            this.discoverForResource(platform, report, false);
            this.discoverForResourceRecursive(platform, report);
        } else {
            this.discoverForResource(this.resource, report, false);
        }
    }

    private void discoverForResourceRecursive(Resource parent, InventoryReport report) throws PluginContainerException {
        Set children = parent.getChildResources();
        if (children != null && !children.isEmpty()) {
            HashSet childrenCopy = new HashSet(children);
            for (Resource child : childrenCopy) {
                boolean alreadyProcessed = report.getAddedRoots().contains(child);
                if (alreadyProcessed) continue;
                this.discoverForResource(child, report, alreadyProcessed);
                this.discoverForResourceRecursive(child, report);
            }
            childrenCopy.clear();
            childrenCopy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverForResource(Resource parent, InventoryReport report, boolean parentReported) throws PluginContainerException {
        AvailabilityType availability;
        ResourceContainer parentContainer = this.inventoryManager.getResourceContainer(parent);
        if (parentContainer == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot perform service scan on parent [" + parent + "] without a container"));
            }
            return;
        }
        if (parentContainer.getResourceComponentState() != ResourceContainer.ResourceComponentState.STARTED) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Parent [" + parent + "] is not STARTED - not performing service scan"));
            }
            return;
        }
        if (parent.getInventoryStatus() != InventoryStatus.COMMITTED) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Parent [" + parent + "] must be imported/commited before service scan can run."));
            }
            return;
        }
        ResourceComponent parentComponent = parentContainer.getResourceComponent();
        if (parentComponent == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Parent component for [" + parent + "] was null; cannot perform service scan."));
            }
            return;
        }
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(parentContainer.getResourceClassLoader());
            availability = parentComponent.getAvailability();
        }
        catch (Exception e) {
            availability = AvailabilityType.DOWN;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
        if (availability != AvailabilityType.UP) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Availability of [" + parent + "] is not UP, cannot perform service scan on it."));
            }
            return;
        }
        PluginComponentFactory factory = PluginContainer.getInstance().getPluginComponentFactory();
        for (ResourceType childResourceType : parent.getResourceType().getChildResourceTypes()) {
            try {
                ResourceDiscoveryComponent discoveryComponent = null;
                try {
                    discoveryComponent = factory.getDiscoveryComponent(childResourceType, parentContainer);
                }
                catch (PluginContainerException pce) {
                    this.log.error((Object)("Unable to obtain discovery component for [" + childResourceType + "]"), (Throwable)pce);
                }
                if (discoveryComponent == null) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Resource not discoverable, no component found: " + childResourceType));
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Running service scan on parent resource [" + parent + "] looking for children of type [" + childResourceType + "]"));
                }
                Set<Resource> childResources = this.inventoryManager.executeComponentDiscovery(childResourceType, discoveryComponent, parentContainer, Collections.<ProcessScanResult>emptyList());
                HashMap<String, Resource> mergedResources = new HashMap<String, Resource>();
                for (Resource childResource : childResources) {
                    boolean thisInReport = false;
                    Resource mergedResource = this.inventoryManager.mergeResourceFromDiscovery(childResource, parent);
                    mergedResources.put(mergedResource.getUuid(), mergedResource);
                    if (mergedResource.getId() == 0 && !parentReported) {
                        report.addAddedRoot(parent);
                        thisInReport = true;
                        parentReported = true;
                    }
                    this.discoverForResource(mergedResource, report, thisInReport);
                }
                this.removeStaleResources(parent, childResourceType, mergedResources);
            }
            catch (Throwable t) {
                report.getErrors().add(new ExceptionPackage(Severity.Severe, t));
                this.log.error((Object)"Error in runtime discovery", t);
            }
        }
    }

    private void removeStaleResources(Resource parent, ResourceType childResourceType, Map<String, Resource> mergedResources) {
        HashSet existingChildResources = new HashSet(parent.getChildResources());
        for (Resource existingChildResource : existingChildResources) {
            if (!existingChildResource.getResourceType().equals((Object)childResourceType) || mergedResources.containsKey(existingChildResource.getUuid()) || existingChildResource.getId() != 0 && this.pluginContainerConfiguration.isInsideAgent()) continue;
            this.log.info((Object)("Removing stale resource [" + existingChildResource + "]"));
            this.inventoryManager.removeResourceAndIndicateIfScanIsNeeded(existingChildResource);
        }
        existingChildResources.clear();
        existingChildResources = null;
    }
}

