/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pc.operation.OperationInvocation;

public class OperationThreadPoolGateway {
    private final Log log = LogFactory.getLog(OperationThreadPoolGateway.class);
    private final Map<Integer, LinkedList<OperationInvocation>> resourceQueues;
    private final Map<String, OperationInvocation> allOperations;
    private final ThreadPoolExecutor threadPool;
    private boolean stopped;

    public OperationThreadPoolGateway(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
        this.resourceQueues = new HashMap<Integer, LinkedList<OperationInvocation>>();
        this.allOperations = new HashMap<String, OperationInvocation>();
        this.stopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<OperationInvocation> doomedOperations;
        Map<Integer, LinkedList<OperationInvocation>> map = this.resourceQueues;
        synchronized (map) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            doomedOperations = this.drainQueue(this.resourceQueues);
            ArrayList threadPoolQueueDrain = new ArrayList();
            this.threadPool.getQueue().drainTo(threadPoolQueueDrain);
            for (Object runnable : threadPoolQueueDrain) {
                doomedOperations.add((OperationInvocation)runnable);
            }
            threadPoolQueueDrain = null;
            this.threadPool.shutdownNow();
        }
        for (OperationInvocation operationToCancel : doomedOperations) {
            operationToCancel.markAsCanceled();
            operationToCancel.run();
        }
        try {
            this.threadPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        doomedOperations.clear();
        Map<Integer, LinkedList<OperationInvocation>> e = this.resourceQueues;
        synchronized (e) {
            for (OperationInvocation operationInvocation : this.allOperations.values()) {
                if (!operationInvocation.getStatus().contains((Object)OperationInvocation.Status.QUEUED)) continue;
                doomedOperations.add(operationInvocation);
            }
            this.allOperations.clear();
        }
        for (OperationInvocation operationToCancel : doomedOperations) {
            this.log.info((Object)("Operation is in limbo after shutdown - forcibly canceling: " + operationToCancel));
            operationToCancel.markAsCanceled();
            operationToCancel.run();
        }
        doomedOperations = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationInvocation getOperationInvocation(String jobId) {
        Map<Integer, LinkedList<OperationInvocation>> map = this.resourceQueues;
        synchronized (map) {
            return this.allOperations.get(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(OperationInvocation operation) {
        Integer operationResourceId = operation.getResourceId();
        boolean failedToExecute = false;
        Map<Integer, LinkedList<OperationInvocation>> map = this.resourceQueues;
        synchronized (map) {
            if (this.stopped) {
                throw new IllegalStateException("Operations thread pool is shutdown - not accepting new submissions");
            }
            this.allOperations.put(operation.getJobId(), operation);
            LinkedList<OperationInvocation> queuedOps = this.resourceQueues.get(operationResourceId);
            if (queuedOps == null) {
                this.resourceQueues.put(operationResourceId, new LinkedList());
                try {
                    this.threadPool.execute(operation);
                }
                catch (Exception e) {
                    failedToExecute = true;
                    this.log.error((Object)("Failed to submit operation: " + operation));
                }
            } else {
                this.log.debug((Object)("Resource is busy executing a prior operation - queuing up operation: " + operation));
                queuedOps.add(operation);
            }
        }
        if (failedToExecute) {
            operation.markAsCanceled();
            operation.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationCompleted(OperationInvocation operation) {
        Integer operationResourceId = operation.getResourceId();
        Map<Integer, LinkedList<OperationInvocation>> map = this.resourceQueues;
        synchronized (map) {
            if (this.stopped) {
                return;
            }
            this.allOperations.remove(operation.getJobId());
            LinkedList<OperationInvocation> queuedOps = this.resourceQueues.get(operationResourceId);
            if (queuedOps != null) {
                if (queuedOps.isEmpty()) {
                    this.resourceQueues.remove(operationResourceId);
                } else {
                    OperationInvocation nextOperation = queuedOps.remove();
                    try {
                        this.log.debug((Object)("Resource is no longer busy - the next operation in line will be invoked: " + nextOperation));
                        this.threadPool.execute(nextOperation);
                    }
                    catch (Exception e) {
                        this.log.error((Object)("Failed to submit next operation: " + nextOperation));
                    }
                }
            }
        }
    }

    private List<OperationInvocation> drainQueue(Map<Integer, LinkedList<OperationInvocation>> queue) {
        ArrayList<OperationInvocation> contents = new ArrayList<OperationInvocation>();
        for (LinkedList<OperationInvocation> resourceOperations : queue.values()) {
            contents.addAll(resourceOperations);
            resourceOperations.clear();
        }
        queue.clear();
        return contents;
    }
}

