/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.standaloneContainer;

import java.util.EnumSet;

public enum Command {
    ASCAN("as", "", 0, "Triggers an availability scan"),
    AVAIL("a", " ( id )", 0, "Shows an availability report. If id is given, only shows availability for resource with id id"),
    CHILDREN("chi", "[id]", 0, "Shows the direct children of the resource with the passed id, or if no id passed of the current resource"),
    DISCOVER("disc", " s | i | all", 1, "Triggers a discovery scan for (s)erver, serv(i)ce or all resources"),
    FIND("find", "r | t  | rt <name>", 2, "Searches a (r)esource, resource (t)ype or resources of (rt)ype. Use * as wildcard.\n Will set $r for the last resource shown."),
    HELP("h", "", 0, "Shows this help"),
    INVOKE("i", "operation [params]", 1, "Triggers running an operation. If operation is '-list' it shows available operations"),
    MEASURE("m", "datatype property+", 1, "Triggers getting metric values. All need to be of the same data type. If datatype is '-list' it shows the defined metrics"),
    NATIVE("n", "e | d | s", 1, "Enables/disables native system or shows native status"),
    QUIT("quit", "", 0, "Terminates the application"),
    RESOURCES("res", "", 0, "Shows the discovered resources"),
    SET("set", "'resource' N", 2, "Sets the resource id to work with. N can be a number or '$r' as result of last find resource call. 'id' is an alias for 'res'"),
    STDIN("stdin", "", 0, "Stop reading the batch file and wait for commands on stdin"),
    WAIT("w", "milliseconds", 1, "Waits the given amount of time"),
    P_CONFIG("pc", "", 0, "Shows the plugin configuration of the current resource."),
    R_CONFIG("rc", "", 0, "Shows the resource configuration of the current resource."),
    SR_CONFIG("rcs", "", 0, "[parameters] set resource config "),
    SP_CONFIG("pcs", "", 0, "[parameters] set plugin config ");

    private String abbrev;
    private String args;
    private String help;
    private int minArgs;

    public String getArgs() {
        return this.args;
    }

    public String getHelp() {
        return this.help;
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    private Command(String abbrev, String args, int minArgs, String help) {
        this.abbrev = abbrev;
        this.args = args;
        this.minArgs = minArgs;
        this.help = help;
    }

    public String getAbbrev() {
        return this.abbrev;
    }

    public static Command get(String s) {
        String upper = s.toUpperCase();
        for (Command c : EnumSet.allOf(Command.class)) {
            if (!c.name().equals(upper) && !c.getAbbrev().equals(s.toLowerCase())) continue;
            return c;
        }
        return null;
    }
}

