/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.standaloneContainer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class History {
    private static final String HISTORY_HELP = "!! : repeat the last action\n!? : show the history of commands issued\n!h : show this help\n!nn : repeat history item with number nn\n!w fileName : write history to file with name fileName\n!dnn : delete history item with number nn";
    List<String> history = new ArrayList<String>(10);

    public String handleHistory(String answer) {
        if (!answer.startsWith("!")) {
            this.history.add(answer);
            return answer;
        }
        if (answer.startsWith("!?")) {
            for (int i = 0; i < this.history.size(); ++i) {
                System.out.println("[" + i + "]: " + this.history.get(i));
            }
        } else {
            if (answer.startsWith("!h")) {
                System.out.println(HISTORY_HELP);
                return "!";
            }
            if (answer.startsWith("!!")) {
                String text = this.history.get(this.history.size() - 1);
                System.out.println(text);
                this.history.add(text);
                return text;
            }
            if (answer.matches("![0-9]+")) {
                Integer i;
                String id = answer.substring(1);
                try {
                    i = Integer.valueOf(id);
                }
                catch (NumberFormatException nfe) {
                    System.err.println(id + " is no valid history position");
                    return "!";
                }
                if (i > this.history.size()) {
                    System.err.println(i + " is no valid history position");
                    return "!";
                }
                String text = this.history.get(i);
                System.out.println(text);
                this.history.add(text);
                return text;
            }
            if (answer.startsWith("!w")) {
                String[] tokens = answer.split(" ");
                if (tokens.length < 2) {
                    System.err.println("Not enough parameters. You need to give a file name");
                }
                File file = new File(tokens[1]);
                try {
                    file.createNewFile();
                    if (file.canWrite()) {
                        FileWriter writer = new FileWriter(file);
                        for (String item : this.history) {
                            writer.write(item);
                            writer.write("\n");
                        }
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                    } else {
                        System.err.println("Can not write to file " + file);
                    }
                }
                catch (IOException ioe) {
                    System.err.println("Saving the history to file " + file + " failed: " + ioe.getMessage());
                }
                return "!";
            }
            if (answer.matches("!d[0-9]+")) {
                Integer i;
                String id = answer.substring(2);
                try {
                    i = Integer.valueOf(id);
                }
                catch (NumberFormatException nfe) {
                    System.err.println(id + " is no valid history position");
                    return "!";
                }
                if (i > this.history.size()) {
                    System.err.println(i + " is no valid history position");
                    return "!";
                }
                this.history.remove(i);
                return "!";
            }
            System.err.println(answer + " is no valid history command");
            return "!";
        }
        return "!";
    }

    public int size() {
        return this.history.size();
    }
}

