/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.upgrade;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;

public class ResourceUpgradeDelegate {
    private static final Log log = LogFactory.getLog(ResourceUpgradeDelegate.class);
    private boolean enabled = true;
    private Set<ResourceUpgradeRequest> requests = new HashSet<ResourceUpgradeRequest>();
    private InventoryManager inventoryManager;
    private Set<Resource> failedResources = new HashSet<Resource>();
    private Map<Resource, Set<ResourceType>> failedResourceTypesPerParent = new HashMap<Resource, Set<ResourceType>>();
    private boolean mergeFailed;

    public ResourceUpgradeDelegate(InventoryManager inventoryManager) {
        this.inventoryManager = inventoryManager;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean processAndQueue(ResourceContainer resourceContainer) throws PluginContainerException {
        if (this.enabled) {
            return this.executeResourceUpgradeFacetAndStoreRequest(resourceContainer);
        }
        return true;
    }

    public boolean hasUpgradeMergeFailed() {
        return this.mergeFailed;
    }

    public boolean hasUpgradeFailed(Resource resource) {
        return this.mergeFailed || this.failedResources.contains(resource);
    }

    public boolean hasUpgradeFailedInChildren(Resource parentResource, ResourceType childrenResourceType) {
        if (this.mergeFailed) {
            return true;
        }
        Set<ResourceType> failedTypes = this.failedResourceTypesPerParent.get(parentResource);
        return failedTypes != null && failedTypes.contains(childrenResourceType);
    }

    public void sendRequests() throws Throwable {
        if (this.enabled && this.requests.size() > 0) {
            try {
                this.inventoryManager.mergeResourcesFromUpgrade(this.requests);
            }
            catch (Throwable t) {
                this.mergeFailed = true;
                for (ResourceUpgradeRequest request : this.requests) {
                    ResourceContainer container = this.inventoryManager.getResourceContainer(request.getResourceId());
                    if (container == null) continue;
                    this.inventoryManager.deactivateResource(container.getResource());
                }
                throw t;
            }
        }
    }

    private <T extends ResourceComponent> boolean executeResourceUpgradeFacetAndStoreRequest(ResourceContainer resourceContainer) throws PluginContainerException {
        ResourceComponent parentResourceComponent = resourceContainer.getResourceContext().getParentResourceComponent();
        Resource parentResource = resourceContainer.getResource().getParentResource();
        ResourceContainer parentResourceContainer = parentResource != null ? this.inventoryManager.getResourceContainer(resourceContainer.getResource().getParentResource()) : null;
        ResourceContext parentResourceContext = parentResourceContainer == null ? null : parentResourceContainer.getResourceContext();
        Resource resource = resourceContainer.getResource();
        ResourceDiscoveryComponent discoveryComponent = PluginContainer.getInstance().getPluginComponentFactory().getDiscoveryComponent(resource.getResourceType(), parentResourceContainer);
        if (!(discoveryComponent instanceof ResourceUpgradeFacet)) {
            return true;
        }
        ResourceUpgradeContext<ResourceComponent> upgradeContext = this.inventoryManager.createResourceUpgradeContext(resource, parentResourceContext, parentResourceComponent, discoveryComponent);
        ResourceUpgradeRequest request = new ResourceUpgradeRequest(resource.getId());
        request.setTimestamp(System.currentTimeMillis());
        ResourceUpgradeReport upgradeReport = null;
        try {
            upgradeReport = this.inventoryManager.invokeDiscoveryComponentResourceUpgradeFacet(resource.getResourceType(), discoveryComponent, upgradeContext);
        }
        catch (Throwable t) {
            log.error((Object)("ResourceUpgradeFacet threw an exception while upgrading resource [" + resource + "]"), t);
            request.setErrorProperties(t);
        }
        if (upgradeReport != null && upgradeReport.hasSomethingToUpgrade()) {
            String upgradeErrors = null;
            upgradeErrors = this.checkUpgradeValid(resource, upgradeReport);
            if (upgradeErrors != null) {
                String errorString = "Upgrading the resource [" + resource + "] using these updates [" + upgradeReport + "] would render the inventory invalid because of the following reasons: " + upgradeErrors;
                log.error((Object)errorString);
                IllegalStateException ex = new IllegalStateException(errorString);
                ex.fillInStackTrace();
                request.setErrorProperties((Throwable)ex);
            } else {
                request.fillInFromReport(upgradeReport);
            }
        }
        if (request.hasSomethingToUpgrade()) {
            this.requests.add(request);
        }
        if (request.getUpgradeErrorMessage() != null) {
            this.failedResources.add(resource);
            Set<ResourceType> failedResourceTypesInParent = this.failedResourceTypesPerParent.get(parentResource);
            if (failedResourceTypesInParent == null) {
                failedResourceTypesInParent = new HashSet<ResourceType>();
                this.failedResourceTypesPerParent.put(parentResource, failedResourceTypesInParent);
            }
            failedResourceTypesInParent.add(resource.getResourceType());
            this.inventoryManager.deactivateResource(resource);
            return false;
        }
        return true;
    }

    private String checkUpgradeValid(Resource resource, ResourceUpgradeReport upgradeReport) {
        StringBuilder s = new StringBuilder();
        if (!this.checkResourceKeyUniqueAmongSiblings(resource, upgradeReport)) {
            s.append("\nAnother inventoried sibling resource of the same type already has the proposed resource key.");
        }
        return s.length() > 0 ? s.toString() : null;
    }

    private boolean checkResourceKeyUniqueAmongSiblings(Resource resource, ResourceUpgradeReport upgradeReport) {
        Resource parent = resource.getParentResource();
        if (parent == null) {
            return true;
        }
        for (Resource sibling : parent.getChildResources()) {
            if (upgradeReport.getNewResourceKey() == null || !sibling.getResourceType().equals((Object)resource.getResourceType()) || sibling.getUuid().equals(resource.getUuid()) || !sibling.getResourceKey().equals(upgradeReport.getNewResourceKey())) continue;
            return false;
        }
        return true;
    }
}

