/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionCondition;
import org.jbpm.graph.node.DecisionHandler;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Decision
extends Node
implements Parsable {
    static final String NEWLINE = System.getProperty("line.separator");
    static final String DECISION_CONDITION_RESULT = "decision_condition_result";
    static final long serialVersionUID = 1L;
    List decisionConditions = null;
    Delegation decisionDelegation = null;
    String decisionExpression = null;
    private static Log log = LogFactory.getLog((Class)Decision.class);

    public Decision() {
    }

    public Decision(String name) {
        super(name);
    }

    public void read(Element decisionElement, JpdlXmlReader jpdlReader) {
        String expression = decisionElement.attributeValue("expression");
        Element decisionHandlerElement = decisionElement.element("handler");
        if (expression != null) {
            this.decisionExpression = expression;
        } else if (decisionHandlerElement != null) {
            this.decisionDelegation = new Delegation();
            this.decisionDelegation.read(decisionHandlerElement, jpdlReader);
        }
        Iterator iter = decisionElement.elementIterator("transition");
        while (iter.hasNext()) {
            String conditionExpression;
            Element transitionElement = (Element)iter.next();
            Element conditionElement = transitionElement.element("condition");
            if (conditionElement == null || (conditionExpression = this.getConditionExpression(conditionElement)) == null) continue;
            String transitionName = transitionElement.attributeValue("name");
            if (this.decisionConditions == null) {
                this.decisionConditions = new ArrayList();
            }
            this.decisionConditions.add(new DecisionCondition(transitionName, conditionExpression));
        }
    }

    String getConditionExpression(Element conditionElement) {
        String expression = conditionElement.attributeValue("expression");
        if (expression != null) {
            return expression;
        }
        return conditionElement.getText();
    }

    public void execute(ExecutionContext executionContext) {
        String transitionName = null;
        try {
            if (this.decisionDelegation != null) {
                DecisionHandler decisionHandler = (DecisionHandler)this.decisionDelegation.instantiate();
                transitionName = decisionHandler.decide(executionContext);
            } else if (this.decisionExpression != null) {
                Object result = JbpmExpressionEvaluator.evaluate(this.decisionExpression, executionContext);
                if (result == null) {
                    throw new JbpmException("decision expression '" + this.decisionExpression + "' returned null");
                }
                transitionName = result.toString();
            } else {
                Iterator iter = this.decisionConditions.iterator();
                while (iter.hasNext() && transitionName == null) {
                    DecisionCondition decisionCondition = (DecisionCondition)iter.next();
                    Object result = JbpmExpressionEvaluator.evaluate(decisionCondition.getExpression(), executionContext);
                    if (!Boolean.TRUE.equals(result)) continue;
                    transitionName = decisionCondition.getTransitionName();
                }
                if (transitionName == null) {
                    this.getDefaultLeavingTransition().getName();
                }
            }
        }
        catch (Throwable exception) {
            this.raiseException(exception, executionContext);
        }
        Transition transition = null;
        if (transitionName != null) {
            log.debug((Object)("selected transition name '" + transitionName + "'"));
            transition = this.getLeavingTransition(transitionName);
        } else {
            log.debug((Object)"no transition name selected: taking default leaving transition");
            transition = this.getDefaultLeavingTransition();
        }
        if (transition == null) {
            throw new JbpmException("decision '" + this.name + "' selected non existing transition '" + transitionName + "'");
        }
        executionContext.leaveNode(transition);
    }

    public List getDecisionConditions() {
        return this.decisionConditions;
    }
}

