/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.UIEffect;
import org.richfaces.json.JSONTokener;

public class EffectRendererBase
extends HeaderResourcesRendererBase {
    protected Class getComponentClass() {
        return UIEffect.class;
    }

    public String convertParameters(FacesContext context, UIEffect effect) throws IOException {
        String params = effect.getParams();
        if (params == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("{" + params + "}");
        try {
            EffectRendererBase.replace(context, (UIComponent)effect, buffer);
            return buffer.toString();
        }
        catch (Exception e) {
            IOException exception = new IOException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    private static void replace(FacesContext context, UIComponent effect, StringBuffer s) throws Exception {
        JSONTokener x = new JSONTokener(s.toString());
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            int idx = x.getMyIndex();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            if ("id".equals(key)) {
                Object value = x.nextValue();
                UIComponent component = RendererUtils.getInstance().findComponentFor(effect, value.toString());
                if (component != null) {
                    value = component.getClientId(context);
                }
                s.replace(idx, x.getMyIndex(), "'id': '" + value + "'");
                return;
            }
            x.nextValue();
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    private String findComponentId(String id, FacesContext context, UIComponent component) {
        UIComponent comp;
        String result = null;
        if (!"".equals(id) && (comp = this.getUtils().findComponentFor(component, id)) != null) {
            String cid;
            result = cid = comp.getClientId(context);
        }
        return result;
    }

    public void writeScript(FacesContext context, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        String attachObj = "";
        String attachId = "";
        String id = (String)attributes.get("for");
        if (!"".equals(id) && (attachId = this.findComponentId(id, context, component)) == null) {
            attachId = id;
            attachObj = id;
        }
        String event = (String)attributes.get("event");
        Boolean needsFunction = new Boolean(!"".equals(attributes.get("name")) && "".equals(event));
        Boolean needsObserver = new Boolean(!"".equals(event) && !"".equals(attachId));
        if (needsFunction.booleanValue() || needsObserver.booleanValue()) {
            String targetObj = "";
            String targetId = "";
            id = (String)attributes.get("targetId");
            targetId = this.findComponentId(id, context, component);
            if (targetId == null) {
                targetId = id;
                targetObj = id;
            }
            HashMap options = new HashMap();
            this.getUtils().addToScriptHash(options, "targetObj", (Object)targetObj, null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
            this.getUtils().addToScriptHash(options, "attachObj", (Object)attachObj, null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
            this.getUtils().addToScriptHash(options, "targetId", (Object)targetId, null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
            this.getUtils().addToScriptHash(options, "attachId", (Object)attachId, null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
            this.getUtils().addToScriptHash(options, "type", attributes.get("type"), null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
            this.getUtils().addToScriptHash(options, "event", attributes.get("event"), null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
            this.getUtils().addToScriptHash(options, "name", attributes.get("name"), null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
            this.getUtils().addToScriptHash(options, "params", (Object)new JSLiteral(this.convertParameters(context, (UIEffect)component)), null, RendererUtils.ScriptHashVariableWrapper.DEFAULT);
            JSFunction function = new JSFunction("Richfaces.effect.create", new Object[0]);
            if (!options.isEmpty()) {
                function.addParameter(options);
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("script", component);
            this.getUtils().writeAttribute(writer, "type", (Object)"text/javascript");
            writer.writeText((Object)function.toScript(), component, null);
            writer.endElement("script");
        }
    }
}

