/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.event.AjaxEvent;
import org.richfaces.component.UIPanelMenu;
import org.richfaces.component.UIPanelMenuItem;
import org.richfaces.renderkit.PanelMenuRendererBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelMenuItemRenderer
extends PanelMenuRendererBase {
    protected Class<UIPanelMenuItem> getComponentClass() {
        return UIPanelMenuItem.class;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        if (this.isSubmitted(context, component)) {
            new ActionEvent(component).queue();
            if ("ajax".equals(this.getItemMode(component))) {
                new AjaxEvent(component).queue();
            }
        }
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
    }

    public void insertImage(FacesContext context, UIComponent component, Object data) throws IOException {
        String from = (String)data;
        UIPanelMenu panelMenu = this.findMenu(component);
        if (panelMenu == null) {
            return;
        }
        String align = "";
        UIPanelMenuItem panelMenuItem = (UIPanelMenuItem)component;
        boolean isTopLevel = this.isTopLevel((UIComponent)panelMenuItem);
        align = isTopLevel ? panelMenu.getIconItemTopPosition() : panelMenu.getIconItemPosition();
        if (null == align || "".equals(align)) {
            align = "left";
        }
        if (align.equalsIgnoreCase(from)) {
            this.image(context, component, from);
        } else {
            String iconType = "spacer";
            String imageSrc = this.getIconByType(iconType, isTopLevel, context, component);
            this.drawIcon(context.getResponseWriter(), iconType, imageSrc, component, from + "Icon" + component.getClientId(context), false);
        }
    }

    private void image(FacesContext context, UIComponent component, String from) throws IOException {
        UIPanelMenu panelMenu = this.findMenu(component);
        ResponseWriter writer = context.getResponseWriter();
        boolean isTopLevel = this.isTopLevel(component);
        String iconType = null;
        UIPanelMenuItem item = (UIPanelMenuItem)component;
        String defaultItemIcon = null;
        String customItemIcon = null;
        if (isTopLevel) {
            defaultItemIcon = item.isDisabled() ? panelMenu.getIconTopDisabledItem() : panelMenu.getIconTopItem();
            if (defaultItemIcon == null || defaultItemIcon.equals("")) {
                defaultItemIcon = item.isDisabled() ? panelMenu.getIconDisabledItem() : panelMenu.getIconItem();
            }
        } else if (defaultItemIcon == null || defaultItemIcon.equals("")) {
            defaultItemIcon = item.isDisabled() ? panelMenu.getIconDisabledItem() : panelMenu.getIconItem();
        }
        String string = customItemIcon = item.isDisabled() ? item.getIconDisabled() : item.getIcon();
        if (customItemIcon == null || customItemIcon.equals("")) {
            iconType = defaultItemIcon;
            isTopLevel = false;
        } else {
            iconType = customItemIcon;
        }
        boolean drawHidden = false;
        String source = this.getIconByType(iconType, isTopLevel, context, component);
        if (source != null && source.trim().length() == 0) {
            source = this.getIconByType("spacer", isTopLevel, context, component);
            drawHidden = true;
        }
        this.drawIcon(writer, iconType, source, component, from + "Icon" + component.getClientId(context), drawHidden);
    }

    public String getFullStyleClass(FacesContext context, UIComponent component) {
        StringBuffer classBuffer = new StringBuffer("");
        UIPanelMenuItem item = (UIPanelMenuItem)component;
        UIPanelMenu parentMenu = this.findMenu((UIComponent)item);
        if (!parentMenu.isDisabled() && !item.isDisabled()) {
            if (this.calculateLevel((UIComponent)item) == 0) {
                String topItemClass = parentMenu.getTopItemClass();
                if (topItemClass != null && !topItemClass.equals("")) {
                    classBuffer.append(topItemClass).append(" ");
                }
                classBuffer.append("rich-pmenu-top-item ");
            } else {
                String parentItemClass = parentMenu.getItemClass();
                if (parentItemClass != null && !parentItemClass.equals("")) {
                    classBuffer.append(parentItemClass).append(" ");
                }
            }
            String itemClass = item.getStyleClass();
            if (itemClass != null && !itemClass.equals("")) {
                classBuffer.append(itemClass);
            }
        } else {
            String itemDisabledClass;
            String pmDisabledItemClass = parentMenu.getDisabledItemClass();
            if (pmDisabledItemClass != null && !pmDisabledItemClass.equals("")) {
                classBuffer.append(pmDisabledItemClass).append(" ");
            }
            if ((itemDisabledClass = item.getDisabledClass()) != null && !itemDisabledClass.equals("")) {
                classBuffer.append(itemDisabledClass);
            }
        }
        return classBuffer.toString();
    }

    public String getFullStyle(FacesContext context, UIComponent component) {
        StringBuffer styleBuffer = new StringBuffer("");
        UIPanelMenuItem item = (UIPanelMenuItem)component;
        UIPanelMenu parentMenu = this.findMenu((UIComponent)item);
        if (!item.isDisabled()) {
            if (this.calculateLevel((UIComponent)item) == 0) {
                String topItemStyle = parentMenu.getTopItemStyle();
                if (topItemStyle != null && !topItemStyle.equals("")) {
                    styleBuffer.append(parentMenu.getTopItemStyle()).append(";").append(" ");
                }
            } else {
                String itemStyle = parentMenu.getItemStyle();
                if (itemStyle != null && !itemStyle.equals("")) {
                    styleBuffer.append(itemStyle).append(";").append(" ");
                }
            }
            String style = item.getStyle();
            if (style != null && !style.equals("")) {
                styleBuffer.append(item.getStyle());
            }
        } else {
            String itemDisabledStyle;
            String pmDisabledItemStyle = parentMenu.getDisabledItemStyle();
            if (pmDisabledItemStyle != null && !pmDisabledItemStyle.equals("")) {
                styleBuffer.append(pmDisabledItemStyle).append(";").append(" ");
            }
            if ((itemDisabledStyle = item.getDisabledStyle()) != null && !itemDisabledStyle.equals("")) {
                styleBuffer.append(itemDisabledStyle);
            }
        }
        return styleBuffer.toString();
    }

    public String getLabelClass(FacesContext context, UIComponent component) {
        StringBuffer resClass = new StringBuffer();
        UIPanelMenuItem item = (UIPanelMenuItem)component;
        UIPanelMenu parentMenu = this.findMenu((UIComponent)item);
        if (!item.isDisabled() && !parentMenu.isDisabled()) {
            if (this.isTopLevel(component)) {
                resClass.append("rich-pmenu-item-label rich-pmenu-top-item-label");
            } else {
                resClass.append("rich-pmenu-item-label");
            }
        }
        return resClass.toString();
    }

    public String getIconClass(FacesContext context, UIComponent component, String align) {
        UIPanelMenuItem item = (UIPanelMenuItem)component;
        UIPanelMenu parentMenu = this.findMenu((UIComponent)item);
        String iconClass = "";
        if (!item.isDisabled() && !parentMenu.isDisabled()) {
            String iconClassAttr = ((UIPanelMenuItem)component).getIconClass();
            if (this.isTopLevel(component) && align.equals(parentMenu.getIconItemTopPosition())) {
                iconClass = "rich-pmenu-item-icon rich-pmenu-top-item-icon";
            }
            if (align.equals(parentMenu.getIconItemPosition()) && iconClassAttr != null) {
                iconClass = iconClass.equals("") ? "rich-pmenu-item-icon " + iconClassAttr : iconClass + " " + iconClassAttr;
            }
        }
        return iconClass;
    }

    @Override
    protected String getName(UIComponent component) {
        return ((UIPanelMenuItem)component).getName();
    }
}

