/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.rhq.core.db.ant.Base64;

public class MD5Task
extends Task {
    private String value;
    private String property;
    private boolean base64 = true;

    public void setValue(String s) {
        this.value = s;
    }

    public void setProperty(String s) {
        this.property = s;
    }

    public void setBase64(boolean b) {
        this.base64 = b;
    }

    public void execute() throws BuildException {
        String md5;
        MessageDigest message_digest;
        this.validateAttributes();
        try {
            message_digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException((Throwable)e);
        }
        byte[] md5_bytes = message_digest.digest(this.value.getBytes());
        if (this.base64) {
            md5 = Base64.encode(md5_bytes);
        } else {
            StringBuffer md5_string = new StringBuffer(md5_bytes.length * 2);
            for (int i = 0; i < md5_bytes.length; ++i) {
                int hi = md5_bytes[i] >> 4 & 0xF;
                int lo = md5_bytes[i] & 0xF;
                md5_string.append(Character.forDigit(hi, 16));
                md5_string.append(Character.forDigit(lo, 16));
            }
            md5 = md5_string.toString();
        }
        Project this_project = this.getProject();
        this_project.setNewProperty(this.property, md5);
    }

    private void validateAttributes() throws BuildException {
        if (this.value == null) {
            throw new BuildException("value==null");
        }
        if (this.property == null) {
            throw new BuildException("property==null");
        }
    }
}

