/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.DbUtil;
import org.rhq.core.db.TypeMap;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpec;
import org.rhq.core.db.ant.dbupgrade.SchemaVersion;

public class DBUpgrader
extends Task {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private static final String SCHEMA_MOD_IN_PROGRESS = " *** UPGRADE IN PROGRESS: migrating to version ";
    private List<SchemaSpec> schemaSpecs = new ArrayList<SchemaSpec>();
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String valueColumn;
    private String tableName;
    private String keyColumn;
    private String keyMatch;
    private File typeMapFile;
    private Collection<TypeMap> typeMaps;
    private String startSchemaVersionString;
    private SchemaVersion startSchemaVersion;
    private String targetSchemaVersionString;
    private SchemaVersion targetSchemaVersion;
    private DatabaseType databaseType;
    private Connection connection;
    private boolean doCloseConnection;

    public DBUpgrader() {
        this.doCloseConnection = true;
    }

    public DBUpgrader(Connection connection) {
        this.connection = connection;
        this.doCloseConnection = false;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setValueColumn(String v) {
        this.valueColumn = v;
    }

    public void setTable(String t) {
        this.tableName = t;
    }

    public void setKeyColumn(String k) {
        this.keyColumn = k;
    }

    public void setKeyMatch(String m) {
        this.keyMatch = m;
    }

    public void setTypeMap(File f) {
        this.typeMapFile = f;
    }

    public void setTargetSchemaVersion(String v) {
        this.targetSchemaVersionString = v;
    }

    public SchemaSpec createSchemaSpec() {
        SchemaSpec ss = new SchemaSpec(this);
        this.schemaSpecs.add(ss);
        return ss;
    }

    public Collection<TypeMap> getTypeMaps() {
        return this.typeMaps;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        ArrayList<SchemaSpec> newSpecs = new ArrayList<SchemaSpec>();
        newSpecs.addAll(this.schemaSpecs);
        Collections.sort(newSpecs);
        int size = this.schemaSpecs.size();
        for (int i = 0; i < size; ++i) {
            if (!((SchemaSpec)newSpecs.get(i)).equals(this.schemaSpecs.get(i))) {
                throw new BuildException(MSG.getMsg("DBUpgrader.error-schema-specs-out-of-order", new Object[]{this.schemaSpecs.get(i).getVersion()}));
            }
            if (i <= 0 || !((SchemaSpec)newSpecs.get(i)).equals(newSpecs.get(i - 1))) continue;
            throw new BuildException(MSG.getMsg("DBUpgrader.error-duplicate-schema-specs", new Object[]{((SchemaSpec)newSpecs.get(i)).getVersion()}));
        }
        Connection conn = null;
        try {
            conn = this.getConnection();
            this.databaseType = DatabaseTypeFactory.getDatabaseType(conn);
            this.startSchemaVersionString = this.loadStartSchemaVersion(conn, this.databaseType);
            if (this.startSchemaVersionString.indexOf(SCHEMA_MOD_IN_PROGRESS) != -1) {
                try {
                    String ver = this.startSchemaVersionString.substring(0, this.startSchemaVersionString.indexOf(SCHEMA_MOD_IN_PROGRESS));
                    this.updateSchemaVersion(conn, this.databaseType, ver);
                    conn.commit();
                }
                catch (Exception e) {
                    this.log(e.toString());
                }
                throw new BuildException(MSG.getMsg("DBUpgrader.inconsistent-state", new Object[]{this.startSchemaVersionString}));
            }
            try {
                this.startSchemaVersion = new SchemaVersion(this.startSchemaVersionString);
            }
            catch (IllegalArgumentException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            this.log(MSG.getMsg("DBUpgrader.starting", new Object[]{this.startSchemaVersion, this.targetSchemaVersion}));
            String realTargetSchemaVersion = this.targetSchemaVersion.toString();
            if (this.targetSchemaVersion.getIsLatest()) {
                SchemaSpec latestSpec = this.schemaSpecs.get(size - 1);
                realTargetSchemaVersion = latestSpec.getVersion().toString();
            }
            if (this.targetSchemaVersion.compareTo(this.startSchemaVersion) < 0) {
                throw new BuildException(MSG.getMsg("DBUpgrader.error-downgrading", new Object[]{this.startSchemaVersion, realTargetSchemaVersion}));
            }
            size = this.schemaSpecs.size();
            conn.setAutoCommit(false);
            SchemaVersion fromVersion = this.startSchemaVersion;
            for (int i = 0; i < size; ++i) {
                SchemaSpec ss = this.schemaSpecs.get(i);
                SchemaVersion toVersion = ss.getVersion();
                if (!this.shouldExecSpecVersion(toVersion)) continue;
                this.log(MSG.getMsg("DBUpgrader.upgrade-step", new Object[]{fromVersion, toVersion}));
                try {
                    this.markSchemaModificationInProgress(conn, this.databaseType, fromVersion, toVersion);
                    ss.initialize(conn, this);
                    ss.execute();
                    this.updateSchemaVersion(conn, this.databaseType, toVersion.toString());
                    conn.commit();
                    this.log(MSG.getMsg("DBUpgrader.upgrade-step-done", new Object[]{fromVersion, toVersion}));
                    fromVersion = toVersion;
                    continue;
                }
                catch (Exception e) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception e2) {
                        this.log("rollback() exception: " + e2.toString());
                    }
                    throw new BuildException(MSG.getMsg("DBUpgrader.upgrade-step-error", new Object[]{ss.getVersion(), e}), (Throwable)e);
                }
            }
            if (this.targetSchemaVersion.getIsLatest()) {
                this.updateSchemaVersion(conn, this.databaseType, realTargetSchemaVersion);
                conn.commit();
            }
            this.log(MSG.getMsg("DBUpgrader.success", new Object[]{realTargetSchemaVersion}));
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null && this.databaseType != null && this.doCloseConnection) {
                this.databaseType.closeConnection(conn);
            }
        }
    }

    protected boolean shouldExecSpecVersion(SchemaVersion version) {
        return version.getIsLatest() || version.between(this.startSchemaVersion, this.targetSchemaVersion);
    }

    private void validateAttributes() throws BuildException {
        if (this.jdbcUrl == null) {
            throw new BuildException(MSG.getMsg("DBUpgrader.no-jdbc-url", new Object[0]));
        }
        if (this.typeMapFile == null) {
            this.typeMaps = TypeMap.loadKnownTypeMaps();
        } else {
            try {
                FileInputStream fis = new FileInputStream(this.typeMapFile);
                this.typeMaps = TypeMap.loadTypeMapsFromStream(fis);
            }
            catch (Exception e) {
                throw new BuildException(MSG.getMsg("DBUpgrader.type-map-file-error", new Object[]{this.typeMapFile.getAbsolutePath(), e}), (Throwable)e);
            }
        }
        if (this.targetSchemaVersionString == null) {
            throw new BuildException(MSG.getMsg("DBUpgrader.no-version", new Object[0]));
        }
        try {
            this.targetSchemaVersion = new SchemaVersion(this.targetSchemaVersionString);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException(MSG.getMsg("DBUpgrader.invalid-version", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private String loadStartSchemaVersion(Connection c, DatabaseType db_type) throws BuildException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "SELECT " + this.valueColumn + " " + "FROM " + this.tableName + " " + "WHERE " + this.keyColumn + " = ? ";
        try {
            ps = c.prepareStatement(sql);
            ps.setString(1, this.keyMatch);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new BuildException(MSG.getMsg("DBUpgrader.error-missing-version", new Object[]{this.tableName, this.valueColumn, this.keyColumn}));
            }
            String versionString = rs.getString(1);
            if (rs.next()) {
                throw new BuildException(MSG.getMsg("DBUpgrader.error-duplicate-version", new Object[]{this.tableName, this.valueColumn, this.keyColumn}));
            }
            String string = versionString;
            db_type.closeStatement(ps);
            db_type.closeResultSet(rs);
            return string;
        }
        catch (SQLException e) {
            try {
                throw new BuildException(MSG.getMsg("DBUpgrader.error-loading-start-version", new Object[]{e}), (Throwable)e);
            }
            catch (Throwable throwable) {
                db_type.closeStatement(ps);
                db_type.closeResultSet(rs);
                throw throwable;
            }
        }
    }

    private void markSchemaModificationInProgress(Connection conn, DatabaseType db_type, SchemaVersion fromVersion, SchemaVersion toVersion) throws BuildException {
        String versionString = fromVersion.toString() + SCHEMA_MOD_IN_PROGRESS + toVersion.toString();
        this.updateSchemaVersion(conn, db_type, versionString);
    }

    private void updateSchemaVersion(Connection conn, DatabaseType db_type, String version) throws BuildException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        String sql = "UPDATE " + this.tableName + " " + "SET " + this.valueColumn + " = ? " + "WHERE " + this.keyColumn + " = ? ";
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, version);
            ps.setString(2, this.keyMatch);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BuildException(MSG.getMsg("DBUpgrader.error-updating-version", new Object[]{version, e}), (Throwable)e);
        }
        finally {
            db_type.closeStatement(ps);
            db_type.closeResultSet(rs);
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = DbUtil.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
        }
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.doCloseConnection = connection == null;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

