/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.setup.DBSetup;
import org.rhq.core.db.setup.DataSet;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class View {
    private DBSetup m_parent;
    private String m_strName;
    private String m_strQuery;
    private DataSet m_dataset;

    protected View(Node node, DatabaseType dbtype, DBSetup dbsetup) throws SAXException {
        this.m_parent = dbsetup;
        boolean queryIsSet = false;
        if (View.isView(node)) {
            NamedNodeMap map = node.getAttributes();
            for (int iTab = 0; iTab < map.getLength(); ++iTab) {
                Node nodeMap = map.item(iTab);
                if (nodeMap.getNodeName().equalsIgnoreCase("name")) {
                    this.m_strName = nodeMap.getNodeValue();
                    continue;
                }
                System.out.println("Unknown attribute '" + nodeMap.getNodeName() + "' in tag 'table'");
            }
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (!child.getNodeName().equalsIgnoreCase("query") || !child.hasChildNodes()) continue;
                this.m_strQuery = child.getFirstChild().getNodeValue();
                queryIsSet = true;
            }
            if (!queryIsSet) {
                throw new SAXException("no query specified");
            }
        } else {
            throw new SAXException("node is not a table.");
        }
    }

    protected void create(Collection typemaps) throws SQLException {
        Vector commands = new Vector();
        this.getCreateCommands(commands, typemaps, this.m_parent.getDatabaseType());
        for (String strCmd : commands) {
            this.m_parent.doSQL(strCmd);
        }
    }

    private void doCmd(List collCmds) throws SQLException {
        for (String strCmd : collCmds) {
            this.m_parent.doSQL(strCmd);
        }
    }

    protected void drop() throws SQLException {
        ArrayList collCmds = new ArrayList();
        this.getDropCommands(collCmds);
        this.doCmd(collCmds);
    }

    protected void getCreateCommands(List cmds, Collection typemaps, DatabaseType dbtype) {
        String strCmd = "CREATE VIEW " + this.getName() + " AS " + this.getQuery();
        cmds.add(0, strCmd);
    }

    protected DataSet getDataSet() {
        return this.m_dataset;
    }

    protected void getDropCommands(List cmds) {
        String strCmd = "DROP VIEW " + this.getName();
        cmds.add(strCmd);
    }

    protected String getQueryCommand() {
        String strCmd = "SELECT * ";
        strCmd = strCmd + "FROM " + this.getName();
        return strCmd;
    }

    protected String getName() {
        return this.m_strName.toUpperCase();
    }

    protected String getQuery() {
        return this.m_strQuery;
    }

    protected static List<View> getViews(Node node, DatabaseType dbtype, DBSetup parent) {
        ArrayList<View> colResult = new ArrayList<View>();
        NodeList listViews = node.getChildNodes();
        for (int i = 0; i < listViews.getLength(); ++i) {
            Node nodeView = listViews.item(i);
            if (!View.isView(nodeView)) continue;
            try {
                colResult.add(new View(nodeView, dbtype, parent));
                continue;
            }
            catch (SAXException e) {
                // empty catch block
            }
        }
        return colResult;
    }

    protected static boolean isView(Node nodeTable) {
        return nodeTable.getNodeName().equalsIgnoreCase("view");
    }

    protected DBSetup getDBSetup() {
        return this.m_parent;
    }

    protected static void uninstallCleanup(DBSetup parent) throws SQLException {
    }
}

