/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.availability;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.util.exception.ThrowableUtil;

public class AvailabilityCollectorRunnable
implements Runnable {
    private static final Log log = LogFactory.getLog(AvailabilityCollectorRunnable.class);
    public static final long MIN_INTERVAL = 60000L;
    private final Executor threadPool;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ClassLoader contextClassloader;
    private final AvailabilityFacet availabilityChecker;
    private final long interval;
    private AtomicReference<AvailabilityType> lastKnownAvailability = new AtomicReference();
    private final String facetId;

    public AvailabilityCollectorRunnable(AvailabilityFacet availabilityChecker, long interval, ClassLoader contextClassloader, Executor threadPool) {
        if (availabilityChecker == null) {
            throw new IllegalArgumentException("availabilityChecker is null");
        }
        if (threadPool == null) {
            throw new IllegalArgumentException("threadPool is null");
        }
        if (interval < 60000L) {
            log.info((Object)("Interval is too short [" + interval + "] - setting to minimum of [" + 60000L + "]"));
            interval = 60000L;
        }
        if (contextClassloader == null) {
            contextClassloader = Thread.currentThread().getContextClassLoader();
        }
        this.threadPool = threadPool;
        this.availabilityChecker = availabilityChecker;
        this.contextClassloader = contextClassloader;
        this.interval = interval;
        this.lastKnownAvailability.set(AvailabilityType.DOWN);
        this.facetId = availabilityChecker.toString();
    }

    public AvailabilityType getLastKnownAvailability() {
        return this.lastKnownAvailability.get();
    }

    public void start() {
        boolean isStarted = this.started.getAndSet(true);
        if (isStarted) {
            log.debug((Object)("Availability collector runnable [" + this.facetId + "] is already started"));
        } else {
            this.threadPool.execute(this);
            log.debug((Object)("Availability collector runnable [" + this.facetId + "] submitted to thread pool"));
        }
    }

    public void stop() {
        this.started.set(false);
        log.debug((Object)("Availability collector runnable [" + this.facetId + "] was told to stop"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug((Object)("Availability collector runnable [" + this.facetId + "] started"));
        ClassLoader originalClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.contextClassloader);
        try {
            do {
                try {
                    AvailabilityType availability = this.availabilityChecker.getAvailability();
                    this.lastKnownAvailability.set(availability);
                }
                catch (Throwable t) {
                    log.warn((Object)("Availability collector [" + this.facetId + "] failed to get availability - keeping the last known availability of [" + this.lastKnownAvailability.get() + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    this.started.set(false);
                    log.debug((Object)("Availability collector [" + this.facetId + "] interrupted"));
                }
            } while (this.started.get());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassloader);
        }
        log.debug((Object)("Availability collector runnable [" + this.facetId + "] stopped"));
    }
}

