/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.util.OSGiVersionComparator;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.apache.parser.ApacheDirective;
import org.rhq.plugins.apache.parser.ApacheDirectiveTree;
import org.rhq.plugins.apache.util.ApacheBinaryInfo;

public class RuntimeApacheConfiguration {
    private static final Log LOG = LogFactory.getLog(RuntimeApacheConfiguration.class);

    private RuntimeApacheConfiguration() {
    }

    public static ApacheDirectiveTree extract(ApacheDirectiveTree tree, ProcessInfo httpdProcessInfo, ApacheBinaryInfo httpdBinaryInfo, Map<String, String> moduleNames) {
        ApacheDirectiveTree ret = tree.clone();
        ArrayList<String> defines = new ArrayList<String>(httpdBinaryInfo.getCompiledInDefines());
        if (httpdProcessInfo != null) {
            String[] args = httpdProcessInfo.getCommandLine();
            for (int i = 1; i < args.length; ++i) {
                String define = null;
                if (args[i] != null && args[i].startsWith("-D")) {
                    define = args[i].substring(2).trim();
                }
                if (define != null && define.isEmpty()) {
                    if (i < args.length - 1) {
                        define = args[i + 1].trim();
                        if (define.startsWith("-")) {
                            define = null;
                        } else {
                            ++i;
                        }
                    } else {
                        define = null;
                    }
                }
                if (define == null) continue;
                defines.add(define);
            }
        }
        HashSet<String> loadedModules = new HashSet<String>();
        loadedModules.addAll(httpdBinaryInfo.getCompiledInModules());
        HashMap<String, String> moduleFiles = new HashMap<String, String>(moduleNames.size());
        for (Map.Entry<String, String> e : moduleNames.entrySet()) {
            moduleFiles.put(e.getValue(), e.getKey());
        }
        RuntimeApacheConfiguration.transform(ret.getRootNode(), loadedModules, defines, moduleNames, moduleFiles, httpdBinaryInfo.getVersion());
        return ret;
    }

    private static void transform(ApacheDirective parentNode, Set<String> currentlyLoadedModules, List<String> defines, Map<String, String> moduleNames, Map<String, String> moduleFiles, String httpdVersion) {
        if (parentNode.getChildDirectives().isEmpty()) {
            return;
        }
        ArrayList<ApacheDirective> nodesToRemove = new ArrayList<ApacheDirective>();
        ArrayList<ApacheDirective> nodesToPromote = new ArrayList<ApacheDirective>();
        block5: for (ApacheDirective node : parentNode.getChildDirectives()) {
            boolean result;
            if (node.getName().equalsIgnoreCase("LoadModule")) {
                currentlyLoadedModules.add(node.getValues().get(0));
            } else if (node.getName().equalsIgnoreCase("<IfModule")) {
                String moduleFile = node.getValuesAsString();
                boolean negate = false;
                if (moduleFile.startsWith("!")) {
                    negate = true;
                    moduleFile = moduleFile.substring(1);
                }
                result = false;
                switch (RuntimeApacheConfiguration.isModuleLoaded(moduleFile, currentlyLoadedModules, moduleNames, moduleFiles)) {
                    case LOADED: {
                        result = true;
                        break;
                    }
                    case NOT_LOADED: {
                        result = false;
                        break;
                    }
                    case UNKNOWN: {
                        LOG.warn((Object)("Encountered unknown module name in an IfModule directive: " + moduleFile));
                        continue block5;
                    }
                }
                if (result != negate) {
                    nodesToPromote.add(node);
                } else {
                    nodesToRemove.add(node);
                }
            } else if (node.getName().equalsIgnoreCase("<IfDefine")) {
                String define = node.getValuesAsString();
                boolean negate = false;
                if (define.startsWith("!")) {
                    negate = true;
                    define = define.substring(1);
                }
                if (negate != (result = defines.contains(define))) {
                    nodesToPromote.add(node);
                } else {
                    nodesToRemove.add(node);
                }
            } else if (node.getName().equalsIgnoreCase("<IfVersion")) {
                if (RuntimeApacheConfiguration.isModuleLoaded("mod_version.c", currentlyLoadedModules, moduleNames, moduleFiles) != ModuleLoadedState.LOADED) {
                    LOG.debug((Object)"mod_version not loaded and IfVersion directive encountered. Skipping it.");
                    continue;
                }
                List<String> values = node.getValues();
                String operator = null;
                String version = null;
                boolean negate = false;
                boolean regex = false;
                if (values.size() == 0) {
                    LOG.warn((Object)"Invalid IfVersion directive.");
                    continue;
                }
                if (values.size() == 1) {
                    operator = "=";
                    version = values.get(0);
                } else if (values.size() == 2) {
                    operator = values.get(0);
                    version = values.get(1);
                } else {
                    LOG.warn((Object)("Too many arguments to a IfVersion directive: " + values));
                    continue;
                }
                if (operator == null || version == null) {
                    LOG.warn((Object)("Invalid IfVersion with parameters: " + values));
                    continue;
                }
                if (operator.charAt(0) == '!') {
                    negate = true;
                    operator = operator.substring(1);
                }
                if ("==".equals(operator)) {
                    operator = "=";
                }
                if (version.charAt(0) == '/') {
                    if ("=".equals(operator) || "~".equals(operator)) {
                        regex = true;
                        version = version.substring(1, version.length() - 1);
                    } else {
                        LOG.warn((Object)("Unsupported operator " + operator + " with regex version comparison in IfVersion directive."));
                        continue;
                    }
                }
                OSGiVersionComparator comp = new OSGiVersionComparator();
                boolean result2 = false;
                if ("=".equals(operator)) {
                    result2 = regex ? Pattern.matches(version, httpdVersion) : comp.compare(version, httpdVersion) == 0;
                } else if ("~".equals(operator)) {
                    result2 = Pattern.matches(version, httpdVersion);
                } else if (">".equals(operator)) {
                    result2 = comp.compare(httpdVersion, version) > 0;
                } else if (">=".equals(operator)) {
                    result2 = comp.compare(httpdVersion, version) >= 0;
                } else if ("<".equals(operator)) {
                    result2 = comp.compare(httpdVersion, version) < 0;
                } else if ("<=".equals(operator)) {
                    result2 = comp.compare(httpdVersion, version) <= 0;
                } else {
                    LOG.warn((Object)("Unknown operator " + operator + " in an IfVersion directive."));
                    continue;
                }
                if (negate != result2) {
                    nodesToPromote.add(node);
                } else {
                    nodesToRemove.add(node);
                }
            }
            RuntimeApacheConfiguration.transform(node, currentlyLoadedModules, defines, moduleNames, moduleFiles, httpdVersion);
        }
        for (ApacheDirective node : nodesToRemove) {
            parentNode.getChildDirectives().remove(node);
        }
        for (ApacheDirective node : nodesToPromote) {
            int nodeIdx = parentNode.getChildDirectives().indexOf(node);
            List<ApacheDirective> childNodes = node.getChildDirectives();
            for (int i = childNodes.size() - 1; i >= 0; --i) {
                ApacheDirective childNode = childNodes.get(i);
                parentNode.getChildDirectives().add(nodeIdx, childNode);
                childNode.setParentNode(parentNode);
            }
            parentNode.getChildDirectives().remove(nodeIdx + childNodes.size());
        }
    }

    private static ModuleLoadedState isModuleLoaded(String moduleIdentifier, Set<String> currentlyLoadedModules, Map<String, String> moduleNames, Map<String, String> moduleFiles) {
        String moduleName = moduleNames.get(moduleIdentifier);
        if (moduleName == null && (moduleIdentifier = moduleFiles.get(moduleName = moduleIdentifier)) == null && !currentlyLoadedModules.contains(moduleName)) {
            return ModuleLoadedState.UNKNOWN;
        }
        boolean result = currentlyLoadedModules.contains(moduleIdentifier) || currentlyLoadedModules.contains(moduleName);
        return result ? ModuleLoadedState.LOADED : ModuleLoadedState.NOT_LOADED;
    }

    private static enum ModuleLoadedState {
        LOADED,
        NOT_LOADED,
        UNKNOWN;

    }
}

