/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.parser;

import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.parser.RssParseException;
import churchillobjects.rss4j.parser.RssParserImpl090;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class RssParserImpl091
extends RssParserImpl090 {
    protected boolean inSkipDays = false;
    protected boolean inSkipHours = false;
    private static final String VERSION = "0.91";

    RssParserImpl091(RssDocument document, Vector namespaces) {
        super(document, namespaces);
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        super.startElement(uri, name, qName, attrs);
        if ("skipDays".equals(name)) {
            this.inSkipDays = true;
        }
        if ("skipHours".equals(name)) {
            this.inSkipHours = true;
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        try {
            super.endElement(uri, name, qName);
            if ("skipDays".equals(name)) {
                this.inSkipDays = false;
            }
            if ("skipHours".equals(name)) {
                this.inSkipHours = false;
            }
            if (!this.hasChars()) {
                return;
            }
            if ("day".equals(name) && this.inSkipDays) {
                this.currentChannel.addSkipDay(this.getChars());
            }
            if ("hour".equals(name) && this.inSkipHours) {
                this.handleHour();
            }
            if (this.inChannel && !this.inImage && !this.inItem && !this.inTextInput) {
                this.handleChannelAttributes(name);
            }
            if (this.inImage) {
                this.handleImageAttributes(name);
            }
            if (this.inItem && "description".equals(name)) {
                this.currentItem.setItemDescription(this.getChars());
            }
            if (VERSION.equals(this.document.getVersion())) {
                this.resetChars();
            }
        }
        catch (RssParseException e) {
            throw new SAXException(e);
        }
    }

    private void handleHour() throws RssParseException {
        try {
            int hour = Integer.parseInt(this.getChars());
            this.currentChannel.addSkipHour(hour);
        }
        catch (NumberFormatException e) {
            throw new RssParseException(e);
        }
    }

    private void handleChannelAttributes(String name) {
        if ("language".equals(name)) {
            this.currentChannel.setChannelLanguage(this.getChars());
        }
        if ("rating".equals(name)) {
            this.currentChannel.setChannelPicsRating(this.getChars());
        }
        if ("copyright".equals(name)) {
            this.currentChannel.setChannelCopyright(this.getChars());
        }
        if ("pubDate".equals(name)) {
            this.currentChannel.setChannelPubDate(this.getChars());
        }
        if ("lastBuildDate".equals(name)) {
            this.currentChannel.setChannelLastBuildDate(this.getChars());
        }
        if ("docs".equals(name)) {
            this.currentChannel.setChannelDocs(this.getChars());
        }
        if ("managingEditor".equals(name)) {
            this.currentChannel.setChannelManagingEditor(this.getChars());
        }
        if ("webMaster".equals(name)) {
            this.currentChannel.setChannelWebmaster(this.getChars());
        }
    }

    private void handleImageAttributes(String name) throws RssParseException {
        if ("width".equals(name)) {
            try {
                int width = Integer.parseInt(this.getChars());
                this.currentImage.setImageWidth(width);
            }
            catch (NumberFormatException e) {
                throw new RssParseException(e);
            }
        }
        if ("height".equals(name)) {
            try {
                int height = Integer.parseInt(this.getChars());
                this.currentImage.setImageHeight(height);
            }
            catch (NumberFormatException e) {
                throw new RssParseException(e);
            }
        }
        if ("description".equals(name)) {
            this.currentImage.setImageDescription(this.getChars());
        }
    }
}

