/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.parser;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.RssDublinCore;
import churchillobjects.rss4j.RssJbnDependency;
import churchillobjects.rss4j.RssJbnPatch;
import churchillobjects.rss4j.RssSyndication;
import churchillobjects.rss4j.model.IUsesDublinCore;
import churchillobjects.rss4j.model.IUsesJbnPatch;
import churchillobjects.rss4j.model.IUsesSyndication;
import churchillobjects.rss4j.model.RssNamespace;
import churchillobjects.rss4j.parser.RssParseException;
import churchillobjects.rss4j.parser.RssParserImpl090;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class RssParserImpl100
extends RssParserImpl090 {
    private static final String VERSION = "1.0";
    private Hashtable itemMappings = new Hashtable();
    private Hashtable imageMappings = new Hashtable();
    private Hashtable textInputMappings = new Hashtable();
    private Vector unmappedItems = new Vector();
    private Vector unmappedImages = new Vector();
    private Vector unmappedTextInputs = new Vector();
    private boolean inChannelItems = false;
    private boolean inChannelItemsSeq = false;
    private boolean inJbnProducts = false;
    private RssJbnDependency currentJbnDependency = null;
    private boolean inJbnRequires = false;
    private boolean inJbnReplaces = false;
    private boolean inJbnIsReplacedBy = false;
    private boolean inJbnCompatibleWith = false;

    RssParserImpl100(RssDocument document, Vector namespaces) {
        super(document, namespaces);
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        try {
            if ("channel".equals(name)) {
                this.handleChannel(uri, name, qName, attrs);
            }
            if ("item".equals(name) || "rdf:li".equals(qName)) {
                this.handleItem(uri, name, qName, attrs);
            }
            if ("textinput".equals(name)) {
                this.handleTextInput(uri, name, qName, attrs);
            }
            if ("image".equals(name)) {
                this.handleImage(uri, name, qName, attrs);
            }
            if ("items".equals(qName) && this.inChannel) {
                this.inChannelItems = true;
            }
            if ("rdf:Seq".equals(qName) && this.inChannel && this.inChannelItems) {
                this.inChannelItemsSeq = true;
            }
            if ("jbn:products".equals(qName) || "jbn:product".equals(qName) || "jbn:requires".equals(qName) || "jbn:replaces".equals(qName) || "jbn:isReplacedBy".equals(qName) || "jbn:patch".equals(qName)) {
                this.handleEmbeddedElement(uri, name, qName, attrs);
            }
        }
        catch (RssParseException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        try {
            if ("channel".equals(qName)) {
                this.currentChannel = null;
                this.inChannel = false;
            }
            if ("item".equals(qName) && !this.inChannel) {
                this.currentItem = null;
                this.inItem = false;
            }
            if ("textinput".equals(qName) && !this.inChannel) {
                this.currentTextInput = null;
                this.inTextInput = false;
            }
            if ("image".equals(qName) && !this.inChannel) {
                this.currentImage = null;
                this.inImage = false;
            }
            if ("items".equals(qName) && this.inChannel) {
                this.inChannelItems = false;
            }
            if ("rdf:Seq".equals(qName) && this.inChannel && this.inChannelItems) {
                this.inChannelItemsSeq = false;
            }
            if (this.inItem && this.inJbnProducts && "jbn:products".equals(qName)) {
                this.inJbnProducts = false;
                this.currentJbnDependency = null;
            }
            if (this.inItem && this.inJbnReplaces && "jbn:replaces".equals(qName)) {
                this.inJbnReplaces = false;
                this.currentJbnDependency = null;
            }
            if (this.inItem && this.inJbnRequires && "jbn:requires".equals(qName)) {
                this.inJbnRequires = false;
                this.currentJbnDependency = null;
            }
            if (this.inItem && this.inJbnIsReplacedBy && "jbn:isReplacedBy".equals(qName)) {
                this.inJbnIsReplacedBy = false;
                this.currentJbnDependency = null;
            }
            if (this.inItem && this.inJbnCompatibleWith && "jbn:compatibleWith".equals(qName)) {
                this.inJbnCompatibleWith = false;
                this.currentJbnDependency = null;
            }
            if (!this.hasChars()) {
                return;
            }
            if (this.inChannel && !this.inImage && !this.inItem && !this.inTextInput) {
                this.addChannelAttribute(name, qName);
            }
            if (this.inImage) {
                this.addImageAttribute(name, qName);
            }
            if (this.inItem) {
                this.addItemAttribute(name, qName);
            }
            if (this.inTextInput) {
                this.addTextInputAttribute(name, qName);
            }
            if (this.inItem && (this.inJbnProducts || this.inJbnReplaces || this.inJbnRequires || this.inJbnIsReplacedBy || this.inJbnCompatibleWith) && ("jbn:product".equals(qName) || "jbn:patch".equals(qName))) {
                this.currentJbnDependency = null;
            }
            this.resetChars();
        }
        catch (RssParseException e) {
            throw new SAXException(e);
        }
    }

    private void addTextInputAttribute(String name, String qName) throws RssParseException {
        String value = this.getChars();
        if ("title".equals(qName)) {
            this.currentTextInput.setInputTitle(value);
        }
        if ("description".equals(qName)) {
            this.currentTextInput.setInputDescription(value);
        }
        if ("name".equals(qName)) {
            this.currentTextInput.setInputName(value);
        }
        if ("link".equals(qName)) {
            this.currentTextInput.setInputLink(value);
        }
        if (qName.startsWith("dc:")) {
            this.handleDublinCore(this.currentTextInput, name, value);
        }
        if (qName.startsWith("jbn:")) {
            this.handleJbnPatch(this.currentTextInput, name, value);
        }
    }

    private void addItemAttribute(String name, String qName) throws RssParseException {
        String value = this.getChars();
        if ("title".equals(qName)) {
            this.currentItem.setItemTitle(value);
        }
        if ("link".equals(qName)) {
            this.currentItem.setItemLink(value);
        }
        if ("description".equals(qName)) {
            this.currentItem.setItemDescription(value);
        }
        if (qName.startsWith("dc:")) {
            this.handleDublinCore(this.currentItem, name, value);
        }
        if (qName.startsWith("jbn:")) {
            this.handleJbnPatch(this.currentItem, name, value);
        }
    }

    private void addImageAttribute(String name, String qName) throws RssParseException {
        String value = this.getChars();
        if ("title".equals(name)) {
            this.currentImage.setImageTitle(value);
        }
        if ("url".equals(name)) {
            this.currentImage.setImageUrl(value);
        }
        if ("link".equals(name)) {
            this.currentImage.setImageLink(value);
        }
        if (qName.startsWith("dc:")) {
            this.handleDublinCore(this.currentImage, name, value);
        }
        if (qName.startsWith("jbn:")) {
            this.handleJbnPatch(this.currentItem, name, value);
        }
    }

    private void addChannelAttribute(String name, String qName) throws RssParseException {
        String value = this.getChars();
        if ("title".equals(qName)) {
            this.currentChannel.setChannelTitle(value);
        }
        if ("link".equals(qName)) {
            this.currentChannel.setChannelLink(value);
        }
        if ("description".equals(qName)) {
            this.currentChannel.setChannelDescription(value);
        }
        if (qName.startsWith("sy:")) {
            this.handleSyndication(this.currentChannel, name, value);
        }
        if (qName.startsWith("dc:")) {
            this.handleDublinCore(this.currentChannel, name, value);
        }
        if (qName.startsWith("jbn:")) {
            this.handleJbnPatch(this.currentItem, name, value);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.checkForLeftovers();
        }
        catch (RssParseException e) {
            throw new SAXException(e);
        }
    }

    protected void handleChannel(String uri, String name, String qName, Attributes attrs) throws RssParseException {
        this.currentChannel = new RssChannel();
        String about = this.getAttributeUnqualified(name, "about", "rdf", attrs);
        this.currentChannel.setChannelUri(about);
        this.document.addChannel(this.currentChannel);
        this.inChannel = true;
    }

    protected void handleItem(String uri, String name, String qName, Attributes attrs) throws RssParseException {
        if ("item".equals(name) && !this.inChannel) {
            String about = this.getAttributeUnqualified(name, "about", "rdf", attrs);
            this.currentItem = (RssChannelItem)this.itemMappings.get(about);
            if (this.currentItem == null) {
                this.document.addWarning("Encountered an <item> element under <rdf:RDF> that was not used in a preceding channel: " + about);
            } else {
                this.unmappedItems.removeElement(about);
                this.inItem = true;
            }
        } else if ("rdf:li".equals(qName) && this.inChannel && this.inChannelItems && this.inChannelItemsSeq) {
            String resource = this.getAttributeUnqualified(qName, "resource", "rdf", attrs);
            RssChannelItem item = new RssChannelItem();
            this.currentChannel.addItem(item);
            this.itemMappings.put(resource, item);
            this.unmappedItems.addElement(resource);
        }
    }

    protected void handleEmbeddedElement(String uri, String name, String qName, Attributes attrs) throws RssParseException {
        if (this.inJbnProducts && "jbn:product".equals(qName) || (this.inJbnReplaces || this.inJbnRequires || this.inJbnIsReplacedBy || this.inJbnCompatibleWith) && "jbn:patch".equals(qName)) {
            this.currentJbnDependency = new RssJbnDependency();
            this.currentJbnDependency.setUrl(this.getAttributeUnqualified(qName, "about", "rdf", attrs));
            if ("jbn:product".equals(qName)) {
                this.currentJbnDependency.setProductName(this.getAttributeUnqualified(qName, "productName", "jbn", attrs));
                this.currentJbnDependency.setProductVersion(this.getAttributeUnqualified(qName, "productVersion", "jbn", attrs));
                this.currentJbnDependency.setJonResourceType(this.getAttributeUnqualified(qName, "jonResourceType", "jbn", attrs));
                this.currentJbnDependency.setJonResourceVersion(this.getAttributeUnqualified(qName, "jonResourceVersion", "jbn", attrs));
            }
        } else if ("jbn:products".equals(qName)) {
            this.inJbnProducts = true;
        } else if ("jbn:replaces".equals(qName)) {
            this.inJbnReplaces = true;
        } else if ("jbn:requires".equals(qName)) {
            this.inJbnRequires = true;
        } else if ("jbn:isReplacedBy".equals(qName)) {
            this.inJbnIsReplacedBy = true;
        } else if ("jbn:compatibleWith".equals(qName)) {
            this.inJbnCompatibleWith = true;
        }
    }

    protected void handleTextInput(String uri, String name, String qName, Attributes attrs) throws RssParseException {
        if (this.inChannel) {
            RssChannelTextInput textInput = new RssChannelTextInput();
            String resource = this.getAttributeUnqualified(name, "resource", "rdf", attrs);
            this.textInputMappings.put(resource, textInput);
            this.unmappedTextInputs.addElement(resource);
            this.currentChannel.setChannelTextInput(textInput);
        } else {
            String about = this.getAttributeUnqualified(name, "about", "rdf", attrs);
            this.currentTextInput = (RssChannelTextInput)this.textInputMappings.get(about);
            if (this.currentTextInput == null) {
                this.document.addWarning("Encountered a <textinput> element under <rdf:RDF> that was not used in a preceding channel: " + about);
            } else {
                this.unmappedTextInputs.removeElement(about);
                this.inTextInput = true;
            }
        }
    }

    protected void handleImage(String uri, String name, String qName, Attributes attrs) throws RssParseException {
        if (this.inChannel) {
            RssChannelImage image = new RssChannelImage();
            String resource = this.getAttributeUnqualified(name, "resource", "rdf", attrs);
            this.imageMappings.put(resource, image);
            this.unmappedImages.addElement(resource);
            this.currentChannel.setChannelImage(image);
        } else {
            String about = this.getAttributeUnqualified(name, "about", "rdf", attrs);
            this.currentImage = (RssChannelImage)this.imageMappings.get(about);
            if (this.currentImage == null) {
                this.document.addWarning("Encountered an <image> element under <rdf:RDF> that was not used in a preceding channel: " + about);
            } else {
                this.unmappedImages.removeElement(about);
                this.inImage = true;
            }
        }
    }

    protected void handleSyndication(IUsesSyndication synobj, String name, String value) throws RssParseException {
        this.checkSyndication();
        RssSyndication syn = synobj.getChannelSyndication();
        if (syn == null) {
            syn = new RssSyndication();
            synobj.setChannelSyndication(syn);
        }
        if ("updatePeriod".equals(name)) {
            syn.setUpdatePeriod(value);
        }
        if ("updateFrequency".equals(name)) {
            syn.setUpdateFrequency(Integer.parseInt(value));
        }
        if ("updateBase".equals(name)) {
            try {
                syn.setUpdateBase(value);
            }
            catch (ParseException e) {
                throw new RssParseException("Syndication update base date value not convertible from ISO8601: '" + value + "'");
            }
        }
    }

    protected void handleDublinCore(IUsesDublinCore dcobj, String name, String value) throws RssParseException {
        this.checkDublinCore();
        RssDublinCore dc = dcobj.getDublinCore();
        if (dc == null) {
            dc = new RssDublinCore();
            dcobj.setDublinCore(dc);
        }
        if ("title".equals(name)) {
            dc.setTitle(value);
        }
        if ("creator".equals(name)) {
            dc.setCreator(value);
        }
        if ("subject".equals(name)) {
            dc.setSubject(value);
        }
        if ("description".equals(name)) {
            dc.setDescription(value);
        }
        if ("publisher".equals(name)) {
            dc.setPublisher(value);
        }
        if ("contributor".equals(name)) {
            dc.setContributor(value);
        }
        if ("date".equals(name)) {
            try {
                dc.setDate(value);
            }
            catch (ParseException e) {
                throw new RssParseException(e);
            }
        }
        if ("type".equals(name)) {
            dc.setType(value);
        }
        if ("format".equals(name)) {
            dc.setFormat(value);
        }
        if ("identifier".equals(name)) {
            dc.setIdentifier(value);
        }
        if ("source".equals(name)) {
            dc.setSource(value);
        }
        if ("language".equals(name)) {
            dc.setLanguage(value);
        }
        if ("relation".equals(name)) {
            dc.setRelation(value);
        }
        if ("coverage".equals(name)) {
            dc.setCoverage(value);
        }
        if ("rights".equals(name)) {
            dc.setRights(value);
        }
    }

    protected void handleJbnPatch(IUsesJbnPatch dcobj, String name, String value) throws RssParseException {
        this.checkJbnPatch();
        RssJbnPatch jbn = dcobj.getJbnPatch();
        if (jbn == null) {
            jbn = new RssJbnPatch();
            dcobj.setJbnPatch(jbn);
        }
        if ("type".equals(name)) {
            jbn.setType(value);
        } else if ("creator".equals(name)) {
            jbn.setCreator(value);
        } else if ("jira".equals(name)) {
            jbn.setJira(value);
        } else if ("md5".equals(name)) {
            jbn.setMd5(value);
        } else if ("sha256".equals(name)) {
            jbn.setSha256(value);
        } else if ("fileName".equals(name)) {
            jbn.setFileName(value);
        } else if ("fileSize".equals(name)) {
            jbn.setFileSize(value);
        } else if ("downloadUrl".equals(name)) {
            jbn.setDownloadUrl(value);
        } else if ("automatedDownloadUrl".equals(name)) {
            jbn.setAutomatedDownloadUrl(value);
        } else if ("instructionCompatibilityVersion".equals(name)) {
            jbn.setInstructionCompatibilityVersion(value);
        } else if ("longDescription".equals(name)) {
            jbn.setLongDescription(value);
        } else if ("shortDescription".equals(name)) {
            jbn.setShortDescription(value);
        } else if ("manualInstallation".equals(name)) {
            jbn.setManualInstallation(value);
        } else if ("automatedInstallation".equals(name)) {
            jbn.setAutomatedInstallation(value);
        } else if ("caseId".equals(name)) {
            jbn.setCaseId(value);
        } else if ("licenseName".equals(name)) {
            jbn.setLicenseName(value);
        } else if ("licenseVersion".equals(name)) {
            jbn.setLicenseVersion(value);
        } else if ("distributionStatus".equals(name)) {
            jbn.setDistributionStatus(value);
        } else if ("lastUpdated".equals(name)) {
            try {
                jbn.setLastUpdated(value);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else if (this.inJbnProducts && "product".equals(name)) {
            this.currentJbnDependency.setName(value);
            jbn.addProduct(this.currentJbnDependency);
        } else if (this.inJbnRequires && "patch".equals(name)) {
            this.currentJbnDependency.setName(value);
            jbn.addRequires(this.currentJbnDependency);
        } else if (this.inJbnReplaces && "patch".equals(name)) {
            this.currentJbnDependency.setName(value);
            jbn.addReplaces(this.currentJbnDependency);
        } else if (this.inJbnIsReplacedBy && "patch".equals(name)) {
            this.currentJbnDependency.setName(value);
            jbn.addReplacedBy(this.currentJbnDependency);
        } else if (this.inJbnCompatibleWith && "patch".equals(name)) {
            this.currentJbnDependency.setName(value);
            jbn.addReplacedBy(this.currentJbnDependency);
        }
    }

    protected String getAttributeUnqualified(String element, String attName, String prefix, Attributes attrs) throws RssParseException {
        String attrValue = this.getAttribute(attrs, prefix + ":" + attName);
        if (attrValue == null) {
            attrValue = this.getAttribute(attrs, attName);
            if (attrValue != null) {
                this.document.addWarning(element + ": The use of unqualified attributes (such as '" + attName + "' vs. '" + prefix + ":" + attName + "') is deprecated.");
            } else {
                throw new RssParseException(prefix + ":" + attName + " attribute not present on the <" + element + "> element");
            }
        }
        return attrValue;
    }

    protected void checkDublinCore() throws RssParseException {
        Enumeration enumeration = this.namespaces.elements();
        while (enumeration.hasMoreElements()) {
            RssNamespace ns = (RssNamespace)enumeration.nextElement();
            if (ns == null || !"dc".equals(ns.getPrefix()) || !"http://purl.org/dc/elements/1.1/".equals(ns.getUri())) continue;
            return;
        }
        throw new RssParseException("Elements were found using Dublin Core but its namespace (xmlns:dc=\"http://purl.org/dc/elements/1.1/\") was not specified in the document header");
    }

    protected void checkJbnPatch() throws RssParseException {
        Enumeration enumeration = this.namespaces.elements();
        while (enumeration.hasMoreElements()) {
            RssNamespace ns = (RssNamespace)enumeration.nextElement();
            if (ns == null || !"jbn".equals(ns.getPrefix()) || !"http://network.jboss.com/elements/1.0/".equals(ns.getUri())) continue;
            return;
        }
        throw new RssParseException("Elements were found using JBN Patch but its namespace (xmlns:jbn=\"http://network.jboss.com/elements/1.0/\") was not specified in the document header");
    }

    protected void checkSyndication() throws RssParseException {
        Enumeration enumeration = this.namespaces.elements();
        while (enumeration.hasMoreElements()) {
            RssNamespace ns = (RssNamespace)enumeration.nextElement();
            if (ns == null || !"sy".equals(ns.getPrefix()) || !"http://purl.org/rss/1.0/modules/syndication/".equals(ns.getUri())) continue;
            return;
        }
        throw new RssParseException("Elements were found using Syndication but its namespace (xmlns:sy=\"http://purl.org/rss/1.0/modules/syndication/\") was not specified in the document header");
    }

    private void checkForLeftovers() throws RssParseException {
        if (this.unmappedItems.size() > 0) {
            String resource = (String)this.unmappedItems.elements().nextElement();
            throw new RssParseException("Item was found in channel but had no corresponding resource: '" + resource + "'");
        }
        if (this.unmappedImages.size() > 0) {
            String resource = (String)this.unmappedImages.elements().nextElement();
            throw new RssParseException("Image was found in channel but had no corresponding resource: '" + resource + "'");
        }
        if (this.unmappedTextInputs.size() > 0) {
            String resource = (String)this.unmappedTextInputs.elements().nextElement();
            throw new RssParseException("TextInput was found in channel but had no corresponding resource: '" + resource + "'");
        }
    }
}

