/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MutablePDU;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.MutableStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;

public class MPv1
implements MessageProcessingModel {
    public static final int ID = 0;
    private static final LogAdapter logger = LogFactory.getLogger(MPv1.class);

    public int getID() {
        return 0;
    }

    public int prepareOutgoingMessage(Address address, int n, int n2, int n3, byte[] byArray, int n4, PDU pDU, boolean bl, PduHandle pduHandle, Address address2, BEROutputStream bEROutputStream) throws IOException {
        if (n4 != 1 || n3 != 1) {
            logger.error("MPv1 used with unsupported security model");
            return -1402;
        }
        if (pDU instanceof ScopedPDU) {
            String string = "ScopedPDU must not be used with MPv1";
            logger.error(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isProtocolVersionSupported(n2)) {
            logger.error("MPv1 used with unsupported SNMP version");
            return -1402;
        }
        OctetString octetString = new OctetString(byArray);
        Integer32 integer32 = new Integer32(n2);
        int n5 = pDU.getBERLength();
        n5 += octetString.getBERLength();
        ByteBuffer byteBuffer = ByteBuffer.allocate((n5 += integer32.getBERLength()) + BER.getBERLengthOfLength(n5) + 1);
        bEROutputStream.setBuffer(byteBuffer);
        BER.encodeHeader(bEROutputStream, 48, n5);
        integer32.encodeBER(bEROutputStream);
        octetString.encodeBER(bEROutputStream);
        pDU.encodeBER(bEROutputStream);
        return 0;
    }

    public int prepareResponseMessage(int n, int n2, int n3, byte[] byArray, int n4, PDU pDU, int n5, StateReference stateReference, StatusInformation statusInformation, BEROutputStream bEROutputStream) throws IOException {
        return this.prepareOutgoingMessage(stateReference.getAddress(), n2, n, n3, byArray, n4, pDU, false, stateReference.getPduHandle(), null, bEROutputStream);
    }

    public int prepareDataElements(MessageDispatcher messageDispatcher, Address address, BERInputStream bERInputStream, Integer32 integer32, Integer32 integer322, OctetString octetString, Integer32 integer323, MutablePDU mutablePDU, PduHandle pduHandle, Integer32 integer324, StatusInformation statusInformation, MutableStateReference mutableStateReference) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int n = BER.decodeHeader(bERInputStream, mutableByte);
        int n2 = (int)bERInputStream.getPosition();
        if (mutableByte.getValue() != 48) {
            String string = "SNMPv1 PDU must start with a SEQUENCE";
            logger.error(string);
            throw new IOException(string);
        }
        Integer32 integer325 = new Integer32();
        integer325.decodeBER(bERInputStream);
        octetString.decodeBER(bERInputStream);
        integer323.setValue(1);
        integer322.setValue(1);
        integer32.setValue(0);
        PDUv1 pDUv1 = new PDUv1();
        mutablePDU.setPdu(pDUv1);
        pDUv1.decodeBER(bERInputStream);
        BER.checkSequenceLength(n, (int)bERInputStream.getPosition() - n2, pDUv1);
        pduHandle.setTransactionID(pDUv1.getRequestID().getValue());
        StateReference stateReference = new StateReference(pduHandle, address, null, SecurityModels.getInstance().getSecurityModel(integer322), octetString.getValue(), 0);
        mutableStateReference.setStateReference(stateReference);
        return 0;
    }

    public boolean isProtocolVersionSupported(int n) {
        return n == 0;
    }

    public void releaseStateReference(PduHandle pduHandle) {
    }
}

