/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.DecryptParams;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.Salt;
import org.snmp4j.smi.OID;

public class PrivDES
implements PrivacyProtocol {
    private static final long serialVersionUID = 2526070176429255416L;
    public static final OID ID = new OID("1.3.6.1.6.3.10.1.2.2");
    private static final int DECRYPT_PARAMS_LENGTH = 8;
    protected Salt salt = Salt.getInstance();
    private static final LogAdapter logger = LogFactory.getLogger(PrivDES.class);

    public byte[] encrypt(byte[] byArray, int n, int n2, byte[] byArray2, long l, long l2, DecryptParams decryptParams) {
        byte[] byArray3;
        block12: {
            int n3 = (int)this.salt.getNext();
            if (byArray2.length < 16) {
                logger.error("Wrong Key length: need at least 16 bytes, is " + byArray2.length + " bytes.");
                throw new IllegalArgumentException("encryptionKey has illegal length " + byArray2.length + " (should be at least 16).");
            }
            if (decryptParams.array == null || decryptParams.length < 8) {
                decryptParams.array = new byte[8];
            }
            decryptParams.length = 8;
            decryptParams.offset = 0;
            if (logger.isDebugEnabled()) {
                logger.debug("Preparing decrypt_params.");
            }
            for (int i = 0; i < 4; ++i) {
                decryptParams.array[3 - i] = (byte)(0xFFL & l >> 8 * i);
                decryptParams.array[7 - i] = (byte)(0xFF & n3 >> 8 * i);
            }
            byte[] byArray4 = new byte[8];
            if (logger.isDebugEnabled()) {
                logger.debug("Preparing iv for encryption.");
            }
            for (int i = 0; i < 8; ++i) {
                byArray4[i] = (byte)(byArray2[8 + i] ^ decryptParams.array[i]);
            }
            byArray3 = null;
            try {
                Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, 0, 8, "DES");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
                if (n2 % 8 == 0) {
                    byArray3 = cipher.doFinal(byArray, n, n2);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using padding.");
                    }
                    byArray3 = new byte[8 * (n2 / 8 + 1)];
                    byte[] byArray5 = new byte[8];
                    int n4 = cipher.update(byArray, n, n2, byArray3);
                    n4 += cipher.doFinal(byArray5, 0, 8 - n2 % 8, byArray3, n4);
                }
            }
            catch (Exception exception) {
                logger.error(exception);
                if (!logger.isDebugEnabled()) break block12;
                exception.printStackTrace();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Encryption finished.");
        }
        return byArray3;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, byte[] byArray2, long l, long l2, DecryptParams decryptParams) {
        byte[] byArray3;
        block5: {
            if (n2 % 8 != 0 || n2 < 8 || decryptParams.length != 8) {
                throw new IllegalArgumentException("Length (" + n2 + ")is not multiple of 8 or decrypt params has not length 8 (" + decryptParams.length + ").");
            }
            if (byArray2.length < 16) {
                logger.error("Wrong Key length: need at least 16 bytes, is " + byArray2.length + " bytes.");
                throw new IllegalArgumentException("decryptionKey has illegal length " + byArray2.length + " (should be at least 16).");
            }
            byte[] byArray4 = new byte[8];
            for (int i = 0; i < 8; ++i) {
                byArray4[i] = (byte)(byArray2[8 + i] ^ decryptParams.array[i]);
            }
            byArray3 = null;
            try {
                Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, 0, 8, "DES");
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray4);
                cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
                byArray3 = cipher.doFinal(byArray, n, n2);
            }
            catch (Exception exception) {
                logger.error(exception);
                if (!logger.isDebugEnabled()) break block5;
                exception.printStackTrace();
            }
        }
        return byArray3;
    }

    public OID getID() {
        return (OID)ID.clone();
    }

    public int getEncryptedLength(int n) {
        if (n % 8 == 0) {
            return n;
        }
        return 8 * (n / 8 + 1);
    }

    public int getMinKeyLength() {
        return 16;
    }

    public int getDecryptParamsLength() {
        return 8;
    }

    public int getMaxKeyLength() {
        return this.getMinKeyLength();
    }
}

