/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbosscache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jbosscache.CacheConfigurationHelper;
import org.rhq.plugins.jbosscache.JBossCacheSubsystemComponent;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class JBossCacheComponent
implements ResourceComponent<JMXComponent>,
MeasurementFacet,
OperationFacet,
ConfigurationFacet {
    private static final Log log = LogFactory.getLog(JBossCacheComponent.class);
    private String baseObjectName;
    JBossCacheSubsystemComponent parentServer;
    boolean isTreeCache = false;
    List<EmsBean> interceptors = new ArrayList<EmsBean>();
    ResourceContext context;

    public void start(ResourceContext context) throws Exception {
        PropertySimple objectName = context.getPluginConfiguration().getSimple("objectName");
        this.baseObjectName = objectName.getStringValue();
        this.context = context;
        PropertySimple tcProp = context.getPluginConfiguration().getSimple("isTreeCache");
        if (tcProp == null || tcProp.getBooleanValue() == null) {
            throw new InvalidPluginConfigurationException("Cache flavour not provided");
        }
        this.isTreeCache = tcProp.getBooleanValue();
        this.parentServer = (JBossCacheSubsystemComponent)context.getParentResourceComponent();
        String query = this.baseObjectName + ",";
        if (this.isTreeCache) {
            query = query + "tree";
        }
        query = query + "cache-interceptor=%name%";
        ObjectNameQueryUtility util = new ObjectNameQueryUtility(query);
        query = util.getTranslatedQuery();
        EmsConnection connection = this.parentServer.getEmsConnection();
        if (connection != null) {
            this.interceptors = connection.queryBeans(query);
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        for (MeasurementScheduleRequest metric : requests) {
            int pos;
            String name = metric.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to get metric " + name));
            }
            if ((pos = name.indexOf(":")) > -1) {
                String bean = this.baseObjectName;
                if (pos > 0) {
                    bean = bean + ",";
                    if (this.isTreeCache) {
                        bean = bean + "tree";
                    }
                    bean = bean + "cache-interceptor=";
                    bean = bean + name.substring(0, pos);
                }
                String attr = name.substring(pos + 1);
                EmsConnection conn = this.parentServer.getEmsConnection();
                EmsBean eBean = conn.getBean(bean);
                if (eBean != null) {
                    ArrayList attrs = new ArrayList();
                    eBean.refreshAttributes(attrs);
                    EmsAttribute eAttr = eBean.getAttribute(attr);
                    if (metric.getDataType() == DataType.MEASUREMENT) {
                        Double val = ((Number)eAttr.getValue()).doubleValue();
                        MeasurementDataNumeric ret = new MeasurementDataNumeric(metric, val);
                        report.addData(ret);
                        continue;
                    }
                    if (metric.getDataType() == DataType.TRAIT) {
                        MeasurementDataTrait ret = new MeasurementDataTrait(metric, String.valueOf(eAttr.getValue()));
                        report.addData(ret);
                        continue;
                    }
                    log.warn((Object)("Unknown data type " + metric));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Bean " + bean + " not found "));
                continue;
            }
            log.warn((Object)("illegal metric " + metric + " skipping .."));
        }
    }

    public AvailabilityType getAvailability() {
        try {
            EmsConnection connection = this.parentServer.getEmsConnection();
            if (connection == null) {
                return AvailabilityType.DOWN;
            }
            boolean up = connection.getBean(this.baseObjectName).isRegistered();
            return up ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can not determine availability for " + this.baseObjectName + ": " + e.getMessage()));
            }
            return AvailabilityType.DOWN;
        }
    }

    public void stop() {
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        OperationResult result = null;
        if ("resetStatistics".equals(name)) {
            for (EmsBean bean : this.interceptors) {
                EmsOperation ops = bean.getOperation("resetStatistics");
                if (ops == null) continue;
                ops.invoke(new Object[0]);
            }
            result = null;
        } else if ("listAssociatedMBeans".equals(name)) {
            StringBuilder sb = new StringBuilder();
            for (EmsBean bean : this.interceptors) {
                sb.append(bean.getBeanName().getCanonicalName());
                sb.append(" ");
            }
            result = new OperationResult(sb.toString());
        }
        return result;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        File file = DeploymentUtility.getDescriptorFile((EmsConnection)this.parentServer.getEmsConnection(), (String)this.context.getResourceKey());
        if (file == null) {
            log.warn((Object)"Can not find the deployment descriptor for this cache ");
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            Configuration config = new Configuration();
            for (Object mbeanObj : root.getChildren("mbean")) {
                if (!(mbeanObj instanceof Element)) continue;
                Element mbean = (Element)mbeanObj;
                String nameAttrib = mbean.getAttributeValue("name");
                try {
                    ObjectName on = new ObjectName(nameAttrib);
                    nameAttrib = on.getCanonicalName();
                }
                catch (MalformedObjectNameException e) {
                    log.warn((Object)("Can't canonicalize " + nameAttrib));
                }
                if (!nameAttrib.equals(this.context.getResourceKey())) continue;
                this.fillAttributesInConfig(mbean, config);
                Attribute code = mbean.getAttribute("code");
                PropertySimple flavour = new PropertySimple();
                flavour.setName("Flavour");
                if (code.getValue().contains("Tree")) {
                    flavour.setStringValue("treecache");
                } else {
                    flavour.setStringValue("cache");
                }
                config.put((Property)flavour);
            }
            return config;
        }
        catch (IOException e) {
            log.error((Object)("IO error occurred while reading file: " + file), (Throwable)e);
        }
        catch (JDOMException e) {
            log.error((Object)("Parsing error occurred while reading file: " + file), (Throwable)e);
        }
        return null;
    }

    EmsConnection getEmsConnection() {
        return this.parentServer.getEmsConnection();
    }

    private void fillAttributesInConfig(Element mbean, Configuration config) {
        List children = mbean.getChildren("attribute");
        for (Object childObj : children) {
            if (!(childObj instanceof Element)) continue;
            Element child = (Element)childObj;
            String name = child.getAttributeValue("name");
            String value = child.getText();
            PropertySimple ps = new PropertySimple(name, (Object)value);
            config.put((Property)ps);
        }
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration newOne = report.getConfiguration();
        String mbeanName = this.context.getResourceKey();
        File file = DeploymentUtility.getDescriptorFile((EmsConnection)this.parentServer.getEmsConnection(), (String)mbeanName);
        CacheConfigurationHelper helper = new CacheConfigurationHelper();
        try {
            helper.writeConfig(file, newOne, mbeanName, true);
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            log.error((Object)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
    }
}

