/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.rhqtransform.impl;

import java.util.Collection;
import java.util.List;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.rhqtransform.AugeasRhqException;
import org.rhq.rhqtransform.ConfigurationToAugeas;

public class ConfigurationToAugeasSimple
implements ConfigurationToAugeas {
    protected AugeasTree tree;

    @Override
    public void setTree(AugeasTree tree) {
        this.tree = tree;
    }

    @Override
    public void updateResourceConfiguration(AugeasNode node, ConfigurationDefinition resourceConfigDef, Configuration resourceConfig) throws AugeasRhqException {
        Collection propDefs = resourceConfigDef.getPropertyDefinitions().values();
        PropertyMap startProp = new PropertyMap();
        for (Property property : resourceConfig.getProperties()) {
            startProp.put(property);
        }
        for (PropertyDefinition propDef : propDefs) {
            this.updateProperty(propDef, (Property)startProp, node, 0);
        }
    }

    @Override
    public void updateMap(PropertyDefinitionMap propDefMap, Property prop, AugeasNode mapNode, int seq) throws AugeasRhqException {
        AugeasNode node;
        PropertyMap map = null;
        if (prop instanceof PropertyList) {
            PropertyList lst = (PropertyList)prop;
            List props = lst.getList();
            map = (PropertyMap)props.get(seq - 1);
        }
        if (prop instanceof PropertyMap) {
            PropertyMap mp = (PropertyMap)prop;
            map = (PropertyMap)mp.get(propDefMap.getName());
        }
        List<AugeasNode> nodes = this.tree.matchRelative(mapNode, propDefMap.getName());
        int i = 0;
        if (nodes.isEmpty() | nodes.size() < seq) {
            node = this.tree.createNode(mapNode, propDefMap.getName(), null, seq);
            nodes.add(node);
            i = seq == 0 ? 0 : seq - 1;
        } else if (seq == 0) {
            node = nodes.get(0);
            i = 0;
        } else {
            node = nodes.get(seq - 1);
            i = seq - 1;
        }
        for (PropertyDefinition mapEntryPropDef : propDefMap.getPropertyDefinitions().values()) {
            this.updateProperty(mapEntryPropDef, (Property)map, nodes.get(i), 0);
        }
    }

    @Override
    public void updateList(PropertyDefinitionList propDef, Property prop, AugeasNode listNode, int seq) throws AugeasRhqException {
        PropertyList listProperty = null;
        PropertyDefinition childDefinition = propDef.getMemberDefinition();
        if (prop instanceof PropertyList) {
            PropertyList lst = (PropertyList)prop;
            listProperty = (PropertyList)lst.getList().get(seq - 1);
        }
        if (prop instanceof PropertyMap) {
            PropertyMap map = (PropertyMap)prop;
            listProperty = (PropertyList)map.get(propDef.getName());
        }
        List<AugeasNode> nodes = this.tree.matchRelative(listNode, propDef.getName());
        AugeasNode node = null;
        if (nodes.isEmpty() | nodes.size() < seq) {
            node = this.tree.createNode(listNode, propDef.getName(), null, seq);
            nodes.add(node);
        } else {
            node = nodes.get(seq);
        }
        int i = 1;
        for (Property prp : listProperty.getList()) {
            System.out.println(prp.getName());
            this.updateProperty(childDefinition, (Property)listProperty, node, i);
            ++i;
        }
    }

    @Override
    public void updateSimple(AugeasNode parentNode, PropertyDefinitionSimple propDef, Property prop, int seq) throws AugeasRhqException {
        List<AugeasNode> nodes;
        PropertySimple simpleProp = null;
        AugeasNode node = null;
        if (prop instanceof PropertyList) {
            PropertyList lst = (PropertyList)prop;
            List props = lst.getList();
            simpleProp = (PropertySimple)props.get(seq - 1);
        }
        if (prop instanceof PropertyMap) {
            PropertyMap map = (PropertyMap)prop;
            simpleProp = (PropertySimple)map.get(propDef.getName());
        }
        node = (nodes = this.tree.matchRelative(parentNode, propDef.getName())).isEmpty() ? this.tree.createNode(parentNode, propDef.getName(), null, 1) : nodes.get(0);
        node.setValue(simpleProp.getStringValue());
    }

    @Override
    public void updateProperty(PropertyDefinition propDef, Property parentProp, AugeasNode parentNode, int seq) throws AugeasRhqException {
        if (propDef instanceof PropertyDefinitionSimple) {
            PropertyDefinitionSimple propDefSimple = (PropertyDefinitionSimple)propDef;
            this.updateSimple(parentNode, propDefSimple, parentProp, seq);
        } else if (propDef instanceof PropertyDefinitionMap) {
            PropertyDefinitionMap propDefMap = (PropertyDefinitionMap)propDef;
            this.updateMap(propDefMap, parentProp, parentNode, seq);
        } else if (propDef instanceof PropertyDefinitionList) {
            PropertyDefinitionList propDefList = (PropertyDefinitionList)propDef;
            this.updateList(propDefList, parentProp, parentNode, seq);
        } else {
            throw new IllegalStateException("Unsupported PropertyDefinition subclass: " + propDef.getClass().getName());
        }
    }
}

