/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.common.jbossas.AbstractJBossASContentFacetDelegate;
import org.jboss.on.common.jbossas.JBPMWorkflowManager;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.jbossas5.EmptyFileException;
import org.rhq.plugins.jbossas5.util.FileContentDelegate;
import org.rhq.plugins.jbossas5.util.JarContentDelegate;

public class ApplicationServerContentFacetDelegate
extends AbstractJBossASContentFacetDelegate {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final Map<PackageType, FileContentDelegate> contentDelegates = new HashMap<PackageType, FileContentDelegate>();
    private File configurationPath;
    private ContentContext contentContext;

    private void setConfigurationPath(File configurationPath) {
        this.configurationPath = configurationPath;
    }

    private File getConfigurationPath() {
        return this.configurationPath;
    }

    private void setContentContext(ContentContext contentContext) {
        this.contentContext = contentContext;
    }

    private ContentContext getContentContext() {
        return this.contentContext;
    }

    protected ApplicationServerContentFacetDelegate(JBPMWorkflowManager workflowManager, File configurationPath, ContentContext contentContext) {
        super(workflowManager);
        this.setConfigurationPath(configurationPath);
        this.setContentContext(contentContext);
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        FileContentDelegate contentDelegate = this.getContentDelegate(type);
        Set<ResourcePackageDetails> details = null;
        if (contentDelegate != null) {
            details = contentDelegate.discoverDeployedPackages();
        }
        return details;
    }

    private FileContentDelegate getContentDelegate(PackageType type) {
        FileContentDelegate contentDelegate = this.contentDelegates.get(type);
        if (contentDelegate == null) {
            if (type.getName().equals("library")) {
                File deployLib = new File(this.getConfigurationPath(), "lib");
                contentDelegate = new JarContentDelegate(deployLib, type.getName());
            }
            this.contentDelegates.put(type, contentDelegate);
        }
        return contentDelegate;
    }

    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        ContentResponseResult overallResult = ContentResponseResult.SUCCESS;
        ArrayList<DeployIndividualPackageResponse> individualResponses = new ArrayList<DeployIndividualPackageResponse>(packages.size());
        for (ResourcePackageDetails pkg : packages) {
            DeployIndividualPackageResponse response;
            this.log.info((Object)("Attempting to deploy package: " + pkg));
            String packageTypeName = pkg.getPackageTypeName();
            if (packageTypeName.equals("cumulativePatch")) {
                if (packages.size() > 1) {
                    this.log.warn((Object)"Attempt to install more than one patch at a time, installation aborted.");
                    response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
                    response.setOverallRequestErrorMessage("When deploying a patch, no other packages may be deployed at the same time.");
                    return response;
                }
                try {
                    response = this.getWorkflowManager().run(pkg);
                    if (response.getResult() == ContentResponseResult.FAILURE) {
                        overallResult = ContentResponseResult.FAILURE;
                    }
                    individualResponses.add(response);
                }
                catch (Throwable throwable) {
                    this.log.error((Object)("Error deploying package: " + pkg), throwable);
                    DeployIndividualPackageResponse response2 = new DeployIndividualPackageResponse(pkg.getKey(), ContentResponseResult.FAILURE);
                    response2.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)throwable));
                    individualResponses.add(response2);
                    overallResult = ContentResponseResult.FAILURE;
                }
                continue;
            }
            if (!packageTypeName.equals("library")) continue;
            if (packages.size() > 1) {
                this.log.warn((Object)"Attempt to install more than one patch at a time, installation aborted.");
                response = new DeployPackagesResponse(ContentResponseResult.FAILURE);
                response.setOverallRequestErrorMessage("When deploying a patch, no other packages may be deployed at the same time.");
                return response;
            }
            this.deployJarLibrary(pkg, contentServices);
        }
        DeployPackagesResponse response = new DeployPackagesResponse(overallResult);
        response.getPackageResponses().addAll(individualResponses);
        return response;
    }

    public DeployPackagesResponse deployJarLibrary(ResourcePackageDetails packageDetails, ContentServices contentServices) {
        ContentResponseResult overallResult = ContentResponseResult.SUCCESS;
        ArrayList<DeployIndividualPackageResponse> individualResponses = new ArrayList<DeployIndividualPackageResponse>(1);
        String deployDir = this.getConfigurationPath() + File.separator + "lib";
        String destinationFileLocation = deployDir + File.separator + packageDetails.getKey().getName() + ".jar";
        try {
            this.downloadBits(packageDetails.getKey(), destinationFileLocation);
        }
        catch (Throwable throwable) {
            this.log.error((Object)("Error deploying package: " + packageDetails), throwable);
            DeployIndividualPackageResponse response = new DeployIndividualPackageResponse(packageDetails.getKey(), ContentResponseResult.FAILURE);
            response.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)throwable));
            individualResponses.add(response);
            overallResult = ContentResponseResult.FAILURE;
        }
        DeployPackagesResponse response = new DeployPackagesResponse(overallResult);
        response.getPackageResponses().addAll(individualResponses);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadBits(PackageDetailsKey key, String destinationFileLocation) throws IOException, EmptyFileException {
        ContentServices contentServices = this.getContentContext().getContentServices();
        FileOutputStream output = new FileOutputStream(destinationFileLocation);
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output, 4096);
        try {
            contentServices.downloadPackageBits(this.contentContext, key, (OutputStream)bufferedOutput, true);
            bufferedOutput.close();
            File downloadedFile = new File(destinationFileLocation);
            if (!downloadedFile.exists()) {
                throw new FileNotFoundException("File to download [" + destinationFileLocation + "] does not exist");
            }
            if (downloadedFile.length() == 0L) {
                throw new EmptyFileException("Downloaded file [" + destinationFileLocation + "] is empty");
            }
        }
        finally {
            try {
                bufferedOutput.close();
            }
            catch (IOException e1) {
                this.log.error((Object)("Error closing output stream to [" + destinationFileLocation + "] after exception"), (Throwable)e1);
            }
        }
    }
}

