/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.connection;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.profileservice.spi.ProfileService;
import org.rhq.plugins.jbossas5.connection.AbstractProfileServiceConnection;
import org.rhq.plugins.jbossas5.connection.AbstractProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.BasicProfileServiceConnection;
import org.rhq.plugins.jbossas5.connection.JaasAuthenticationProxyProfileServiceConnection;

public class RemoteProfileServiceConnectionProvider
extends AbstractProfileServiceConnectionProvider {
    private static final String NAMING_CONTEXT_FACTORY = "org.jnp.interfaces.NamingContextFactory";
    private static final String PROFILE_SERVICE_JNDI_NAME = "ProfileService";
    private static final String MANAGEMENT_VIEW_JNDI_NAME = "ManagementView";
    private static final String DEPLOYMENT_MANAGER_JNDI_NAME = "DeploymentManager";
    private static final String JNP_TIMEOUT_JNP_INIT_PROP = "jnp.timeout";
    private static final String JNP_SOTIMEOUT_JNP_INIT_PROP = "jnp.sotimeout";
    private static final String JNP_DISABLE_DISCOVERY_JNP_INIT_PROP = "jnp.disableDiscovery";
    private static final int JNP_TIMEOUT = 60000;
    private static final int JNP_SO_TIMEOUT = 60000;
    private static final boolean JNP_DISABLE_DISCOVERY = true;
    private final Log log = LogFactory.getLog(this.getClass());
    private String providerURL;
    private String principal;
    private String credentials;
    private InitialContext initialContext;

    public RemoteProfileServiceConnectionProvider(String providerURL, String principal, String credentials) {
        this.providerURL = providerURL;
        this.principal = principal;
        this.credentials = credentials;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getCredentials() {
        return this.credentials;
    }

    @Override
    protected AbstractProfileServiceConnection doConnect() {
        Properties env = new Properties();
        env.setProperty("java.naming.provider.url", this.providerURL);
        env.setProperty("java.naming.factory.initial", NAMING_CONTEXT_FACTORY);
        env.setProperty(JNP_TIMEOUT_JNP_INIT_PROP, String.valueOf(60000));
        env.setProperty(JNP_SOTIMEOUT_JNP_INIT_PROP, String.valueOf(60000));
        env.setProperty(JNP_DISABLE_DISCOVERY_JNP_INIT_PROP, String.valueOf(true));
        this.log.debug((Object)("Connecting to Profile Service via remote JNDI using env [" + env + "]..."));
        this.initialContext = this.createInitialContext(env);
        ProfileService profileService = (ProfileService)this.lookup(this.initialContext, PROFILE_SERVICE_JNDI_NAME);
        ManagementView managementView = (ManagementView)this.lookup(this.initialContext, MANAGEMENT_VIEW_JNDI_NAME);
        DeploymentManager deploymentManager = (DeploymentManager)this.lookup(this.initialContext, DEPLOYMENT_MANAGER_JNDI_NAME);
        AbstractProfileServiceConnection profileServiceConnection = this.principal != null ? new JaasAuthenticationProxyProfileServiceConnection(this, profileService, managementView, deploymentManager) : new BasicProfileServiceConnection(this, profileService, managementView, deploymentManager);
        return profileServiceConnection;
    }

    @Override
    protected void doDisconnect() {
        try {
            this.initialContext.close();
        }
        catch (NamingException e) {
            this.log.error((Object)"Failed to close JNDI InitialContext.", (Throwable)e);
        }
    }
}

