/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyDefinitionDynamic;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;

public abstract class ConfigurationUtility {
    public static void normalizeConfiguration(@NotNull Configuration configuration, @Nullable ConfigurationDefinition configurationDefinition) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration parameter is null.");
        }
        if (configurationDefinition != null) {
            Map childPropertyDefinitions = configurationDefinition.getPropertyDefinitions();
            for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
                ConfigurationUtility.normalizeProperty(childPropertyDefinition, (AbstractPropertyMap)configuration);
            }
        }
    }

    @NotNull
    public static List<String> validateConfiguration(@NotNull Configuration configuration, @Nullable ConfigurationDefinition configurationDefinition) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (configurationDefinition != null) {
            Map childPropertyDefinitions = configurationDefinition.getPropertyDefinitions();
            for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
                ConfigurationUtility.validateProperty(childPropertyDefinition, (AbstractPropertyMap)configuration, errorMessages);
            }
        }
        return errorMessages;
    }

    private static void normalizeProperty(PropertyDefinition propertyDefinition, AbstractPropertyMap parentPropertyMap) {
        if (parentPropertyMap.getMap().keySet().contains(propertyDefinition.getName())) {
            PropertyDefinitionList propertyDefinitionList;
            PropertyDefinition listMemberPropertyDefinition;
            if (propertyDefinition instanceof PropertyDefinitionSimple) {
                PropertySimple propertySimple = parentPropertyMap.getSimple(propertyDefinition.getName());
                String value = propertySimple.getStringValue();
                if (value != null && value.length() > 2000) {
                    propertySimple.setStringValue(value.substring(0, 2000));
                }
            } else if (propertyDefinition instanceof PropertyDefinitionMap) {
                PropertyMap propertyMap = parentPropertyMap.getMap(propertyDefinition.getName());
                PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)propertyDefinition;
                ConfigurationUtility.normalizePropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap);
            } else if (propertyDefinition instanceof PropertyDefinitionList && (listMemberPropertyDefinition = (propertyDefinitionList = (PropertyDefinitionList)propertyDefinition).getMemberDefinition()) instanceof PropertyDefinitionMap) {
                PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)listMemberPropertyDefinition;
                PropertyList propertyList = parentPropertyMap.getList(propertyDefinition.getName());
                for (Property property : propertyList.getList()) {
                    PropertyMap propertyMap = (PropertyMap)property;
                    ConfigurationUtility.normalizePropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap);
                }
            }
        } else {
            PropertySimple property;
            if (propertyDefinition instanceof PropertyDefinitionSimple) {
                property = new PropertySimple(propertyDefinition.getName(), null);
            } else if (propertyDefinition instanceof PropertyDefinitionMap) {
                property = new PropertyMap(propertyDefinition.getName());
            } else if (propertyDefinition instanceof PropertyDefinitionList) {
                property = new PropertyList(propertyDefinition.getName());
            } else if (propertyDefinition instanceof PropertyDefinitionDynamic) {
                property = new PropertySimple(propertyDefinition.getName(), null);
            } else {
                throw new IllegalStateException("Unsupported PropertyDefinition subclass: " + propertyDefinition.getClass().getName());
            }
            parentPropertyMap.put((Property)property);
        }
    }

    private static void normalizePropertyMap(AbstractPropertyMap propertyMap, PropertyDefinitionMap propertyDefinitionMap) {
        Map childPropertyDefinitions = propertyDefinitionMap.getPropertyDefinitions();
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationUtility.normalizeProperty(childPropertyDefinition, propertyMap);
        }
    }

    private static void validateProperty(PropertyDefinition propertyDefinition, AbstractPropertyMap parentPropertyMap, List<String> errorMessages) {
        if (parentPropertyMap.getMap().keySet().contains(propertyDefinition.getName())) {
            PropertyDefinitionList propertyDefinitionList;
            PropertyDefinition listMemberPropertyDefinition;
            if (propertyDefinition instanceof PropertyDefinitionSimple) {
                PropertySimple propertySimple = parentPropertyMap.getSimple(propertyDefinition.getName());
                if (propertyDefinition.isRequired() && propertySimple.getStringValue() == null) {
                    errorMessages.add("Required property '" + propertyDefinition.getName() + "' has a null value in " + parentPropertyMap + ".");
                    propertySimple.setStringValue("");
                }
            } else if (propertyDefinition instanceof PropertyDefinitionMap) {
                PropertyMap propertyMap = parentPropertyMap.getMap(propertyDefinition.getName());
                PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)propertyDefinition;
                ConfigurationUtility.validatePropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap, errorMessages);
            } else if (propertyDefinition instanceof PropertyDefinitionList && (listMemberPropertyDefinition = (propertyDefinitionList = (PropertyDefinitionList)propertyDefinition).getMemberDefinition()) instanceof PropertyDefinitionMap) {
                PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)listMemberPropertyDefinition;
                PropertyList propertyList = parentPropertyMap.getList(propertyDefinition.getName());
                for (Property property : propertyList.getList()) {
                    PropertyMap propertyMap = (PropertyMap)property;
                    ConfigurationUtility.validatePropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap, errorMessages);
                }
            }
        } else if (propertyDefinition.isRequired()) {
            errorMessages.add("Required property '" + propertyDefinition.getName() + "' was not set in " + parentPropertyMap + ".");
            if (propertyDefinition instanceof PropertyDefinitionSimple) {
                PropertySimple propertySimple = new PropertySimple(propertyDefinition.getName(), (Object)"");
                parentPropertyMap.put((Property)propertySimple);
            }
        }
    }

    private static void validatePropertyMap(AbstractPropertyMap propertyMap, PropertyDefinitionMap propertyDefinitionMap, List<String> errorMessages) {
        Map childPropertyDefinitions = propertyDefinitionMap.getPropertyDefinitions();
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationUtility.validateProperty(childPropertyDefinition, propertyMap, errorMessages);
        }
    }
}

