/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.server.content;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.rhq.core.clientapi.server.content.ContentDiscoveryReport;
import org.rhq.core.clientapi.server.content.ContentServiceResponse;
import org.rhq.core.communications.command.annotation.Asynchronous;
import org.rhq.core.communications.command.annotation.LimitedConcurrency;
import org.rhq.core.communications.command.annotation.Timeout;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;

public interface ContentServerService {
    public static final String CONCURRENCY_LIMIT_CONTENT_REPORT = "rhq.server.concurrency-limit.content-report";
    public static final String CONCURRENCY_LIMIT_CONTENT_DOWNLOAD = "rhq.server.concurrency-limit.content-download";

    @Asynchronous(guaranteedDelivery=true)
    @LimitedConcurrency(value="rhq.server.concurrency-limit.content-report")
    public void mergeDiscoveredPackages(ContentDiscoveryReport var1);

    @Asynchronous(guaranteedDelivery=true)
    public void completeDeployPackageRequest(DeployPackagesResponse var1);

    @Asynchronous(guaranteedDelivery=true)
    public void completeDeletePackageRequest(RemovePackagesResponse var1);

    @Asynchronous(guaranteedDelivery=true)
    public void completeRetrievePackageBitsRequest(ContentServiceResponse var1, InputStream var2);

    public Set<ResourcePackageDetails> loadDependencies(int var1, Set<PackageDetailsKey> var2);

    @Timeout(value=2700000L)
    @LimitedConcurrency(value="rhq.server.concurrency-limit.content-download")
    public long downloadPackageBitsGivenResource(int var1, PackageDetailsKey var2, OutputStream var3);

    @Timeout(value=2700000L)
    @LimitedConcurrency(value="rhq.server.concurrency-limit.content-download")
    public long downloadPackageBitsRangeGivenResource(int var1, PackageDetailsKey var2, OutputStream var3, long var4, long var6);

    @Timeout(value=2700000L)
    @LimitedConcurrency(value="rhq.server.concurrency-limit.content-download")
    public long downloadPackageBitsForChildResource(int var1, String var2, PackageDetailsKey var3, OutputStream var4);

    @LimitedConcurrency(value="rhq.server.concurrency-limit.content-download")
    public PageList<PackageVersionMetadataComposite> getPackageVersionMetadata(int var1, PageControl var2);

    public String getResourceSubscriptionMD5(int var1);

    public long getPackageBitsLength(int var1, PackageDetailsKey var2);

    @Timeout(value=5400000L)
    @LimitedConcurrency(value="rhq.server.concurrency-limit.content-download")
    public boolean preLoadRemoteContent(int var1, PackageDetailsKey var2);
}

