/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.apache;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.augeas.AugeasException;
import org.rhq.augeas.node.AugeasNode;
import org.rhq.augeas.tree.AugeasTree;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.apache.ApacheVirtualHostServiceComponent;
import org.rhq.plugins.apache.util.AugeasNodeSearch;
import org.rhq.plugins.apache.util.AugeasNodeValueUtil;

public class ApacheDirectoryDiscoveryComponent
implements ResourceDiscoveryComponent<ApacheVirtualHostServiceComponent> {
    public static final String DIRECTORY_DIRECTIVE = "<Directory";
    public static final String[] PARENT_DIRECTIVES = new String[]{"<IfModule"};

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<ApacheVirtualHostServiceComponent> context) throws InvalidPluginConfigurationException, Exception {
        LinkedHashSet<DiscoveredResourceDetails> discoveredResources = new LinkedHashSet<DiscoveredResourceDetails>();
        if (!((ApacheVirtualHostServiceComponent)context.getParentResourceComponent()).isAugeasEnabled()) {
            return discoveredResources;
        }
        AugeasTree tree = null;
        try {
            tree = ((ApacheVirtualHostServiceComponent)context.getParentResourceComponent()).getServerConfigurationTree();
        }
        catch (AugeasException e) {
            return discoveredResources;
        }
        AugeasNode parentNode = ((ApacheVirtualHostServiceComponent)context.getParentResourceComponent()).getNode(tree);
        List<AugeasNode> directories = AugeasNodeSearch.searchNode(PARENT_DIRECTIVES, DIRECTORY_DIRECTIVE, parentNode);
        ResourceType resourceType = context.getResourceType();
        for (AugeasNode node : directories) {
            boolean isRegexp;
            String directoryParam;
            Configuration pluginConfiguration = new Configuration();
            String ifmoduleParams = AugeasNodeSearch.getNodeKey(node, parentNode);
            List params = node.getChildByLabel("param");
            if (params.size() > 1) {
                directoryParam = ((AugeasNode)params.get(1)).getValue();
                isRegexp = true;
            } else {
                directoryParam = ((AugeasNode)params.get(0)).getValue();
                isRegexp = false;
            }
            pluginConfiguration.put((Property)new PropertySimple("regexp", (Object)isRegexp));
            String resourceKey = ifmoduleParams;
            String resourceName = AugeasNodeValueUtil.unescape(directoryParam);
            discoveredResources.add(new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, null, null, pluginConfiguration, null));
        }
        return discoveredResources;
    }
}

