/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.international.StatusMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatusMessages
implements Serializable {
    private static final long serialVersionUID = -5395975397632138270L;
    public static final String COMPONENT_NAME = "org.jboss.seam.international.statusMessages";
    private List<StatusMessage> messages = new ArrayList<StatusMessage>();
    private Map<String, List<StatusMessage>> keyedMessages = new HashMap<String, List<StatusMessage>>();
    private transient List<Runnable> tasks;

    protected List<StatusMessage> getMessages() {
        return this.messages;
    }

    protected Map<String, List<StatusMessage>> getKeyedMessages() {
        return this.keyedMessages;
    }

    public void clear() {
        this.messages.clear();
        this.keyedMessages.clear();
    }

    public void clearKeyedMessages(String id) {
        this.keyedMessages.remove(id);
    }

    public void clearGlobalMessages() {
        this.messages.clear();
    }

    public void add(StatusMessage.Severity severity, String key, String detailKey, String messageTemplate, String messageDetailTemplate, final Object ... params) {
        final StatusMessage message = new StatusMessage(severity, key, detailKey, messageTemplate, messageDetailTemplate);
        if (!message.isEmpty()) {
            this.messages.add(message);
            this.getTasks().add(new Runnable(){

                public void run() {
                    message.interpolate(params);
                }
            });
        }
    }

    public void addToControl(String id, StatusMessage.Severity severity, String key, String messageTemplate, final Object ... params) {
        final StatusMessage message = new StatusMessage(severity, key, null, messageTemplate, null);
        if (!message.isEmpty()) {
            if (this.keyedMessages.containsKey(id)) {
                this.keyedMessages.get(id).add(message);
            } else {
                ArrayList<StatusMessage> list = new ArrayList<StatusMessage>();
                list.add(message);
                this.keyedMessages.put(id, list);
            }
            this.getTasks().add(new Runnable(){

                public void run() {
                    message.interpolate(params);
                }
            });
        }
    }

    public void add(String messageTemplate, Object ... params) {
        this.add(StatusMessage.Severity.INFO, messageTemplate, params);
    }

    public void add(StatusMessage.Severity severity, String messageTemplate, Object ... params) {
        this.add(severity, null, null, messageTemplate, null, params);
    }

    public void addToControl(String id, String messageTemplate, Object ... params) {
        this.addToControl(id, StatusMessage.Severity.INFO, null, messageTemplate, params);
    }

    public void addToControl(String id, StatusMessage.Severity severity, String messageTemplate, Object ... params) {
        this.addToControl(id, severity, null, messageTemplate, params);
    }

    public void addFromResourceBundle(String key, Object ... params) {
        this.addFromResourceBundle(StatusMessage.Severity.INFO, key, params);
    }

    public void addFromResourceBundle(StatusMessage.Severity severity, String key, Object ... params) {
        this.addFromResourceBundleOrDefault(severity, key, key, params);
    }

    public void addFromResourceBundleOrDefault(String key, String defaultMessageTemplate, Object ... params) {
        this.addFromResourceBundleOrDefault(StatusMessage.Severity.INFO, key, defaultMessageTemplate, params);
    }

    public void addFromResourceBundleOrDefault(StatusMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        this.add(severity, key, null, defaultMessageTemplate, null, params);
    }

    public void addToControlFromResourceBundle(String id, String key, Object ... params) {
        this.addToControlFromResourceBundle(id, StatusMessage.Severity.INFO, key, params);
    }

    public void addToControlFromResourceBundle(String id, StatusMessage.Severity severity, String key, Object ... params) {
        this.addToControlFromResourceBundleOrDefault(id, severity, key, key, params);
    }

    public void addToControlFromResourceBundleOrDefault(String id, String key, String defaultMessageTemplate, Object ... params) {
        this.addToControlFromResourceBundleOrDefault(id, StatusMessage.Severity.INFO, key, defaultMessageTemplate, params);
    }

    public void addToControlFromResourceBundleOrDefault(String id, StatusMessage.Severity severity, String key, String defaultMessageTemplate, Object ... params) {
        this.addToControl(id, severity, key, defaultMessageTemplate, params);
    }

    public void add(InvalidValue[] ivs) {
        for (InvalidValue iv : ivs) {
            this.add(iv);
        }
    }

    public void addToControls(InvalidValue[] ivs) {
        for (InvalidValue iv : ivs) {
            this.addToControl(iv);
        }
    }

    public void add(InvalidValue iv) {
        this.add(StatusMessage.Severity.WARN, iv.getMessage(), new Object[0]);
    }

    public void addToControl(InvalidValue iv) {
        this.addToControl(iv.getPropertyName(), iv);
    }

    public void addToControl(String id, InvalidValue iv) {
        this.addToControl(id, StatusMessage.Severity.WARN, iv.getMessage(), new Object[0]);
    }

    private List<Runnable> getTasks() {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Runnable>();
        }
        return this.tasks;
    }

    protected static void runTasks() {
        StatusMessages statusMessages;
        if (Contexts.isConversationContextActive() && (statusMessages = StatusMessages.instance()) != null) {
            statusMessages.doRunTasks();
        }
    }

    protected void doRunTasks() {
        if (this.tasks != null) {
            for (Runnable task : this.tasks) {
                task.run();
            }
            this.tasks.clear();
        }
    }

    public static StatusMessages instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (StatusMessages)Component.getInstance(COMPONENT_NAME, ScopeType.CONVERSATION);
    }
}

