/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.ant.AntHelper;
import org.jbpm.graph.def.ProcessDefinition;

public class DeployProcessTask
extends MatchingTask {
    String cfg = null;
    String properties = null;
    String process = null;
    List fileSets = new ArrayList();

    public void execute() throws BuildException {
        if (this.cfg == null) {
            throw new BuildException("a hibernate.cfg.xml must be specified in the cfg attribute");
        }
        try {
            JbpmConfiguration jbpmConfiguration = AntHelper.getJbpmConfiguration(this.cfg, this.properties);
            if (this.process != null) {
                this.log("deploying par " + this.process + " ...");
                File file = new File(this.process);
                this.deploy(file, jbpmConfiguration);
            }
            Iterator iter = this.fileSets.iterator();
            while (iter.hasNext()) {
                FileSet fileSet = (FileSet)iter.next();
                DirectoryScanner dirScanner = fileSet.getDirectoryScanner(this.getProject());
                String[] fileSetFiles = dirScanner.getIncludedFiles();
                for (int i = 0; i < fileSetFiles.length; ++i) {
                    String fileName = fileSetFiles[i];
                    File file = new File(fileName);
                    if (!file.isFile()) {
                        file = new File(dirScanner.getBasedir(), fileName);
                    }
                    this.log("deploying process archive " + file + " ...");
                    this.deploy(file, jbpmConfiguration);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("couldn't deploy process archives : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deploy(File file, JbpmConfiguration jbpmConfiguration) throws IOException, FileNotFoundException {
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            ProcessDefinition processDefinition = ProcessDefinition.parseParZipInputStream(zipInputStream);
            jbpmContext.deployProcessDefinition(processDefinition);
        }
        finally {
            jbpmContext.close();
        }
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setCfg(String cfg) {
        this.cfg = cfg;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setProcess(String process) {
        this.process = process;
    }
}

