/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugins.alertMicroblog;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.notification.SenderResult;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.util.LookupUtil;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.Configuration;
import twitter4j.conf.PropertyConfiguration;

public class MicroblogSender
extends AlertSender {
    private final Log log = LogFactory.getLog(MicroblogSender.class);

    public SenderResult send(Alert alert) {
        SenderResult result;
        String user = this.preferences.getSimpleValue("user", null);
        String password = this.preferences.getSimpleValue("password", null);
        String baseUrl = this.preferences.getSimpleValue("microblogServerUrl", "http://twitter.com/");
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        Properties props = new Properties();
        props.put("source", "Jopr");
        props.put("http.userAgent", "Jopr");
        props.put("restBaseURL", baseUrl);
        PropertyConfiguration tconf = new PropertyConfiguration(props);
        TwitterFactory tFactory = new TwitterFactory((Configuration)tconf);
        Twitter twitter = tFactory.getInstance(user, password);
        AlertManagerLocal alertManager = LookupUtil.getAlertManager();
        StringBuilder b = new StringBuilder("Alert ");
        b.append(alert.getId()).append(":'");
        b.append(alert.getAlertDefinition().getResource().getName());
        b.append("' (");
        b.append(alert.getAlertDefinition().getResource().getId());
        b.append("): ");
        b.append(alertManager.prettyPrintAlertConditions(alert, true));
        b.append("-by @JBossJopr");
        String txt = "user@baseUrl [" + user + "@" + baseUrl + "]:";
        try {
            String msg = b.toString();
            if (msg.length() > 140) {
                msg = msg.substring(0, 140);
            }
            Status status = twitter.updateStatus(msg);
            result = SenderResult.getSimpleSuccess((String)("Send notification to " + txt + ", msg-id: " + status.getId()));
        }
        catch (TwitterException e) {
            this.log.warn((Object)("Notification via Microblog failed for " + txt + " "), (Throwable)e);
            result = SenderResult.getSimpleFailure((String)("Sending failed :" + e.getMessage()));
        }
        return result;
    }
}

