/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

public class CommandType
implements Serializable,
Comparable {
    private static final Logger LOG = CommI18NFactory.getLogger(CommandType.class);
    private final String m_name;
    private final int m_version;
    private static final long serialVersionUID = 1L;

    public CommandType(String name, int version) throws IllegalArgumentException {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException(LOG.getMsgString("CommandType.empty-name", new Object[0]));
        }
        this.m_name = name.trim();
        this.m_version = version;
    }

    public CommandType(CommandType original) {
        this(original.m_name, original.m_version);
    }

    public CommandType(String nameVersion) throws IllegalArgumentException {
        if (nameVersion == null) {
            throw new IllegalArgumentException(LOG.getMsgString("CommandType.null-name-version", new Object[0]));
        }
        StringTokenizer strtok = new StringTokenizer(nameVersion, " ");
        try {
            this.m_name = strtok.nextToken();
            if (strtok.hasMoreTokens()) {
                String versionString = strtok.nextToken();
                if (Character.toLowerCase(versionString.charAt(0)) == 'v') {
                    versionString = versionString.substring(1);
                }
                this.m_version = Integer.parseInt(versionString);
            } else {
                this.m_version = 1;
            }
            if (strtok.hasMoreTokens()) {
                throw new IllegalArgumentException(LOG.getMsgString("CommandType.invalid-name-version", new Object[]{nameVersion}));
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException(LOG.getMsgString("CommandType.name-missing", new Object[]{nameVersion}));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(LOG.getMsgString("CommandType.version-invalid", new Object[]{nameVersion}));
        }
    }

    public String getName() {
        return this.m_name;
    }

    public int getVersion() {
        return this.m_version;
    }

    public String toString() {
        String retString = this.m_name;
        if (this.m_version != 1) {
            retString = retString + " v" + this.m_version;
        }
        return retString;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CommandType)) {
            return false;
        }
        CommandType compareThis = (CommandType)obj;
        if (compareThis == this) {
            return true;
        }
        return this.m_name.equals(compareThis.m_name) && this.m_version == compareThis.m_version;
    }

    public int hashCode() {
        return (this.m_name + this.m_version).hashCode();
    }

    public int compareTo(Object obj) throws IllegalArgumentException {
        if (obj == null) {
            throw new ClassCastException("obj=null");
        }
        CommandType compareThis = (CommandType)obj;
        if (this.equals(compareThis)) {
            return 0;
        }
        if (!this.m_name.equals(compareThis.m_name)) {
            throw new IllegalArgumentException(LOG.getMsgString("CommandType.cannot-compare-diff-names", new Object[]{this.m_name, compareThis.m_name}));
        }
        return this.m_version > compareThis.m_version ? 1 : -1;
    }
}

