/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.rhq.test.CollectionEqualsChecker;
import org.rhq.test.EqualsResult;
import org.rhq.test.MatchResult;
import org.rhq.test.PropertyMatcher;
import org.testng.Assert;

public class AssertUtils {
    public static <T> void assertPropertiesMatch(T expected, T actual, String msg) {
        AssertUtils.assertPropertiesMatch(msg, expected, actual, Collections.<String>emptyList());
    }

    public static <T> void assertPropertiesMatch(String msg, T expected, T actual, String ... ignoredProperties) {
        AssertUtils.assertPropertiesMatch(msg, expected, actual, Arrays.asList(ignoredProperties));
    }

    public static <T> void assertPropertiesMatch(String msg, T expected, T actual, List<String> ignoredProperties) {
        Assert.assertNotNull(expected, (String)"Expected object should not be null");
        Assert.assertNotNull(actual, (String)"Actual object should not be null");
        PropertyMatcher<T> matcher = new PropertyMatcher<T>();
        matcher.setExpected(expected);
        matcher.setActual(actual);
        matcher.setIgnoredProperties(ignoredProperties);
        MatchResult result = matcher.execute();
        Assert.assertTrue((boolean)result.isMatch(), (String)(msg + " -- " + result.getDetails()));
    }

    public static <T> void assertCollectionEqualsNoOrder(Collection<T> expected, Collection<T> actual, String msg) {
        CollectionEqualsChecker<T> checker = new CollectionEqualsChecker<T>();
        checker.setExpected(expected);
        checker.setActual(actual);
        EqualsResult result = checker.execute();
        Assert.assertTrue((boolean)result.isEqual(), (String)(msg + " -- " + result.getDetails()));
    }
}

