/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.iis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.measurement.calltime.CallTimeDataValue;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;

public class IISResponseTimeDelegate {
    private File logDirectory;
    private File previousFile;
    private long previousOffset;
    private ResponseTimeLogParser logParser;
    private boolean isAbsoluteTime;
    private ResponseTimeConfiguration responseTimeConfiguration;
    private Map<LogFormatToken, Integer> logTokenPositions;
    private Log log = LogFactory.getLog(IISResponseTimeDelegate.class);

    public IISResponseTimeDelegate(String logDirectory, String logFormat, ResponseTimeConfiguration responseTimeConfiguration) {
        if (logDirectory == null) {
            throw new IllegalArgumentException("logDirectory can not be null");
        }
        this.logDirectory = new File(logDirectory);
        this.isAbsoluteTime = true;
        this.responseTimeConfiguration = responseTimeConfiguration;
        this.logTokenPositions = new HashMap<LogFormatToken, Integer>();
        String[] logFormatTokens = logFormat.split(" ");
        EnumSet<LogFormatToken> foundTokens = EnumSet.noneOf(LogFormatToken.class);
        for (int i = 0; i < logFormatTokens.length; ++i) {
            String nextLiteral = logFormatTokens[i];
            LogFormatToken nextToken = LogFormatToken.getViaTokenLiteral(nextLiteral);
            if (nextToken != null) {
                if (foundTokens.contains((Object)nextToken)) {
                    this.log.warn((Object)("Token '" + nextLiteral + "' was specified more than once"));
                    continue;
                }
                this.log.debug((Object)("Required token found '" + nextLiteral + "' at position " + i));
                foundTokens.add(nextToken);
                this.logTokenPositions.put(nextToken, i);
                continue;
            }
            this.log.debug((Object)("Extra token found '" + nextLiteral + "' at position " + i));
        }
        if (!foundTokens.containsAll(EnumSet.allOf(LogFormatToken.class))) {
            this.log.error((Object)("Log format '" + logFormat + "' needs to include: " + LogFormatToken.getRequiredTokenString()));
        }
    }

    public void parseLogs(CallTimeData data) {
        File lastAccessedFile = this.getLastAccessedFile();
        if (lastAccessedFile == null) {
            this.log.debug((Object)"No log files exist yet");
            return;
        }
        this.log.debug((Object)("Last accessed file = " + lastAccessedFile));
        if (this.previousFile == null) {
            this.log.debug((Object)"This is the first time we found a log file");
            this.previousFile = lastAccessedFile;
            this.previousOffset = this.previousFile.length();
            this.logParser = new IISResponseTimeLogParser(this.previousFile);
        } else if (!this.previousFile.equals(lastAccessedFile)) {
            this.log.debug((Object)"Log files have been rotated");
            this.previousOffset = this.previousFile.length();
            this.logParser = new IISResponseTimeLogParser(this.previousFile);
        }
        if (this.logParser == null) {
            this.log.error((Object)"Unexpected error, logParser was null");
            return;
        }
        try {
            this.logParser.parseLog(data);
        }
        catch (IOException ioe) {
            this.log.error((Object)("Error parsing log data: " + ioe.getMessage()), (Throwable)ioe);
        }
    }

    private File getLastAccessedFile() {
        File[] logs = this.logDirectory.listFiles(new IISResponseTimeLogFileFilter());
        File lastModifiedFile = null;
        long lastModifiedTime = 0L;
        for (File log : logs) {
            if (log.lastModified() <= lastModifiedTime) continue;
            lastModifiedFile = log;
            lastModifiedTime = log.lastModified();
        }
        return lastModifiedFile;
    }

    private class IISResponseTimeLogParser
    extends ResponseTimeLogParser {
        private DateFormat dateParser;

        public IISResponseTimeLogParser(File logFile) {
            super(logFile);
            this.dateParser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.setExcludes(IISResponseTimeDelegate.this.responseTimeConfiguration.getExcludes());
            this.setTransforms(IISResponseTimeDelegate.this.responseTimeConfiguration.getTransforms());
        }

        public synchronized void parseLog(CallTimeData callTimeData) throws IOException {
            String currentLine;
            BufferedReader in;
            this.log.info((Object)("Parsing response-time log file " + this.logFile + "..."));
            long newOffset = 0L;
            try {
                in = new BufferedReader(new FileReader(this.logFile));
                newOffset = this.logFile.length();
            }
            catch (FileNotFoundException e) {
                this.log.info((Object)("Response-time log file '" + this.logFile + "' does not exist."));
                return;
            }
            this.log.info((Object)("Filesize " + newOffset));
            this.log.info((Object)("Skipping " + IISResponseTimeDelegate.this.previousOffset));
            in.skip(IISResponseTimeDelegate.this.previousOffset);
            IISResponseTimeDelegate.this.previousOffset = newOffset;
            while ((currentLine = in.readLine()) != null) {
                ResponseTimeLogParser.LogEntry logEntry;
                this.log.info((Object)("Parsing line: " + currentLine));
                try {
                    logEntry = this.parseLine(currentLine);
                }
                catch (Exception e) {
                    this.log.info((Object)("Problem parsing line [" + currentLine + "] - cause: " + e));
                    continue;
                }
                String url = logEntry.getUrl();
                if (url.charAt(0) != '/') {
                    String truncatedUrl = url.substring(0, Math.min(url.length(), 120));
                    if (url.length() > 120) {
                        truncatedUrl = truncatedUrl + "...";
                    }
                    this.log.info((Object)("URL ('" + truncatedUrl + "') parsed from response-time log file does not begin with '/'. " + "Line being parsed is [" + currentLine + "]."));
                    continue;
                }
                if (this.isExcluded(url)) {
                    this.log.info((Object)"URL was excluded");
                    continue;
                }
                if (logEntry.getStatusCode() != null && (logEntry.getStatusCode() < 200 || logEntry.getStatusCode() >= 400)) {
                    this.log.info((Object)("Status code was invalid: " + logEntry.getStatusCode()));
                    continue;
                }
                String transformedUrl = this.applyTransforms(url);
                this.log.info((Object)("Original URL: " + url));
                this.log.info((Object)("Transformed: " + transformedUrl));
                try {
                    callTimeData.addCallData(transformedUrl, new Date(logEntry.getStartTime()), logEntry.getDuration());
                }
                catch (IllegalArgumentException iae) {
                    this.log.error((Object)iae);
                }
            }
            this.log.info((Object)"Results...");
            for (Map.Entry callTime : callTimeData.getValues().entrySet()) {
                String url = (String)callTime.getKey();
                CallTimeDataValue value = (CallTimeDataValue)callTime.getValue();
                this.log.info((Object)("Calltime URL: " + url));
                this.log.info((Object)("Calltime Data: " + value));
            }
            in.close();
        }

        protected ResponseTimeLogParser.LogEntry parseLine(String line) throws Exception {
            ResponseTimeLogParser.LogEntry logEntry;
            try {
                String[] logEntryTokens = line.split(" ");
                String date = logEntryTokens[(Integer)IISResponseTimeDelegate.this.logTokenPositions.get((Object)LogFormatToken.DATE)];
                String time = logEntryTokens[(Integer)IISResponseTimeDelegate.this.logTokenPositions.get((Object)LogFormatToken.TIME)];
                String ipAddress = logEntryTokens[(Integer)IISResponseTimeDelegate.this.logTokenPositions.get((Object)LogFormatToken.C_IP)];
                String url = logEntryTokens[(Integer)IISResponseTimeDelegate.this.logTokenPositions.get((Object)LogFormatToken.CS_URI_STEM)];
                int httpStatus = Integer.parseInt(logEntryTokens[(Integer)IISResponseTimeDelegate.this.logTokenPositions.get((Object)LogFormatToken.SC_STATUS)]);
                long duration = Long.parseLong(logEntryTokens[(Integer)IISResponseTimeDelegate.this.logTokenPositions.get((Object)LogFormatToken.TIME_TAKEN)]);
                long startTime = this.dateParser.parse(date.trim() + " " + time.trim()).getTime();
                if (IISResponseTimeDelegate.this.isAbsoluteTime) {
                    int tzOffset = TimeZone.getDefault().getOffset(startTime);
                    startTime += (long)tzOffset;
                }
                logEntry = new ResponseTimeLogParser.LogEntry((ResponseTimeLogParser)this, url, startTime, duration, Integer.valueOf(httpStatus), ipAddress);
            }
            catch (RuntimeException e) {
                throw new Exception("Failed to parse response time log file line [" + line + "]. " + "Expected field format is 'date time c-ip cs-method cs-uri-stem sc-status'", e);
            }
            return logEntry;
        }
    }

    private class IISResponseTimeLogFileFilter
    implements FileFilter {
        private IISResponseTimeLogFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String fileName = f.getName().toLowerCase();
            return fileName.startsWith("ex") && fileName.endsWith(".log");
        }
    }

    private static enum LogFormatToken {
        DATE("date"),
        TIME("time"),
        C_IP("c-ip"),
        CS_URI_STEM("cs-uri-stem"),
        SC_STATUS("sc-status"),
        TIME_TAKEN("time-taken");

        private String tokenLiteral;

        private LogFormatToken(String tokenLiteral) {
            this.tokenLiteral = tokenLiteral;
        }

        public static LogFormatToken getViaTokenLiteral(String literal) {
            for (LogFormatToken logToken : LogFormatToken.values()) {
                if (!logToken.tokenLiteral.equals(literal)) continue;
                return logToken;
            }
            return null;
        }

        public static String getRequiredTokenString() {
            StringBuilder builder = new StringBuilder();
            for (LogFormatToken nextToken : LogFormatToken.values()) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append("'").append(nextToken.tokenLiteral).append("'");
            }
            return builder.toString();
        }
    }
}

