/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileObject;
import org.h2.store.fs.FileObjectDisk;
import org.h2.store.fs.FileSystem;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

public class FileSystemDisk
extends FileSystem {
    private static final FileSystemDisk INSTANCE = new FileSystemDisk();
    private static final boolean IS_FILE_SYSTEM_CASE_INSENSITIVE = File.separatorChar == '\\';

    protected FileSystemDisk() {
    }

    public static FileSystemDisk getInstance() {
        return INSTANCE;
    }

    public long length(String string) {
        string = this.translateFileName(string);
        return new File(string).length();
    }

    protected String translateFileName(String string) {
        return FileSystemDisk.expandUserHomeDirectory(string);
    }

    public static String expandUserHomeDirectory(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("~") && (string.length() == 1 || string.startsWith("~/") || string.startsWith("~\\"))) {
            String string2 = SysProperties.USER_HOME;
            string = string2 + string.substring(1);
        }
        return string;
    }

    public void rename(String string, String string2) {
        string = this.translateFileName(string);
        string2 = this.translateFileName(string2);
        File file = new File(string);
        File file2 = new File(string2);
        if (file.getAbsolutePath().equals(file2.getAbsolutePath())) {
            DbException.throwInternalError("rename file old=new");
        }
        if (!file.exists()) {
            throw DbException.get(90024, string + " (not found)", string2);
        }
        if (file2.exists()) {
            throw DbException.get(90024, string, string2 + " (exists)");
        }
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            this.trace("rename", string + " >" + string2, null);
            boolean bl = file.renameTo(file2);
            if (bl) {
                return;
            }
            FileSystemDisk.wait(i);
        }
        throw DbException.get(90024, string, string2);
    }

    protected void trace(String string, String string2, Object object) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileSystem." + string + " " + string2 + " " + object);
        }
    }

    private static void wait(int n) {
        if (n > 8) {
            System.gc();
        }
        try {
            long l = Math.min(256, n * n);
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean createNewFile(String string) {
        string = this.translateFileName(string);
        File file = new File(string);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException iOException) {
                FileSystemDisk.wait(i);
                continue;
            }
        }
        return false;
    }

    public boolean exists(String string) {
        string = this.translateFileName(string);
        return new File(string).exists();
    }

    public void delete(String string) {
        File file = new File(string = this.translateFileName(string));
        if (file.exists()) {
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                this.trace("delete", string, null);
                boolean bl = file.delete();
                if (bl) {
                    return;
                }
                FileSystemDisk.wait(i);
            }
            throw DbException.get(90025, string);
        }
    }

    public boolean tryDelete(String string) {
        string = this.translateFileName(string);
        this.trace("tryDelete", string, null);
        return new File(string).delete();
    }

    public String createTempFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        File file;
        File file2;
        string = this.translateFileName(string);
        string = string + ".";
        String string3 = new File(string).getName();
        if (bl2) {
            file2 = null;
        } else {
            file2 = new File(string).getAbsoluteFile().getParentFile();
            IOUtils.mkdirs(file2);
        }
        while ((file = new File(file2, string3 + this.getNextTempFileNamePart(false) + string2)).exists()) {
            this.getNextTempFileNamePart(true);
        }
        if (bl) {
            try {
                file.deleteOnExit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return file.getCanonicalPath();
    }

    public String[] listFiles(String string) {
        string = this.translateFileName(string);
        File file = new File(string);
        try {
            String[] stringArray = file.list();
            if (stringArray == null) {
                return new String[0];
            }
            String string2 = file.getCanonicalPath();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = string2 + stringArray[i];
            }
            return stringArray;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    public void deleteRecursive(String string, boolean bl) {
        if (IOUtils.isDirectory(string = this.translateFileName(string))) {
            String[] stringArray = this.listFiles(string);
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                this.deleteRecursive(stringArray[i], bl);
            }
        }
        if (bl) {
            this.tryDelete(string);
        } else {
            this.delete(string);
        }
    }

    public boolean isReadOnly(String string) {
        File file = new File(string = this.translateFileName(string));
        return file.exists() && !this.canWriteInternal(file);
    }

    public boolean setReadOnly(String string) {
        string = this.translateFileName(string);
        File file = new File(string);
        return file.setReadOnly();
    }

    public String normalize(String string) {
        string = this.translateFileName(string);
        File file = new File(string);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    public String getParent(String string) {
        string = this.translateFileName(string);
        return new File(string).getParent();
    }

    public boolean isDirectory(String string) {
        string = this.translateFileName(string);
        return new File(string).isDirectory();
    }

    public boolean isAbsolute(String string) {
        string = this.translateFileName(string);
        File file = new File(string);
        return file.isAbsolute();
    }

    public String getAbsolutePath(String string) {
        string = this.translateFileName(string);
        File file = new File(string).getAbsoluteFile();
        return file.getAbsolutePath();
    }

    public long getLastModified(String string) {
        string = this.translateFileName(string);
        return new File(string).lastModified();
    }

    public boolean canWrite(String string) {
        string = this.translateFileName(string);
        return this.canWriteInternal(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canWriteInternal(File file) {
        try {
            if (!file.canWrite()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void copy(String string, String string2) {
        string = this.translateFileName(string);
        string2 = this.translateFileName(string2);
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            int n;
            outputStream = IOUtils.openFileOutputStream(string2, false);
            inputStream = IOUtils.openFileInputStream(string);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.close();
        }
        catch (IOException iOException) {
            try {
                throw DbException.convertIOException(iOException, "original: " + string + " copy: " + string2);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(inputStream);
                IOUtils.closeSilently(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeSilently(inputStream);
        IOUtils.closeSilently(outputStream);
    }

    public void createDirs(String string) {
        File file = new File(string = this.translateFileName(string));
        if (!file.exists()) {
            String string2 = file.getParent();
            if (string2 == null) {
                return;
            }
            File file2 = new File(string2);
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                if (file2.exists() && file2.isDirectory() || file2.mkdirs()) {
                    return;
                }
                FileSystemDisk.wait(i);
            }
            throw DbException.get(90062, string2);
        }
    }

    public String getFileName(String string) {
        string = this.translateFileName(string);
        return new File(string).getName();
    }

    public boolean fileStartsWith(String string, String string2) {
        string = this.translateFileName(string);
        string2 = this.translateFileName(string2);
        if (IS_FILE_SYSTEM_CASE_INSENSITIVE) {
            string = StringUtils.toUpperEnglish(string);
            string2 = StringUtils.toUpperEnglish(string2);
        }
        return string.startsWith(string2);
    }

    public OutputStream openFileOutputStream(String string, boolean bl) {
        string = this.translateFileName(string);
        try {
            File file = new File(string);
            this.createDirs(file.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
            this.trace("openFileOutputStream", string, fileOutputStream);
            return fileOutputStream;
        }
        catch (IOException iOException) {
            this.freeMemoryAndFinalize();
            try {
                return new FileOutputStream(string);
            }
            catch (IOException iOException2) {
                throw DbException.convertIOException(iOException, string);
            }
        }
    }

    public InputStream openFileInputStream(String string) throws IOException {
        if (string.indexOf(58) > 1) {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            return inputStream;
        }
        string = this.translateFileName(string);
        FileInputStream fileInputStream = new FileInputStream(string);
        this.trace("openFileInputStream", string, fileInputStream);
        return fileInputStream;
    }

    protected void freeMemoryAndFinalize() {
        this.trace("freeMemoryAndFinalize", null, null);
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        for (int i = 0; i < 16; ++i) {
            runtime.gc();
            long l2 = runtime.freeMemory();
            runtime.runFinalization();
            if (l2 == l) break;
            l = l2;
        }
    }

    public FileObject openFileObject(String string, String string2) throws IOException {
        FileObjectDisk fileObjectDisk;
        string = this.translateFileName(string);
        try {
            fileObjectDisk = new FileObjectDisk(string, string2);
            this.trace("openRandomAccessFile", string, fileObjectDisk);
        }
        catch (IOException iOException) {
            this.freeMemoryAndFinalize();
            try {
                fileObjectDisk = new FileObjectDisk(string, string2);
            }
            catch (IOException iOException2) {
                throw iOException;
            }
        }
        return fileObjectDisk;
    }

    protected boolean accepts(String string) {
        return true;
    }
}

