/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.ant.dbupgrade;

import java.sql.Connection;
import mazz.i18n.Msg;
import org.apache.tools.ant.BuildException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.ant.DbAntI18NFactory;
import org.rhq.core.db.ant.dbupgrade.SchemaSpecTask;

public class SST_UpdateColumn
extends SchemaSpecTask {
    private static final Msg MSG = DbAntI18NFactory.getMsg();
    private String table = null;
    private String column = null;
    private String modifyCmd = null;

    public void setTable(String t) {
        this.table = t;
    }

    public void setColumn(String c) {
        this.column = c;
    }

    public void setModifyCmd(String m) {
        this.modifyCmd = m;
    }

    public void execute() throws BuildException {
        if (!this.isDBTargeted()) {
            return;
        }
        this.validateAttributes();
        try {
            DatabaseType db_type = this.getDatabaseType();
            Connection conn = this.getConnection();
            boolean exists = db_type.checkColumnExists(conn, this.table, this.column);
            if (!exists) {
                throw new BuildException(MSG.getMsg("SchemaSpecTask.updatecolumn.error-updating-nonexisting-column", new Object[]{this.column, this.table}));
            }
            this.log(MSG.getMsg("SchemaSpecTask.updatecolumn.updating-column", new Object[]{this.table, this.column, this.modifyCmd}));
            db_type.updateColumn(conn, this.table, this.column, this.modifyCmd);
        }
        catch (Exception e) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.updatecolumn.error-updating-column", new Object[]{this.column, this.table, e}), (Throwable)e);
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.table == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"UpdateColumn", "table"}));
        }
        if (this.column == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"UpdateColumn", "column"}));
        }
        if (this.modifyCmd == null) {
            throw new BuildException(MSG.getMsg("SchemaSpecTask.missing-attrib", new Object[]{"UpdateColumn", "modifyCmd"}));
        }
    }
}

