/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.db.setup;

import java.util.List;
import org.rhq.core.db.setup.Column;
import org.rhq.core.db.setup.Table;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class H2Column
extends Column {
    protected H2Column(Node node, Table table) throws SAXException {
        super(node, table);
    }

    @Override
    protected String getDefaultCommand(List cmds) {
        if (this.m_strType.equalsIgnoreCase("auto") || this.m_iDefault == 3) {
            return "";
        }
        return "DEFAULT nextval('" + this.getSequenceName() + "')";
    }

    @Override
    protected void getPreCreateCommands(List cmds) {
        if (this.m_strType.equalsIgnoreCase("auto")) {
            return;
        }
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    cmds.add(0, " CREATE SEQUENCE " + this.getSequenceName() + " START WITH " + this.getInitialSequence() + " INCREMENT BY " + this.getIncrementSequence() + " CACHE 10");
                }
            }
        }
    }

    @Override
    protected void getDropCommands(List cmds) {
        if (this.hasDefault()) {
            switch (this.getDefault()) {
                case 1: 
                case 3: {
                    cmds.add("DROP SEQUENCE " + this.getSequenceName());
                }
            }
        }
    }

    private String getSequenceName() {
        String tableName = this.m_strTableName.toUpperCase();
        String columnName = this.getName().toUpperCase();
        String sequenceName = tableName + '_' + columnName + "_SEQ";
        return sequenceName;
    }
}

