/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.communications.command.client;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import mazz.i18n.Logger;
import org.rhq.enterprise.communications.command.client.ClientCommandSenderConfiguration;
import org.rhq.enterprise.communications.i18n.CommI18NFactory;

class SendThrottle {
    private static final Logger LOG = CommI18NFactory.getLogger(SendThrottle.class);
    private AtomicBoolean m_sendThrottleEnabled = new AtomicBoolean(false);
    private QuietPeriodRunnable m_quietPeriodRunnable;
    private long m_sendThrottleMaxCommands;
    private long m_sendThrottleQuietPeriodDurationMillis;

    public SendThrottle(ClientCommandSenderConfiguration config) {
        this.setSendThrottleParameters(config);
        if (config.enableSendThrottling) {
            this.enableSendThrottling();
        } else {
            this.disableSendThrottling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendThrottleParameters(ClientCommandSenderConfiguration config) {
        AtomicBoolean atomicBoolean = this.m_sendThrottleEnabled;
        synchronized (atomicBoolean) {
            this.m_sendThrottleMaxCommands = config.sendThrottleMaxCommands;
            this.m_sendThrottleQuietPeriodDurationMillis = config.sendThrottleQuietPeriodDurationMillis;
            LOG.debug("SendThrottle.configured", new Object[]{this.m_sendThrottleMaxCommands, this.m_sendThrottleQuietPeriodDurationMillis});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSendThrottlingEnabled() {
        AtomicBoolean atomicBoolean = this.m_sendThrottleEnabled;
        synchronized (atomicBoolean) {
            return this.m_sendThrottleEnabled.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSendThrottling() {
        AtomicBoolean atomicBoolean = this.m_sendThrottleEnabled;
        synchronized (atomicBoolean) {
            if (this.m_sendThrottleEnabled.get()) {
                return;
            }
            this.m_sendThrottleEnabled.set(true);
            this.m_quietPeriodRunnable = new QuietPeriodRunnable();
            Thread thread = new Thread((Runnable)this.m_quietPeriodRunnable, "RHQ Send Throttle Quiet Period Thread");
            thread.setDaemon(true);
            thread.start();
            LOG.debug("SendThrottle.enabled", new Object[]{this.m_sendThrottleMaxCommands, this.m_sendThrottleQuietPeriodDurationMillis});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableSendThrottling() {
        AtomicBoolean atomicBoolean = this.m_sendThrottleEnabled;
        synchronized (atomicBoolean) {
            this.m_sendThrottleEnabled.set(false);
            if (this.m_quietPeriodRunnable != null) {
                this.m_quietPeriodRunnable.killThread();
                this.m_quietPeriodRunnable = null;
            }
        }
        LOG.debug("SendThrottle.disabled", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilOkToSend() {
        QuietPeriodRunnable quiet_period_runnable;
        AtomicBoolean atomicBoolean = this.m_sendThrottleEnabled;
        synchronized (atomicBoolean) {
            if (!this.m_sendThrottleEnabled.get()) {
                return;
            }
            quiet_period_runnable = this.m_quietPeriodRunnable;
        }
        quiet_period_runnable.waitUntilOkToSend();
    }

    private class QuietPeriodRunnable
    implements Runnable {
        private LinkedBlockingQueue<CountDownLatch> m_latchQueue = new LinkedBlockingQueue();
        private ArrayBlockingQueue<Boolean> m_quietPeriodLock = new ArrayBlockingQueue(1);

        private QuietPeriodRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilOkToSend() {
            CountDownLatch latch;
            QuietPeriodRunnable quietPeriodRunnable = this;
            synchronized (quietPeriodRunnable) {
                if (this.m_quietPeriodLock.peek() != null || this.m_latchQueue == null) {
                    return;
                }
                try {
                    latch = new CountDownLatch(1);
                    this.m_latchQueue.put(latch);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killThread() {
            try {
                QuietPeriodRunnable quietPeriodRunnable = this;
                synchronized (quietPeriodRunnable) {
                    if (this.m_quietPeriodLock.peek() == null && this.m_latchQueue != null) {
                        this.m_quietPeriodLock.put(Boolean.TRUE);
                        this.m_latchQueue.put(new CountDownLatch(1));
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(LOG.getMsgString("SendThrottle.cannot-kill", new Object[0]), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long quiet_period_millis = 1000L;
                boolean keep_going = true;
                while (keep_going) {
                    long max_commands;
                    long num_commands = 0L;
                    do {
                        CountDownLatch latch = this.m_latchQueue.take();
                        latch.countDown();
                        if (this.m_quietPeriodLock.peek() != null) break;
                        ++num_commands;
                        AtomicBoolean atomicBoolean = SendThrottle.this.m_sendThrottleEnabled;
                        synchronized (atomicBoolean) {
                            max_commands = SendThrottle.this.m_sendThrottleMaxCommands;
                            quiet_period_millis = SendThrottle.this.m_sendThrottleQuietPeriodDurationMillis;
                        }
                    } while (num_commands < max_commands);
                    keep_going = this.m_quietPeriodLock.poll(quiet_period_millis, TimeUnit.MILLISECONDS) == null;
                }
            }
            catch (InterruptedException interruptedException) {
                QuietPeriodRunnable quietPeriodRunnable = this;
                synchronized (quietPeriodRunnable) {
                    try {
                        while (!this.m_latchQueue.isEmpty()) {
                            CountDownLatch latch = this.m_latchQueue.take();
                            latch.countDown();
                        }
                    }
                    catch (InterruptedException interruptedException2) {
                    }
                    finally {
                        this.m_latchQueue = null;
                    }
                }
            }
            finally {
                QuietPeriodRunnable max_commands = this;
                synchronized (max_commands) {
                    try {
                        while (!this.m_latchQueue.isEmpty()) {
                            CountDownLatch latch = this.m_latchQueue.take();
                            latch.countDown();
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    finally {
                        this.m_latchQueue = null;
                    }
                }
            }
        }
    }
}

