/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.netservices;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;

public class HTTPNetServiceComponent
implements ResourceComponent,
MeasurementFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String CONFIG_URL = "url";
    public static final String CONFIG_USER = "user";
    public static final String CONFIG_PASSWORD = "password";
    public static final String CONFIG_REALM = "realm";
    public static final String CONFIG_SSL_PROTOCOL = "sslProtocol";
    public static final String CONFIG_METHOD = "method";
    public static final String CONFIG_FOLOW_REDIRECTS = "followRedirects";
    public static final String CONFIG_RESPONSE_PATTERN = "responsePattern";
    private ResourceContext resourceContext;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        String url = resourceContext.getPluginConfiguration().getSimple(CONFIG_URL).getStringValue();
        if (!url.startsWith("http:") && !url.startsWith("https")) {
            throw new InvalidPluginConfigurationException("Url not valid. Must start with 'http:' or 'https:'");
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        try {
            return this.getValuesOrAvailability(null, null) ? AvailabilityType.UP : AvailabilityType.DOWN;
        }
        catch (Exception e) {
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        this.getValuesOrAvailability(report, metrics);
    }

    public boolean getValuesOrAvailability(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        try {
            Configuration config = this.resourceContext.getPluginConfiguration();
            HttpClient httpClient = new HttpClient();
            GetMethod method = new GetMethod(config.getSimple(CONFIG_URL).getStringValue());
            method.setFollowRedirects(config.getSimple(CONFIG_FOLOW_REDIRECTS).getBooleanValue().booleanValue());
            long start = System.currentTimeMillis();
            int responseCode = httpClient.executeMethod((HttpMethod)method);
            long connectTime = System.currentTimeMillis() - start;
            boolean success = config.getSimple("validateResponseCode").getBooleanValue() == false || responseCode >= 200 && responseCode <= 299;
            String response = method.getResponseBodyAsString();
            long readTime = System.currentTimeMillis() - start;
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
            Date contentDate = sdf.parse(method.getResponseHeader("Date").getValue());
            if (metrics != null) {
                for (MeasurementScheduleRequest request : metrics) {
                    if (request.getName().equals("connectTime")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(connectTime)));
                        continue;
                    }
                    if (request.getName().equals("readTime")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(readTime)));
                        continue;
                    }
                    if (request.getName().equals("contentLength")) {
                        report.addData(new MeasurementDataNumeric(request, Double.valueOf(response.length())));
                        continue;
                    }
                    if (!request.getName().equals("contentAge")) continue;
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(System.currentTimeMillis() - contentDate.getTime())));
                }
            }
            return success;
        }
        catch (Exception e) {
            this.log.error((Object)e);
            return false;
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        Configuration config = this.resourceContext.getPluginConfiguration();
        HttpClient httpClient = new HttpClient();
        GetMethod method = new GetMethod(config.getSimple(CONFIG_URL).getStringValue());
        method.setFollowRedirects(config.getSimple(CONFIG_FOLOW_REDIRECTS).getBooleanValue().booleanValue());
        int responseCode = httpClient.executeMethod((HttpMethod)method);
        String response = method.getResponseBodyAsString();
        OperationResult result = new OperationResult(response);
        return result;
    }
}

