/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.agent.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rhq.core.clientapi.descriptor.configuration.MeasurementUnitsDescriptor;
import org.rhq.core.clientapi.descriptor.plugin.MetricDescriptor;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.StringUtils;

public class MetricsMetadataParser {
    public static final long MIN_1 = 60000L;
    public static final long MIN_5 = 300000L;
    public static final long MIN_10 = 600000L;
    public static final long MIN_30 = 1800000L;
    public static final long MINIMUM_INTERVAL = 30000L;

    public static List<MeasurementDefinition> parseMetricsMetadata(MetricDescriptor metricDescriptor, ResourceType resourceType) {
        DataType dataType = DataType.valueOf((String)metricDescriptor.getDataType().toUpperCase());
        DisplayType displayType = DisplayType.valueOf((String)metricDescriptor.getDisplayType().toUpperCase());
        long collectionInterval = 600000L;
        MeasurementUnits units = MetricsMetadataParser.getMeasurementUnits(metricDescriptor.getUnits(), dataType);
        switch (dataType) {
            case MEASUREMENT: {
                switch (resourceType.getCategory()) {
                    case PLATFORM: {
                        collectionInterval = 60000L;
                        break;
                    }
                    case SERVER: {
                        collectionInterval = 300000L;
                        break;
                    }
                    case SERVICE: {
                        collectionInterval = 600000L;
                    }
                }
                collectionInterval = displayType == DisplayType.SUMMARY ? collectionInterval : collectionInterval * 2L;
                break;
            }
            case TRAIT: {
                collectionInterval = displayType == DisplayType.SUMMARY ? 600000L : 1800000L;
                break;
            }
            case CALLTIME: {
                collectionInterval = 60000L;
                if (units == MeasurementUnits.MILLISECONDS) break;
                throw new IllegalStateException("Units must always be set to 'milliseconds' for call-time metrics.");
            }
            default: {
                throw new IllegalStateException("Unsupported metric data type: " + dataType);
            }
        }
        collectionInterval = Math.max(30000L, metricDescriptor.getDefaultInterval() == null ? collectionInterval : metricDescriptor.getDefaultInterval().longValue());
        MeasurementDefinition definition = new MeasurementDefinition(metricDescriptor.getProperty(), MeasurementCategory.valueOf((String)metricDescriptor.getCategory().toUpperCase()), MetricsMetadataParser.getMeasurementUnits(metricDescriptor.getUnits(), dataType), dataType, NumericType.valueOf((String)metricDescriptor.getMeasurementType().toUpperCase()), metricDescriptor.isDefaultOn(), collectionInterval, displayType);
        if (metricDescriptor.getDisplayName() != null) {
            definition.setDisplayName(metricDescriptor.getDisplayName());
        } else {
            definition.setDisplayName(StringUtils.deCamelCase((String)definition.getName()));
        }
        if (metricDescriptor.getDescription() != null) {
            definition.setDescription(metricDescriptor.getDescription());
        } else {
            definition.setDescription(definition.getDisplayName());
        }
        definition.setDestinationType(metricDescriptor.getDestinationType());
        if (definition.getDisplayType() == DisplayType.SUMMARY) {
            definition.setDefaultOn(true);
        }
        if (definition.getNumericType() == NumericType.TRENDSUP || definition.getNumericType() == NumericType.TRENDSDOWN) {
            ArrayList<MeasurementDefinition> definitions = new ArrayList<MeasurementDefinition>();
            MeasurementDefinition perMinuteMetric = new MeasurementDefinition(definition);
            definition.setDisplayType(DisplayType.DETAIL);
            definition.setDefaultOn(false);
            perMinuteMetric.setDisplayName(perMinuteMetric.getDisplayName() + " per Minute");
            perMinuteMetric.setRawNumericType(definition.getNumericType());
            perMinuteMetric.setNumericType(NumericType.DYNAMIC);
            definitions.add(definition);
            definitions.add(perMinuteMetric);
            return definitions;
        }
        return Collections.singletonList(definition);
    }

    static MeasurementUnits getMeasurementUnits(MeasurementUnitsDescriptor descriptor, DataType dataType) {
        if (descriptor == null) {
            return dataType == DataType.CALLTIME ? MeasurementUnits.MILLISECONDS : MeasurementUnits.NONE;
        }
        return MeasurementUnits.valueOf((String)descriptor.name().toUpperCase());
    }
}

