/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.util.units;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.rhq.core.clientapi.util.ArrayUtil;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.clientapi.util.units.DateFormatter;
import org.rhq.core.clientapi.util.units.FormatSpecifics;
import org.rhq.core.clientapi.util.units.FormattedNumber;
import org.rhq.core.clientapi.util.units.Formatter;
import org.rhq.core.clientapi.util.units.ParseSpecifics;
import org.rhq.core.clientapi.util.units.ScaleConstants;
import org.rhq.core.clientapi.util.units.UnitNumber;
import org.rhq.core.clientapi.util.units.UnitsConstants;
import org.rhq.core.clientapi.util.units.UnitsFormat;
import org.rhq.core.clientapi.util.units.UnitsUtil;

public class DurationFormatter
implements Formatter {
    private static final int GRANULAR_YEARS = 1;
    private static final int GRANULAR_DAYS = 2;
    private static final int GRANULAR_HOURS = 3;
    private static final int GRANULAR_MINS = 4;
    private static final int GRANULAR_SECS = 5;
    private static final int MILLISEC_DIGITS = 3;

    @Override
    public FormattedNumber format(UnitNumber val, Locale locale, FormatSpecifics specifics) {
        BigDecimal baseTime = val.getBaseValue();
        int granularity = this.getGranularity(baseTime);
        return this.format(baseTime, granularity, 3, locale);
    }

    @Override
    public FormattedNumber[] formatSame(double[] val, UnitsConstants unitType, ScaleConstants scale, Locale locale, FormatSpecifics specifics) {
        int i;
        FormattedNumber[] res = new FormattedNumber[val.length];
        int maxIdx = ArrayUtil.max(val);
        if (maxIdx == -1) {
            return res;
        }
        UnitNumber tmpNum = new UnitNumber(val[maxIdx], unitType, scale);
        int granularity = this.getGranularity(tmpNum.getBaseValue());
        boolean wholeNum = true;
        double[] secs = new double[val.length];
        for (i = 0; i < secs.length; ++i) {
            TimeBreakDown tbd = this.breakDownTime(UnitsFormat.getBaseValue(val[i], unitType, scale));
            secs[i] = (double)tbd.nSecs + (double)tbd.nMilli / 1000.0;
            if (tbd.nMilli <= 0L) continue;
            wholeNum = false;
        }
        int milliDigits = UnitsUtil.getUniqueDigits(secs, locale);
        if (milliDigits == 0 && !wholeNum) {
            milliDigits = 1;
        }
        for (i = 0; i < val.length; ++i) {
            tmpNum = new UnitNumber(val[i], unitType, scale);
            res[i] = this.format(tmpNum.getBaseValue(), granularity, milliDigits, locale);
        }
        return res;
    }

    private FormattedNumber format(BigDecimal baseTime, int granularity, int milliDigits, Locale locale) {
        String res;
        if (granularity == 1) {
            TimeBreakDown tbd = this.breakDownTime(baseTime);
            res = tbd.nYears + "y " + tbd.nDays + "d";
        } else if (granularity == 2) {
            TimeBreakDown tbd = this.breakDownTime(baseTime);
            long nDays = tbd.nYears * 365L + tbd.nDays;
            res = nDays + (nDays == 1L ? " day " : " days ") + StringUtil.formatDuration((long)(tbd.nHours * 60L * 60L * 1000L + tbd.nMins * 60L * 1000L + tbd.nSecs * 1000L + tbd.nMilli));
        } else if (granularity == 3 || granularity == 4 || granularity == 5) {
            long nMillis = baseTime.divide(UnitsUtil.FACT_MILLIS, 6).longValue();
            res = StringUtil.formatDuration((long)nMillis, (int)milliDigits, (granularity == 5 ? 1 : 0) != 0);
            if (granularity == 5) {
                res = res + 's';
            }
        } else {
            throw new IllegalStateException("Unexpected granularity");
        }
        return new FormattedNumber(res.trim(), "");
    }

    private TimeBreakDown breakDownTime(BigDecimal val) {
        TimeBreakDown r = new TimeBreakDown();
        r.nYears = val.divide(UnitsUtil.FACT_YEARS, 1).intValue();
        if (r.nYears > 0L) {
            val = val.subtract(UnitsUtil.FACT_YEARS.multiply(new BigDecimal(r.nYears)));
        }
        r.nDays = val.divide(UnitsUtil.FACT_DAYS, 1).intValue();
        if (r.nDays > 0L) {
            val = val.subtract(UnitsUtil.FACT_DAYS.multiply(new BigDecimal(r.nDays)));
        }
        r.nHours = val.divide(UnitsUtil.FACT_HOURS, 1).intValue();
        if (r.nHours > 0L) {
            val = val.subtract(UnitsUtil.FACT_HOURS.multiply(new BigDecimal(r.nHours)));
        }
        r.nMins = val.divide(UnitsUtil.FACT_MINS, 1).intValue();
        if (r.nMins > 0L) {
            val = val.subtract(UnitsUtil.FACT_MINS.multiply(new BigDecimal(r.nMins)));
        }
        r.nSecs = val.divide(UnitsUtil.FACT_SECS, 1).intValue();
        if (r.nSecs > 0L) {
            val = val.subtract(UnitsUtil.FACT_SECS.multiply(new BigDecimal(r.nSecs)));
        }
        r.nMilli = val.divide(UnitsUtil.FACT_MILLIS, 1).intValue();
        return r;
    }

    private int getGranularity(BigDecimal nanoSecs) {
        TimeBreakDown tbd = this.breakDownTime(nanoSecs);
        if (tbd.nYears > 0L) {
            return 1;
        }
        if (tbd.nDays > 0L) {
            return 2;
        }
        if (tbd.nHours > 0L) {
            return 3;
        }
        if (tbd.nMins > 0L) {
            return 4;
        }
        return 5;
    }

    @Override
    public BigDecimal getBaseValue(double value, ScaleConstants scale) {
        return DateFormatter.getBaseTime(value, scale);
    }

    @Override
    public BigDecimal getScaledValue(BigDecimal value, ScaleConstants targScale) {
        return DateFormatter.getScaledTime(value, targScale);
    }

    private double parseTimeStr(String duration) throws ParseException {
        String[] vals = StringUtil.explodeToArray((String)duration, (String)":");
        if (vals.length != 3) {
            throw new ParseException(duration, 0);
        }
        try {
            double nHours = Double.parseDouble(vals[0]);
            double nMins = Double.parseDouble(vals[1]);
            double nSecs = Double.parseDouble(vals[2]);
            return nHours * 60.0 * 60.0 + nMins * 60.0 + nSecs;
        }
        catch (NumberFormatException exc) {
            throw new ParseException(duration, 0);
        }
    }

    private UnitNumber parseRegular(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        String[] vals = StringUtil.explodeToArray((String)val, (String)" ");
        if (vals.length == 2 && vals[0].charAt(vals[0].length() - 1) == 'y' && vals[1].charAt(vals[1].length() - 1) == 'd') {
            try {
                String yStr = vals[0].substring(0, vals[0].length() - 1);
                String dStr = vals[1].substring(0, vals[1].length() - 1);
                return new UnitNumber(Integer.parseInt(yStr) * 365 + Integer.parseInt(dStr), UnitsConstants.UNIT_DURATION, ScaleConstants.SCALE_DAY);
            }
            catch (NumberFormatException exc) {}
        } else if (vals.length == 3 && (vals[1].equals("day") || vals[1].equals("days"))) {
            try {
                return new UnitNumber((double)(Integer.parseInt(vals[0]) * 24 * 60 * 60) + this.parseTimeStr(vals[2]), UnitsConstants.UNIT_DURATION, ScaleConstants.SCALE_SEC);
            }
            catch (NumberFormatException exc) {
            }
        } else if (vals.length == 1) {
            return new UnitNumber(this.parseTimeStr(vals[0]), UnitsConstants.UNIT_DURATION, ScaleConstants.SCALE_SEC);
        }
        throw new ParseException(val, 0);
    }

    @Override
    public UnitNumber parse(String val, Locale locale, ParseSpecifics specifics) throws ParseException {
        NumberFormat fmt = NumberFormat.getInstance(locale);
        try {
            return this.parseRegular(val, locale, specifics);
        }
        catch (ParseException exc) {
            ScaleConstants scale;
            int nonIdx = UnitsUtil.findNonNumberIdx(val, fmt);
            if (nonIdx == -1) {
                throw new ParseException("Number had no units with it", val.length());
            }
            if (nonIdx == 0) {
                throw new ParseException("Invalid number specified", 0);
            }
            double numberPart = fmt.parse(val.substring(0, nonIdx)).doubleValue();
            String tagPart = val.substring(nonIdx, val.length()).trim();
            if (tagPart.equalsIgnoreCase("y") || tagPart.equalsIgnoreCase("yr") || tagPart.equalsIgnoreCase("yrs") || tagPart.equalsIgnoreCase("year") || tagPart.equalsIgnoreCase("years")) {
                scale = ScaleConstants.SCALE_YEAR;
            } else if (tagPart.equalsIgnoreCase("w") || tagPart.equalsIgnoreCase("wk") || tagPart.equalsIgnoreCase("wks") || tagPart.equalsIgnoreCase("week") || tagPart.equalsIgnoreCase("weeks")) {
                scale = ScaleConstants.SCALE_WEEK;
            } else if (tagPart.equalsIgnoreCase("d") || tagPart.equalsIgnoreCase("day") || tagPart.equalsIgnoreCase("days")) {
                scale = ScaleConstants.SCALE_DAY;
            } else if (tagPart.equalsIgnoreCase("h") || tagPart.equalsIgnoreCase("hr") || tagPart.equalsIgnoreCase("hrs") || tagPart.equalsIgnoreCase("hour") || tagPart.equalsIgnoreCase("hours")) {
                scale = ScaleConstants.SCALE_HOUR;
            } else if (tagPart.equalsIgnoreCase("m") || tagPart.equalsIgnoreCase("min") || tagPart.equalsIgnoreCase("mins") || tagPart.equalsIgnoreCase("minute") || tagPart.equalsIgnoreCase("minutes")) {
                scale = ScaleConstants.SCALE_MIN;
            } else if (tagPart.equalsIgnoreCase("s") || tagPart.equalsIgnoreCase("sec") || tagPart.equalsIgnoreCase("secs") || tagPart.equalsIgnoreCase("second") || tagPart.equalsIgnoreCase("seconds")) {
                scale = ScaleConstants.SCALE_SEC;
            } else if (tagPart.equalsIgnoreCase("j") || tagPart.equalsIgnoreCase("jif") || tagPart.equalsIgnoreCase("jifs") || tagPart.equalsIgnoreCase("jiffy") || tagPart.equalsIgnoreCase("jiffys") || tagPart.equalsIgnoreCase("jifferoonies")) {
                scale = ScaleConstants.SCALE_JIFFY;
            } else if (tagPart.equalsIgnoreCase("ms") || tagPart.equalsIgnoreCase("milli") || tagPart.equalsIgnoreCase("millis") || tagPart.equalsIgnoreCase("millisecond") || tagPart.equalsIgnoreCase("milliseconds")) {
                scale = ScaleConstants.SCALE_MILLI;
            } else if (tagPart.equalsIgnoreCase("us") || tagPart.equalsIgnoreCase("micro") || tagPart.equalsIgnoreCase("micros") || tagPart.equalsIgnoreCase("microsecond") || tagPart.equalsIgnoreCase("microseconds")) {
                scale = ScaleConstants.SCALE_MICRO;
            } else if (tagPart.equalsIgnoreCase("ns") || tagPart.equalsIgnoreCase("nano") || tagPart.equalsIgnoreCase("nanos") || tagPart.equalsIgnoreCase("nanosecond") || tagPart.equalsIgnoreCase("nanoseconds")) {
                scale = ScaleConstants.SCALE_NANO;
            } else {
                throw new ParseException("Unknown duration '" + tagPart + "'", nonIdx);
            }
            return new UnitNumber(numberPart, UnitsConstants.UNIT_DURATION, scale);
        }
    }

    private class TimeBreakDown {
        long nYears;
        long nDays;
        long nHours;
        long nMins;
        long nSecs;
        long nMilli;

        private TimeBreakDown() {
        }
    }
}

