/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.SigarProxy;
import org.rhq.core.system.SystemInfoException;

public class CpuInformation {
    private final Log log = LogFactory.getLog(this.getClass());
    private final int cpuIndex;
    private Cpu cpu;
    private CpuInfo cpuInfo;
    private CpuPerc cpuPercentage;
    private boolean enabled;
    private SigarProxy sigar;

    public CpuInformation(int index, SigarProxy sigar) {
        this.cpuIndex = index;
        this.sigar = sigar;
        this.refresh();
    }

    public int getCpuIndex() {
        return this.cpuIndex;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public CpuInfo getCpuInfo() {
        return this.cpuInfo;
    }

    public CpuPerc getCpuPercentage() {
        return this.cpuPercentage;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void refresh() {
        try {
            CpuInfo[] cpuInfoList = this.sigar.getCpuInfoList();
            if (cpuInfoList != null && cpuInfoList.length >= 1) {
                this.cpuInfo = cpuInfoList[0];
            } else {
                this.log.error((Object)("Sigar.getCpuInfoList() returned null or empty array: " + (cpuInfoList != null ? Arrays.asList(cpuInfoList) : cpuInfoList)));
                this.cpuInfo = null;
            }
            Cpu[] cpuList = this.sigar.getCpuList();
            if (cpuList != null && this.cpuIndex < cpuList.length) {
                this.cpu = cpuList[this.cpuIndex];
            } else {
                this.log.debug((Object)("Sigar.getCpuList() returned null or array with size smaller than or equal to this CPU's index (" + this.cpuIndex + "): " + (cpuList != null ? Arrays.asList(cpuList) : cpuList)));
                this.cpu = null;
            }
            CpuPerc[] cpuPercentageList = this.sigar.getCpuPercList();
            if (cpuPercentageList != null && this.cpuIndex < cpuPercentageList.length) {
                this.cpuPercentage = cpuPercentageList[this.cpuIndex];
            } else {
                this.log.debug((Object)("Sigar.getCpuPercList() returned null or array with size smaller than or equal to this CPU's index (" + this.cpuIndex + "): " + (cpuPercentageList != null ? Arrays.asList(cpuPercentageList) : cpuPercentageList)));
                this.cpuPercentage = null;
            }
        }
        catch (Exception e) {
            throw new SystemInfoException("Cannot refresh the native CPU information", e);
        }
        this.enabled = this.cpuInfo != null && this.cpu != null && this.cpuPercentage != null;
    }
}

