/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.event.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.event.Event;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.event.log.LogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogFileInfo;

public class LogFileEventPoller
implements EventPoller {
    private final Log log = LogFactory.getLog(this.getClass());
    private String eventType;
    private File logFile;
    private FileInfo logFileInfo;
    private LogEntryProcessor entryProcessor;

    public LogFileEventPoller(EventContext eventContext, String eventType, File logFile, LogEntryProcessor entryProcessor) {
        this.eventType = eventType;
        this.logFile = logFile;
        SigarProxy sigar = eventContext.getSigar();
        try {
            this.logFileInfo = new LogFileInfo(sigar.getFileInfo(logFile.getPath()));
        }
        catch (SigarException e) {
            throw new RuntimeException(e);
        }
        this.entryProcessor = entryProcessor;
    }

    @Override
    @NotNull
    public String getEventType() {
        return this.eventType;
    }

    @NotNull
    public String getSourceLocation() {
        return this.logFile.getPath();
    }

    @Override
    @Nullable
    public Set<Event> poll() {
        if (!this.logFile.exists()) {
            this.log.warn((Object)("Log file [" + this.logFile + "' being polled does not exist."));
            return null;
        }
        if (this.logFile.isDirectory()) {
            this.log.error((Object)("Log file [" + this.logFile + "' being polled is a directory, not a regular file."));
            return null;
        }
        try {
            if (!this.logFileInfo.changed()) {
                return null;
            }
        }
        catch (SigarException e) {
            throw new RuntimeException(e);
        }
        return this.processNewLines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Event> processNewLines() {
        Set<Event> events = null;
        FileReader reader = null;
        try {
            reader = new FileReader(this.logFile);
            long offset = this.getOffset();
            if (offset > 0L) {
                reader.skip(offset);
            }
            BufferedReader bufferedReader = new BufferedReader(reader);
            events = this.entryProcessor.processLines(bufferedReader);
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to read log file being tailed: " + this.logFile), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
        return events;
    }

    private long getOffset() {
        FileInfo previousFileInfo = this.logFileInfo.getPreviousInfo();
        if (previousFileInfo == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.logFile + ": first stat"));
            }
            return this.logFileInfo.getSize();
        }
        if (this.logFileInfo.getInode() != previousFileInfo.getInode()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.logFile + ": file inode changed"));
            }
            return -1L;
        }
        if (this.logFileInfo.getSize() < previousFileInfo.getSize()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.logFile + ": file truncated"));
            }
            return -1L;
        }
        if (this.log.isDebugEnabled()) {
            long diff = this.logFileInfo.getSize() - previousFileInfo.getSize();
            this.log.debug((Object)(this.logFile + ": " + diff + " new bytes"));
        }
        return previousFileInfo.getSize();
    }
}

