/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.filetemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bundle.filetemplate.recipe.RecipeContext;
import org.rhq.bundle.filetemplate.recipe.RecipeParser;
import org.rhq.core.domain.bundle.BundleResourceDeployment;
import org.rhq.core.domain.bundle.BundleResourceDeploymentHistory;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.pluginapi.bundle.BundleManagerProvider;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.util.file.FileUtil;

public class ProcessingRecipeContext
extends RecipeContext {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final SystemInfo systemInfo;
    private final String baseWorkingDirectory;
    private final BundleResourceDeployment bundleResourceDeployment;
    private final BundleManagerProvider bundleManagerProvider;

    public ProcessingRecipeContext(String recipe, Map<PackageVersion, File> packageVersionFiles, SystemInfo systemInfo, String baseWorkingDirectory, BundleResourceDeployment bundleResourceDeployment, BundleManagerProvider bundleManagerProvider) {
        super(recipe);
        this.systemInfo = systemInfo;
        this.baseWorkingDirectory = baseWorkingDirectory;
        this.bundleResourceDeployment = bundleResourceDeployment;
        this.bundleManagerProvider = bundleManagerProvider;
    }

    public void addDeployFile(String filename, String directory) {
        super.addDeployFile(filename, directory);
        File existingFile = new File(this.baseWorkingDirectory, filename);
        ProcessExecution pe = this.getUnzipExecution(existingFile, directory);
        if (pe != null) {
            ProcessExecutionResults results = this.systemInfo.executeProcess(pe);
            if (results.getError() != null) {
                String msg = "Could not unbundle file [" + pe + "]: " + results;
                this.audit("deploy", BundleResourceDeploymentHistory.Status.FAILURE, msg);
                throw new RuntimeException(msg, results.getError());
            }
            if (results.getExitCode() == null || results.getExitCode() > 0) {
                String msg = "Failed to unbundle file [" + pe + "]: " + results;
                this.audit("deploy", BundleResourceDeploymentHistory.Status.FAILURE, msg);
                throw new RuntimeException(msg);
            }
            String msg = "extracted files from [" + existingFile + "] to [" + directory + "]";
            this.audit("deploy", BundleResourceDeploymentHistory.Status.SUCCESS, msg);
        } else {
            File newFile = new File(directory, filename);
            if (!existingFile.renameTo(newFile)) {
                String msg = "Failed to move [" + existingFile + "] to [" + newFile + "]";
                this.audit("deploy", BundleResourceDeploymentHistory.Status.FAILURE, msg);
                throw new RuntimeException(msg);
            }
            this.audit("deploy", BundleResourceDeploymentHistory.Status.SUCCESS, "renamed [" + existingFile + "] to [" + newFile + "]");
        }
    }

    public void addFile(String source, String destination) {
        super.addFile(source, destination);
        File sourceFile = new File(this.baseWorkingDirectory, source);
        File destinationFile = new File(destination);
        try {
            destinationFile.getParentFile().mkdirs();
            FileUtil.copyFile((File)sourceFile, (File)destinationFile);
            this.audit("file", BundleResourceDeploymentHistory.Status.SUCCESS, "copied file [" + sourceFile + "] to [" + destinationFile + "]");
        }
        catch (Exception e) {
            String msg = "Failed to copy file [" + sourceFile + "] to [" + destinationFile + "]";
            this.audit("file", BundleResourceDeploymentHistory.Status.FAILURE, msg);
            throw new RuntimeException(msg, e);
        }
    }

    public void addRealizedFile(String file) {
        super.addRealizedFile(file);
        File trueFile = new File(file);
        RecipeParser parser = this.getParser();
        File realizedTmpFile = null;
        OutputStreamWriter realizedTmpFileWriter = null;
        BufferedReader reader = null;
        try {
            realizedTmpFile = File.createTempFile("rhq-realize-", ".tmp", trueFile.getParentFile());
            realizedTmpFileWriter = new FileWriter(realizedTmpFile);
            reader = new BufferedReader(new FileReader(trueFile));
            String line = reader.readLine();
            while (line != null) {
                line = parser.replaceReplacementVariables((RecipeContext)this, line);
                realizedTmpFileWriter.write(line);
                realizedTmpFileWriter.write("\n");
                line = reader.readLine();
            }
            realizedTmpFileWriter.close();
            realizedTmpFileWriter = null;
            reader.close();
            reader = null;
            this.audit("realize", BundleResourceDeploymentHistory.Status.SUCCESS, "realized [" + file + "]");
            trueFile.delete();
            if (!realizedTmpFile.renameTo(trueFile)) {
                String msg = "Failed to rename realized tmp file [" + realizedTmpFile + "] to [" + trueFile + "]";
                this.audit("realize", BundleResourceDeploymentHistory.Status.FAILURE, msg);
                throw new RuntimeException(msg);
            }
            this.audit("realize", BundleResourceDeploymentHistory.Status.SUCCESS, "renamed realized file [" + realizedTmpFile + "] to [" + trueFile + "]");
        }
        catch (Exception e) {
            String msg = "Cannot realize file [" + file + "]";
            this.audit("realize", BundleResourceDeploymentHistory.Status.FAILURE, msg);
            throw new RuntimeException(msg, e);
        }
        finally {
            if (realizedTmpFileWriter != null) {
                try {
                    realizedTmpFileWriter.close();
                }
                catch (Exception e) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (realizedTmpFile != null && realizedTmpFile.exists()) {
                realizedTmpFile.delete();
            }
        }
    }

    public void addReplacementVariables(Set<String> replacementVariables) {
        super.addReplacementVariables(replacementVariables);
    }

    public void addScript(String exe, List<String> exeArgs) {
        super.addScript(exe, exeArgs);
        File scriptFile = new File(this.baseWorkingDirectory, exe);
        this.ensureExecutable(scriptFile);
        ProcessExecution pe = new ProcessExecution(scriptFile.getAbsolutePath());
        pe.setArguments(exeArgs);
        pe.setWaitForCompletion(1800000L);
        pe.setWorkingDirectory(scriptFile.getParent());
        ProcessExecutionResults results = this.systemInfo.executeProcess(pe);
        if (results.getError() != null) {
            String msg = "Could not execute script [" + pe + "]: " + results;
            this.audit("script", BundleResourceDeploymentHistory.Status.FAILURE, msg);
            throw new RuntimeException(msg, results.getError());
        }
        String msg = "Executed script [" + pe + "]";
        this.audit("script", BundleResourceDeploymentHistory.Status.SUCCESS, msg);
    }

    public void addCommand(String exe, List<String> exeArgs) {
        super.addCommand(exe, exeArgs);
        ProcessExecution pe = new ProcessExecution(exe);
        pe.setArguments(exeArgs);
        pe.setWaitForCompletion(1800000L);
        pe.setCheckExecutableExists(false);
        pe.setWorkingDirectory(this.baseWorkingDirectory);
        ProcessExecutionResults results = this.systemInfo.executeProcess(pe);
        if (results.getError() != null) {
            String msg = "Could not execute command [" + pe + "]: " + results;
            this.audit("command", BundleResourceDeploymentHistory.Status.FAILURE, msg);
            throw new RuntimeException(msg, results.getError());
        }
        String msg = "Executed command [" + pe + "]";
        this.audit("command", BundleResourceDeploymentHistory.Status.SUCCESS, msg);
    }

    private void audit(String action, BundleResourceDeploymentHistory.Status status, String message) {
        try {
            this.bundleManagerProvider.auditDeployment(this.bundleResourceDeployment, action, "recipe", null, status, message, null);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Deployment [" + this.bundleResourceDeployment.getBundleDeployment().getBundleVersion() + "] audit: action=[" + action + "], status=[" + status + "], message: " + message));
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to send audit message for deployment of [" + this.bundleResourceDeployment.getBundleDeployment().getBundleVersion() + "]. audit action=[" + action + "], status=[" + status + "], message: " + message));
        }
    }

    private void ensureExecutable(File scriptFile) {
        boolean success = scriptFile.setExecutable(true, true);
        if (!success) {
            String msg = "Cannot ensure that script [" + scriptFile + "] is executable";
            this.audit("ensureExecutable", BundleResourceDeploymentHistory.Status.FAILURE, msg);
            throw new RuntimeException(msg);
        }
    }

    private ProcessExecution getUnzipExecution(File file, String directory) {
        String exe;
        ArrayList<String> args = null;
        String filepath = file.getAbsolutePath();
        if (filepath.endsWith(".tar")) {
            exe = "tar";
            args = new ArrayList<String>();
            args.add("xf");
            args.add(filepath);
            args.add("-C");
            args.add(directory);
        } else if (filepath.endsWith(".tar.bz2") || filepath.endsWith(".tbz2") || filepath.endsWith(".tbz")) {
            exe = "tar";
            args = new ArrayList();
            args.add("xfj");
            args.add(filepath);
            args.add("-C");
            args.add(directory);
        } else if (filepath.endsWith(".tar.gz") || filepath.endsWith(".tgz")) {
            exe = "tar";
            args = new ArrayList();
            args.add("xfz");
            args.add(filepath);
            args.add("-C");
            args.add(directory);
        } else if (filepath.endsWith(".zip")) {
            exe = "unzip";
            args = new ArrayList();
            args.add("-o");
            args.add(filepath);
            args.add("-d");
            args.add(directory);
        } else if (filepath.endsWith(".rpm")) {
            exe = "rpm";
            args = new ArrayList();
            args.add("-i");
            args.add(filepath);
            if (directory != null && directory.length() > 0) {
                args.add("--prefix");
                args.add(directory);
            }
        } else {
            return null;
        }
        ProcessExecution pe = new ProcessExecution(exe);
        pe.setArguments(args);
        pe.setWaitForCompletion(1800000L);
        pe.setCheckExecutableExists(false);
        pe.setWorkingDirectory(this.baseWorkingDirectory);
        return pe;
    }
}

