/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.oil2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.Invoker;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILJMXService;
import org.jboss.mq.il.oil2.OIL2ClientIL;
import org.jboss.mq.il.oil2.OIL2Request;
import org.jboss.mq.il.oil2.OIL2RequestListner;
import org.jboss.mq.il.oil2.OIL2Response;
import org.jboss.mq.il.oil2.OIL2ServerIL;
import org.jboss.mq.il.oil2.OIL2ServerILServiceMBean;
import org.jboss.mq.il.oil2.OIL2SocketHandler;
import org.jboss.security.SecurityDomain;

public final class OIL2ServerILService
extends ServerILJMXService
implements Runnable,
OIL2ServerILServiceMBean {
    private static final Logger log = Logger.getLogger(OIL2ServerILService.class);
    private static final int SO_TIMEOUT = 5000;
    private Invoker server;
    private boolean enableTcpNoDelay = false;
    private String securityDomain;
    private String clientSocketFactoryName;
    private ServerSocketFactory serverSocketFactory;
    private ServerSocket serverSocket;
    private OIL2ServerIL serverIL;
    private volatile boolean running;
    private int serverBindPort = 0;
    private InetAddress bindAddress = null;
    private Properties connectionProperties;

    public Properties getClientConnectionProperties() {
        return this.connectionProperties;
    }

    public String getName() {
        return "JBossMQ-OILServerIL";
    }

    public ServerIL getServerIL() {
        return this.serverIL;
    }

    public void run() {
        block12: while (true) {
            try {
                while (this.running) {
                    Socket socket;
                    block17: {
                        socket = null;
                        try {
                            socket = this.serverSocket.accept();
                            if (!log.isTraceEnabled()) break block17;
                            log.trace("Accepted connection: " + socket);
                        }
                        catch (InterruptedIOException e) {
                            continue;
                        }
                    }
                    if (!this.running) {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    try {
                        OIL2SocketHandler socketHandler;
                        if (log.isTraceEnabled()) {
                            log.trace("Initializing RequestListner for socket: " + socket);
                        }
                        RequestListner requestListner = new RequestListner(socket);
                        requestListner.socketHandler = socketHandler = new OIL2SocketHandler(requestListner.in, requestListner.out, Thread.currentThread().getThreadGroup());
                        socketHandler.setRequestListner(requestListner);
                        socketHandler.start();
                        continue block12;
                    }
                    catch (IOException ie) {
                        log.debug("Client connection could not be accepted: ", ie);
                    }
                }
                break;
            }
            catch (SocketException e) {
                if (!this.running) break;
                log.warn("SocketException occured (Connection reset by peer?). Cannot initialize the OIL2ServerILService.");
                break;
            }
            catch (IOException e) {
                if (!this.running) break;
                log.warn("IOException occured. Cannot initialize the OIL2ServerILService.");
                break;
            }
            catch (Throwable t) {
                log.warn("Unexpected error occured. Cannot initialize the OIL2ServerILService.", t);
                break;
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            log.debug("error closing server socket", e);
        }
    }

    public void startService() throws Exception {
        super.startService();
        this.running = true;
        this.server = this.lookupJMSServer();
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        if (this.securityDomain != null) {
            try {
                InitialContext ctx = new InitialContext();
                Class<?> ssfClass = this.serverSocketFactory.getClass();
                SecurityDomain domain = (SecurityDomain)ctx.lookup(this.securityDomain);
                Class[] parameterTypes = new Class[]{SecurityDomain.class};
                Method m = ssfClass.getMethod("setSecurityDomain", parameterTypes);
                Object[] args = new Object[]{domain};
                m.invoke((Object)this.serverSocketFactory, args);
            }
            catch (NoSuchMethodException e) {
                log.error("Socket factory does not support setSecurityDomain(SecurityDomain)");
            }
            catch (Exception e) {
                log.error("Failed to setSecurityDomain=" + this.securityDomain + " on socket factory");
            }
        }
        this.serverSocket = this.serverSocketFactory.createServerSocket(this.serverBindPort, 50, this.bindAddress);
        this.serverSocket.setSoTimeout(5000);
        InetAddress socketAddress = this.serverSocket.getInetAddress();
        log.info("JBossMQ OIL2 service available at : " + socketAddress + ":" + this.serverSocket.getLocalPort());
        new Thread(this.server.getThreadGroup(), this, "OIL2 Worker Server").start();
        if (socketAddress.toString().equals("0.0.0.0/0.0.0.0")) {
            socketAddress = InetAddress.getLocalHost();
        }
        this.serverIL = new OIL2ServerIL(socketAddress.getHostAddress(), this.serverSocket.getLocalPort(), this.clientSocketFactoryName, this.enableTcpNoDelay);
        this.connectionProperties = super.getClientConnectionProperties();
        this.connectionProperties.setProperty("ClientILService", "org.jboss.mq.il.oil2.OIL2ClientILService");
        this.connectionProperties.setProperty("OIL2_PORT_KEY", "" + this.serverSocket.getLocalPort());
        this.connectionProperties.setProperty("OIL2_ADDRESS_KEY", "" + socketAddress.getHostAddress());
        this.connectionProperties.setProperty("OIL2_TCPNODELAY_KEY", this.enableTcpNoDelay ? "yes" : "no");
        this.bindJNDIReferences();
    }

    public void stopService() {
        try {
            this.unbindJNDIReferences();
        }
        catch (Exception e) {
            log.error("Exception unbinding from JNDI", e);
        }
        try {
            this.running = false;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (Exception e) {
            log.debug("Exception stopping server thread", e);
        }
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public void setServerBindPort(int serverBindPort) {
        this.serverBindPort = serverBindPort;
    }

    public String getBindAddress() {
        String addr = "0.0.0.0";
        if (this.bindAddress != null) {
            addr = this.bindAddress.getHostName();
        }
        return addr;
    }

    public void setBindAddress(String host) throws UnknownHostException {
        this.bindAddress = host == null || host.length() == 0 ? null : InetAddress.getByName(host);
    }

    public boolean getEnableTcpNoDelay() {
        return this.enableTcpNoDelay;
    }

    public void setEnableTcpNoDelay(boolean enableTcpNoDelay) {
        this.enableTcpNoDelay = enableTcpNoDelay;
    }

    public String getClientSocketFactory() {
        return this.clientSocketFactoryName;
    }

    public void setClientSocketFactory(String name) {
        this.clientSocketFactoryName = name;
    }

    public void setServerSocketFactory(String name) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> ssfClass = loader.loadClass(name);
        this.serverSocketFactory = (ServerSocketFactory)ssfClass.newInstance();
    }

    public String getServerSocketFactory() {
        String name = null;
        if (this.serverSocketFactory != null) {
            name = this.serverSocketFactory.getClass().getName();
        }
        return name;
    }

    public void setSecurityDomain(String domainName) {
        this.securityDomain = domainName;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public class RequestListner
    implements OIL2RequestListner {
        Socket socket;
        ObjectInputStream in;
        ObjectOutputStream out;
        OIL2SocketHandler socketHandler;
        ConnectionToken connectionToken;
        boolean closing = false;

        RequestListner(Socket socket) throws IOException {
            socket.setSoTimeout(0);
            socket.setTcpNoDelay(OIL2ServerILService.this.enableTcpNoDelay);
            this.out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.out.flush();
            this.in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }

        public void handleRequest(OIL2Request request) {
            if (this.closing) {
                log.trace("A connection that is closing received another request.  Droping request.");
                return;
            }
            Object result = null;
            Exception resultException = null;
            try {
                switch (request.operation) {
                    case 14: {
                        this.connectionToken = (ConnectionToken)request.arguments[0];
                        ((OIL2ClientIL)this.connectionToken.clientIL).setRequestListner(this);
                        break;
                    }
                    case 1: {
                        OIL2ServerILService.this.server.acknowledge(this.connectionToken, (AcknowledgementRequest)request.arguments[0]);
                        break;
                    }
                    case 2: {
                        OIL2ServerILService.this.server.addMessage(this.connectionToken, (SpyMessage)request.arguments[0]);
                        break;
                    }
                    case 3: {
                        result = OIL2ServerILService.this.server.browse(this.connectionToken, (Destination)request.arguments[0], (String)request.arguments[1]);
                        break;
                    }
                    case 4: {
                        OIL2ServerILService.this.server.checkID((String)request.arguments[0]);
                        if (this.connectionToken != null) {
                            this.connectionToken.setClientID((String)request.arguments[0]);
                        }
                        break;
                    }
                    case 5: {
                        this.beginClose();
                        break;
                    }
                    case 6: {
                        result = OIL2ServerILService.this.server.createQueue(this.connectionToken, (String)request.arguments[0]);
                        break;
                    }
                    case 7: {
                        result = OIL2ServerILService.this.server.createTopic(this.connectionToken, (String)request.arguments[0]);
                        break;
                    }
                    case 8: {
                        OIL2ServerILService.this.server.deleteTemporaryDestination(this.connectionToken, (SpyDestination)request.arguments[0]);
                        break;
                    }
                    case 9: {
                        result = OIL2ServerILService.this.server.getID();
                        if (this.connectionToken != null) {
                            this.connectionToken.setClientID((String)result);
                        }
                        break;
                    }
                    case 10: {
                        result = OIL2ServerILService.this.server.getTemporaryQueue(this.connectionToken);
                        break;
                    }
                    case 11: {
                        result = OIL2ServerILService.this.server.getTemporaryTopic(this.connectionToken);
                        break;
                    }
                    case 12: {
                        result = OIL2ServerILService.this.server.receive(this.connectionToken, (Integer)request.arguments[0], (Long)request.arguments[1]);
                        break;
                    }
                    case 13: {
                        OIL2ServerILService.this.server.setEnabled(this.connectionToken, (Boolean)request.arguments[0]);
                        break;
                    }
                    case 15: {
                        OIL2ServerILService.this.server.subscribe(this.connectionToken, (Subscription)request.arguments[0]);
                        break;
                    }
                    case 16: {
                        OIL2ServerILService.this.server.transact(this.connectionToken, (TransactionRequest)request.arguments[0]);
                        break;
                    }
                    case 17: {
                        OIL2ServerILService.this.server.unsubscribe(this.connectionToken, (Integer)request.arguments[0]);
                        break;
                    }
                    case 18: {
                        OIL2ServerILService.this.server.destroySubscription(this.connectionToken, (DurableSubscriptionID)request.arguments[0]);
                        break;
                    }
                    case 19: {
                        result = OIL2ServerILService.this.server.checkUser((String)request.arguments[0], (String)request.arguments[1]);
                        break;
                    }
                    case 20: {
                        OIL2ServerILService.this.server.ping(this.connectionToken, (Long)request.arguments[0]);
                        break;
                    }
                    case 22: {
                        result = OIL2ServerILService.this.server.authenticate((String)request.arguments[0], (String)request.arguments[1]);
                        break;
                    }
                    default: {
                        throw new RemoteException("Bad method code !");
                    }
                }
            }
            catch (Exception e) {
                resultException = e;
            }
            try {
                OIL2Response response = new OIL2Response(request);
                response.result = result;
                response.exception = resultException;
                this.socketHandler.sendResponse(response);
            }
            catch (IOException e) {
                this.handleConnectionException(e);
            }
        }

        public void handleConnectionException(Exception e) {
            if (!this.closing) {
                log.info("Client Disconnected: " + e);
            }
            this.beginClose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beginClose() {
            this.closing = true;
            try {
                if (this.connectionToken != null) {
                    OIL2ServerILService.this.server.connectionClosing(this.connectionToken);
                }
            }
            catch (JMSException jMSException) {
            }
            finally {
                this.close();
            }
        }

        void close() {
            try {
                if (this.socket != null) {
                    this.socketHandler.stop();
                    this.in.close();
                    this.out.close();
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException e) {
                log.debug("Exception occured while closing opened resources: ", e);
            }
        }

        public OIL2SocketHandler getSocketHandler() {
            return this.socketHandler;
        }
    }
}

