/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.content;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.content.ContentAgentService;
import org.rhq.core.clientapi.server.content.ContentDiscoveryReport;
import org.rhq.core.clientapi.server.content.ContentServerService;
import org.rhq.core.clientapi.server.content.DeletePackagesRequest;
import org.rhq.core.clientapi.server.content.DeployPackagesRequest;
import org.rhq.core.clientapi.server.content.RetrievePackageBitsRequest;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.content.ContentContextImpl;
import org.rhq.core.pc.content.ContentDiscoveryRunner;
import org.rhq.core.pc.content.CreateContentRunner;
import org.rhq.core.pc.content.DeleteContentRunner;
import org.rhq.core.pc.content.RetrieveContentBitsRunner;
import org.rhq.core.pc.content.ScheduledContentDiscoveryInfo;
import org.rhq.core.pc.inventory.InventoryEventListener;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;

public class ContentManager
extends AgentService
implements ContainerService,
ContentAgentService,
ContentServices {
    private static final int FACET_METHOD_TIMEOUT = 3600000;
    private final Log log = LogFactory.getLog(ContentManager.class);
    private PluginContainerConfiguration configuration;
    private boolean scheduledDiscoveriesEnabled;
    private ScheduledThreadPoolExecutor discoveryThreadPoolExecutor;
    private ExecutorService crudExecutor;
    private final Queue<ScheduledContentDiscoveryInfo> scheduledDiscoveries = new PriorityQueue<ScheduledContentDiscoveryInfo>();
    private ContentInventoryEventListener inventoryEventListener;

    public ContentManager() {
        super(ContentAgentService.class);
    }

    @Override
    public void initialize() {
        this.log.info((Object)"Initializing Content Manager...");
        this.scheduledDiscoveriesEnabled = this.configuration.getContentDiscoveryPeriod() > 0L;
        int threadPoolSize = this.configuration.getContentDiscoveryThreadPoolSize();
        this.discoveryThreadPoolExecutor = new ScheduledThreadPoolExecutor(threadPoolSize, new LoggingThreadFactory("Content.discovery", true));
        this.discoveryThreadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.discoveryThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.crudExecutor = new ThreadPoolExecutor(1, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new LoggingThreadFactory("Content.crud", true));
        if (this.scheduledDiscoveriesEnabled) {
            this.log.info((Object)"Initializing scheduled content discovery...");
            ContentDiscoveryRunner runner = new ContentDiscoveryRunner(this);
            long initialDelay = this.configuration.getContentDiscoveryInitialDelay();
            long discoveryPeriod = this.configuration.getContentDiscoveryPeriod();
            this.discoveryThreadPoolExecutor.scheduleAtFixedRate(runner, initialDelay, discoveryPeriod, TimeUnit.SECONDS);
            this.inventoryEventListener = new ContentInventoryEventListener();
            InventoryManager im = PluginContainer.getInstance().getInventoryManager();
            im.notifyForAllActivatedResources(this.inventoryEventListener);
            im.addInventoryEventListener(this.inventoryEventListener);
        }
        this.log.info((Object)"Content Manager initialized...");
    }

    @Override
    public void shutdown() {
        this.log.info((Object)"Shutting down Content Manager...");
        this.discoveryThreadPoolExecutor.shutdown();
        this.crudExecutor.shutdown();
        PluginContainer.getInstance().getInventoryManager().removeInventoryEventListener(this.inventoryEventListener);
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public Set<ResourcePackageDetails> getLastDiscoveredResourcePackages(int resourceId) {
        InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
        ResourceContainer container = inventoryManager.getResourceContainer(resourceId);
        if (container == null || ResourceContainer.ResourceComponentState.STARTED != container.getResourceComponentState()) {
            throw new RuntimeException("Container is non-existent or is not running for resource id [" + resourceId + "]");
        }
        return container.getInstalledPackages();
    }

    public ContentDiscoveryReport executeResourcePackageDiscoveryImmediately(int resourceId, String packageTypeName) throws PluginContainerException {
        ContentDiscoveryReport results;
        PackageType packageType = this.findPackageType(resourceId, packageTypeName);
        if (packageType == null) {
            throw new PluginContainerException("Could not load package type [" + packageTypeName + "] for resource: " + resourceId);
        }
        ScheduledContentDiscoveryInfo discoveryInfo = new ScheduledContentDiscoveryInfo(resourceId, packageType);
        ContentDiscoveryRunner oneTimeRunner = new ContentDiscoveryRunner(this, discoveryInfo);
        try {
            results = this.discoveryThreadPoolExecutor.submit(oneTimeRunner).get();
        }
        catch (Exception e) {
            throw new PluginContainerException("Exception occurred during execution of discovery", (Throwable)e);
        }
        return results;
    }

    public void deployPackages(DeployPackagesRequest request) {
        CreateContentRunner runner = new CreateContentRunner(this, request);
        this.crudExecutor.submit(runner);
    }

    public DeployPackagesResponse deployPackagesImmediately(DeployPackagesRequest request) throws PluginContainerException {
        CreateContentRunner runner = new CreateContentRunner(this, request);
        try {
            return this.crudExecutor.submit(runner).get();
        }
        catch (Exception e) {
            throw new PluginContainerException("Error during deployment of packages. request: " + request, (Throwable)e);
        }
    }

    public void deletePackages(DeletePackagesRequest request) {
        DeleteContentRunner runner = new DeleteContentRunner(this, request);
        this.crudExecutor.submit(runner);
    }

    public void retrievePackageBits(RetrievePackageBitsRequest request) {
        RetrieveContentBitsRunner runner = new RetrieveContentBitsRunner(this, request);
        this.crudExecutor.submit(runner);
    }

    public List<DeployPackageStep> translateInstallationSteps(int resourceId, ResourcePackageDetails packageDetails) throws PluginContainerException {
        List steps;
        try {
            ContentFacet contentFacet = this.findContentFacet(resourceId);
            steps = contentFacet.generateInstallationSteps(packageDetails);
        }
        catch (Exception e) {
            throw new PluginContainerException("Error translating the package installation steps", (Throwable)e);
        }
        return steps;
    }

    public long downloadPackageBitsForChildResource(ContentContext context, String childResourceTypeName, PackageDetailsKey key, OutputStream outputStream) {
        ContentContextImpl contextImpl = (ContentContextImpl)context;
        ContentServerService serverService = this.getContentServerService();
        outputStream = this.remoteOutputStream(outputStream);
        long count = serverService.downloadPackageBitsForChildResource(contextImpl.getResourceId(), childResourceTypeName, key, outputStream);
        return count;
    }

    public long downloadPackageBits(ContentContext context, PackageDetailsKey packageDetailsKey, OutputStream outputStream, boolean resourceExists) {
        ContentContextImpl contextImpl = (ContentContextImpl)context;
        ContentServerService serverService = this.getContentServerService();
        serverService.preLoadRemoteContent(contextImpl.getResourceId(), packageDetailsKey);
        outputStream = this.remoteOutputStream(outputStream);
        long count = 0L;
        if (resourceExists) {
            count = serverService.downloadPackageBitsGivenResource(contextImpl.getResourceId(), packageDetailsKey, outputStream);
        }
        return count;
    }

    public long downloadPackageBitsRange(ContentContext context, PackageDetailsKey packageDetailsKey, OutputStream outputStream, long startByte, long endByte, boolean resourceExists) {
        ContentContextImpl contextImpl = (ContentContextImpl)context;
        ContentServerService serverService = this.getContentServerService();
        outputStream = this.remoteOutputStream(outputStream);
        long count = 0L;
        if (resourceExists) {
            count = serverService.downloadPackageBitsRangeGivenResource(contextImpl.getResourceId(), packageDetailsKey, outputStream, startByte, endByte);
        }
        return count;
    }

    public long getPackageBitsLength(ContentContext context, PackageDetailsKey packageDetailsKey) {
        ContentContextImpl contextImpl = (ContentContextImpl)context;
        ContentServerService serverService = this.getContentServerService();
        long size = serverService.getPackageBitsLength(contextImpl.getResourceId(), packageDetailsKey);
        return size;
    }

    public PageList<PackageVersionMetadataComposite> getPackageVersionMetadata(ContentContext context, PageControl pc) {
        ContentContextImpl contextImpl = (ContentContextImpl)context;
        ContentServerService serverService = this.getContentServerService();
        PageList metadata = serverService.getPackageVersionMetadata(contextImpl.getResourceId(), pc);
        return metadata;
    }

    public String getResourceSubscriptionMD5(ContentContext context) {
        ContentContextImpl contextImpl = (ContentContextImpl)context;
        ContentServerService serverService = this.getContentServerService();
        String metadataMD5 = serverService.getResourceSubscriptionMD5(contextImpl.getResourceId());
        return metadataMD5;
    }

    synchronized ScheduledContentDiscoveryInfo getNextScheduledDiscovery() {
        ScheduledContentDiscoveryInfo next = this.scheduledDiscoveries.peek();
        if (next == null || next.getNextDiscovery() > System.currentTimeMillis()) {
            return null;
        }
        return this.scheduledDiscoveries.poll();
    }

    synchronized void rescheduleDiscovery(ScheduledContentDiscoveryInfo discoveryInfo) {
        if (!this.scheduledDiscoveriesEnabled) {
            this.log.warn((Object)"An attempt was made to reschedule a content discovery while not running in scheduled discovery mode - returning...");
            return;
        }
        ResourceContainer resourceContainer = PluginContainer.getInstance().getInventoryManager().getResourceContainer(discoveryInfo.getResourceId());
        if (resourceContainer != null) {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (discoveryInfo.getInterval() > 0L) {
                if (debugEnabled) {
                    this.log.debug((Object)("Rescheduling [" + discoveryInfo + "]..."));
                }
                discoveryInfo.setNextDiscovery(System.currentTimeMillis() + discoveryInfo.getInterval());
                this.addToQueue(discoveryInfo);
                if (debugEnabled) {
                    this.log.debug((Object)("Finished rescheduling: " + discoveryInfo));
                }
            } else if (debugEnabled) {
                this.log.debug((Object)("Will not reschedule content discovery: " + discoveryInfo));
            }
        }
    }

    synchronized void unscheduleDiscoveries(Resource resource) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Unscheduling content discoveries for resource id [" + resource + ']'));
        }
        HashSet<ScheduledContentDiscoveryInfo> unscheduleUs = new HashSet<ScheduledContentDiscoveryInfo>();
        for (ScheduledContentDiscoveryInfo scheduledItem : this.scheduledDiscoveries) {
            if (scheduledItem.getResourceId() != resource.getId()) continue;
            unscheduleUs.add(scheduledItem);
        }
        for (ScheduledContentDiscoveryInfo removeMe : unscheduleUs) {
            this.scheduledDiscoveries.remove(removeMe);
        }
    }

    ContentDiscoveryReport performContentDiscovery(int resourceId, PackageType type) throws Exception {
        ContentFacet contentFacet = ComponentUtil.getComponent(resourceId, ContentFacet.class, FacetLockType.READ, 3600000L, false, true);
        Set details = contentFacet.discoverDeployedPackages(type);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Discovered [" + (details != null ? details.size() : 0) + "] packages of type=" + type));
        }
        ContentDiscoveryReport report = this.handleDiscoveredContent(details, resourceId);
        return report;
    }

    DeployPackagesResponse performPackageDeployment(int resourceId, Set<ResourcePackageDetails> packagesToDeploy) throws Exception {
        ContentFacet contentFacet = this.findContentFacet(resourceId);
        DeployPackagesResponse response = contentFacet.deployPackages(packagesToDeploy, (ContentServices)this);
        return response;
    }

    RemovePackagesResponse performPackageDelete(int resourceId, Set<ResourcePackageDetails> packagesToDelete) throws Exception {
        ContentFacet contentFacet = this.findContentFacet(resourceId);
        RemovePackagesResponse response = contentFacet.removePackages(packagesToDelete);
        return response;
    }

    InputStream performGetPackageBits(int resourceId, ResourcePackageDetails packageToRetrieve) throws Exception {
        ContentFacet contentFacet = this.findContentFacet(resourceId);
        InputStream contentStream = contentFacet.retrievePackageBits(packageToRetrieve);
        contentStream = this.remoteInputStream(contentStream);
        return contentStream;
    }

    ContentServerService getContentServerService() {
        ContentServerService serverService = null;
        ServerServices serverServices = this.configuration.getServerServices();
        if (serverServices != null) {
            serverService = serverServices.getContentServerService();
        }
        return serverService;
    }

    private synchronized void scheduleDiscoveries(Resource resource) {
        if (!this.scheduledDiscoveriesEnabled) {
            this.log.warn((Object)"Attempting to schedule a discovery for a resource while not running in scheduled discovery mode");
            return;
        }
        ResourceType resourceType = resource.getResourceType();
        Set packageTypes = resourceType.getPackageTypes();
        if (packageTypes != null && packageTypes.size() > 0) {
            int resourceId = resource.getId();
            Iterator iterator = this.scheduledDiscoveries.iterator();
            while (iterator.hasNext()) {
                ScheduledContentDiscoveryInfo contentDiscoveryInfo = (ScheduledContentDiscoveryInfo)iterator.next();
                if (contentDiscoveryInfo.getResourceId() != resourceId) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Already found scheduled content discovery for resource id [" + resourceId + "], package type=[" + contentDiscoveryInfo.getPackageType() + "]. Will reschedule to be triggered soon."));
                }
                iterator.remove();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Scheduling [" + packageTypes.size() + "] content discoveries for resource id [" + resourceId + "]"));
            }
            for (PackageType type : packageTypes) {
                ScheduledContentDiscoveryInfo contentDiscovery = new ScheduledContentDiscoveryInfo(resourceId, type);
                contentDiscovery.setNextDiscovery(System.currentTimeMillis());
                this.addToQueue(contentDiscovery);
            }
        }
    }

    private synchronized void addToQueue(ScheduledContentDiscoveryInfo item) {
        if (this.scheduledDiscoveriesEnabled) {
            this.scheduledDiscoveries.offer(item);
        } else {
            this.log.warn((Object)("Attempting to add a scheduled item to the queue when not running in scheduled mode: " + item));
        }
    }

    private ContentDiscoveryReport handleDiscoveredContent(Set<ResourcePackageDetails> details, int resourceId) throws Exception {
        if (details == null) {
            return null;
        }
        InventoryManager inventoryManager = PluginContainer.getInstance().getInventoryManager();
        ResourceContainer container = inventoryManager.getResourceContainer(resourceId);
        HashSet<ResourcePackageDetails> updatedPackageSet = new HashSet<ResourcePackageDetails>(details);
        Set<ResourcePackageDetails> existingInstalledPackagesSet = container.getInstalledPackages();
        if (existingInstalledPackagesSet == null) {
            existingInstalledPackagesSet = new HashSet<ResourcePackageDetails>();
        }
        int originalPackageCount = existingInstalledPackagesSet.size();
        existingInstalledPackagesSet.retainAll(updatedPackageSet);
        int removedPackagesCount = originalPackageCount - existingInstalledPackagesSet.size();
        if (removedPackagesCount > 0 && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removed [" + removedPackagesCount + "] obsolete packages for resource id [" + resourceId + "]"));
        }
        updatedPackageSet.removeAll(existingInstalledPackagesSet);
        if (!updatedPackageSet.isEmpty() && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Found [" + updatedPackageSet.size() + "] new packages for resource id [" + resourceId + "]"));
        }
        existingInstalledPackagesSet.addAll(updatedPackageSet);
        container.setInstalledPackages(existingInstalledPackagesSet);
        ContentDiscoveryReport report = new ContentDiscoveryReport();
        report.addAllDeployedPackages(existingInstalledPackagesSet);
        report.setResourceId(resourceId);
        ContentServerService contentServerService = this.getContentServerService();
        if (!(contentServerService == null || existingInstalledPackagesSet.isEmpty() && originalPackageCount == 0)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Merging [" + existingInstalledPackagesSet.size() + "] discovered packages for resource id [" + resourceId + "] with Server"));
            }
            contentServerService.mergeDiscoveredPackages(report);
        }
        return report;
    }

    private ContentFacet findContentFacet(int resourceId) throws Exception {
        return ComponentUtil.getComponent(resourceId, ContentFacet.class, FacetLockType.WRITE, 3600000L, false, true);
    }

    private PackageType findPackageType(int resourceId, String packageTypeName) throws PluginContainerException {
        ResourceType resourceType = ComponentUtil.getResourceType(resourceId);
        for (PackageType type : resourceType.getPackageTypes()) {
            if (!type.getName().equals(packageTypeName)) continue;
            return type;
        }
        return null;
    }

    private class ContentInventoryEventListener
    implements InventoryEventListener {
        private ContentInventoryEventListener() {
        }

        @Override
        public void resourceActivated(Resource resource) {
            ContentManager.this.scheduleDiscoveries(resource);
        }

        @Override
        public void resourceDeactivated(Resource resource) {
            ContentManager.this.unscheduleDiscoveries(resource);
        }

        @Override
        public void resourcesAdded(Set<Resource> resources) {
        }

        @Override
        public void resourcesRemoved(Set<Resource> resources) {
            for (Resource removeMe : resources) {
                ContentManager.this.unscheduleDiscoveries(removeMe);
            }
        }
    }
}

