/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeRequest;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeResponse;
import org.rhq.core.clientapi.server.discovery.DiscoveryServerService;
import org.rhq.core.clientapi.server.discovery.InvalidInventoryReportException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceMeasurementScheduleRequest;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceCreationDataType;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.ResourceUpgradeReport;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.agent.AgentRegistrar;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.availability.AvailabilityCollectorThreadPool;
import org.rhq.core.pc.content.ContentContextImpl;
import org.rhq.core.pc.content.ContentManager;
import org.rhq.core.pc.event.EventContextImpl;
import org.rhq.core.pc.inventory.AutoDiscoveryExecutor;
import org.rhq.core.pc.inventory.AvailabilityExecutor;
import org.rhq.core.pc.inventory.InventoryEventListener;
import org.rhq.core.pc.inventory.InventoryFile;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.inventory.RuntimeDiscoveryExecutor;
import org.rhq.core.pc.inventory.TimeoutException;
import org.rhq.core.pc.operation.OperationContextImpl;
import org.rhq.core.pc.operation.OperationManager;
import org.rhq.core.pc.operation.OperationServicesAdapter;
import org.rhq.core.pc.plugin.BlacklistedException;
import org.rhq.core.pc.plugin.CanonicalResourceKey;
import org.rhq.core.pc.plugin.PluginComponentFactory;
import org.rhq.core.pc.plugin.PluginManager;
import org.rhq.core.pc.upgrade.DiscoverySuspendedException;
import org.rhq.core.pc.upgrade.ResourceUpgradeDelegate;
import org.rhq.core.pc.util.DiscoveryComponentProxyFactory;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.availability.AvailabilityFacet;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.inventory.ClassLoaderFacet;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.operation.OperationContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeContext;
import org.rhq.core.pluginapi.upgrade.ResourceUpgradeFacet;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.core.util.exception.WrappedRemotingException;

public class InventoryManager
extends AgentService
implements ContainerService,
DiscoveryAgentService {
    private static final String INVENTORY_THREAD_POOL_NAME = "InventoryManager.discovery";
    private static final String AVAIL_THREAD_POOL_NAME = "InventoryManager.availability";
    private static final int AVAIL_THREAD_POOL_CORE_POOL_SIZE = 1;
    private static final int COMPONENT_START_TIMEOUT = 60000;
    private static final int COMPONENT_STOP_TIMEOUT = 5000;
    private final Log log = LogFactory.getLog(InventoryManager.class);
    private PluginContainerConfiguration configuration;
    private ScheduledThreadPoolExecutor inventoryThreadPoolExecutor;
    private ScheduledThreadPoolExecutor availabilityThreadPoolExecutor;
    private AutoDiscoveryExecutor serverScanExecutor;
    private RuntimeDiscoveryExecutor serviceScanExecutor;
    private AvailabilityExecutor availabilityExecutor;
    private Agent agent;
    private Resource platform;
    private boolean newPlatformWasDeletedRecently = false;
    private ReentrantReadWriteLock inventoryLock = new ReentrantReadWriteLock(true);
    private AtomicInteger temporaryKeyIndex = new AtomicInteger(-1);
    private Map<String, ResourceContainer> resourceContainers = Collections.synchronizedMap(new HashMap(1000));
    private Set<InventoryEventListener> inventoryEventListeners = new HashSet<InventoryEventListener>();
    private PluginManager pluginManager = PluginContainer.getInstance().getPluginManager();
    private DiscoveryComponentProxyFactory discoveryComponentProxyFactory;
    private AvailabilityCollectorThreadPool availabilityCollectors;
    private ResourceUpgradeDelegate resourceUpgradeDelegate = new ResourceUpgradeDelegate(this);

    public InventoryManager() {
        super(DiscoveryAgentService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        this.inventoryLock.writeLock().lock();
        try {
            this.log.info((Object)"Initializing Inventory Manager...");
            this.discoveryComponentProxyFactory = new DiscoveryComponentProxyFactory();
            this.discoveryComponentProxyFactory.initialize();
            this.agent = new Agent(this.configuration.getContainerName(), null, 0, null, null);
            if (this.configuration.isInsideAgent()) {
                this.loadFromDisk();
            }
            this.executePlatformScan();
            this.upgradeResources();
            this.availabilityCollectors = new AvailabilityCollectorThreadPool();
            this.availabilityCollectors.initialize();
            this.availabilityThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new LoggingThreadFactory(AVAIL_THREAD_POOL_NAME, true));
            this.availabilityExecutor = new AvailabilityExecutor(this);
            this.inventoryThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, new LoggingThreadFactory(INVENTORY_THREAD_POOL_NAME, true));
            this.serverScanExecutor = new AutoDiscoveryExecutor(null, this, this.configuration);
            this.serviceScanExecutor = new RuntimeDiscoveryExecutor(this, this.configuration);
            if (this.configuration.isInsideAgent()) {
                this.availabilityThreadPoolExecutor.scheduleWithFixedDelay(this.availabilityExecutor, this.configuration.getAvailabilityScanInitialDelay(), this.configuration.getAvailabilityScanPeriod(), TimeUnit.SECONDS);
                this.inventoryThreadPoolExecutor.scheduleWithFixedDelay(this.serverScanExecutor, this.configuration.getServerDiscoveryInitialDelay(), this.configuration.getServerDiscoveryPeriod(), TimeUnit.SECONDS);
                this.inventoryThreadPoolExecutor.scheduleWithFixedDelay(this.serviceScanExecutor, this.configuration.getServiceDiscoveryInitialDelay(), this.configuration.getServiceDiscoveryPeriod(), TimeUnit.SECONDS);
            }
        }
        finally {
            this.inventoryLock.writeLock().unlock();
        }
        this.log.info((Object)"Inventory Manager initialized.");
    }

    @Override
    public void shutdown() {
        this.inventoryThreadPoolExecutor.shutdownNow();
        this.availabilityThreadPoolExecutor.shutdownNow();
        if (this.configuration.isInsideAgent()) {
            this.persistToDisk();
        }
        this.discoveryComponentProxyFactory.shutdown();
        this.availabilityCollectors.shutdown();
        this.inventoryEventListeners.clear();
        this.resourceContainers.clear();
    }

    public Set<DiscoveredResourceDetails> invokeDiscoveryComponent(ResourceContainer parentResourceContainer, ResourceDiscoveryComponent component, ResourceDiscoveryContext context) throws DiscoverySuspendedException, Exception {
        Resource parentResource;
        Resource resource = parentResource = parentResourceContainer == null ? null : parentResourceContainer.getResource();
        if (this.resourceUpgradeDelegate.hasUpgradeFailedInChildren(parentResource, context.getResourceType())) {
            String message = "Discovery of [" + context.getResourceType() + "] has been suspended under " + (parentResource == null ? " the platform " : parentResource) + " because some of its siblings failed to upgrade.";
            this.log.debug((Object)message);
            throw new DiscoverySuspendedException(message);
        }
        long timeout = this.getDiscoveryComponentTimeout(context.getResourceType());
        try {
            ResourceDiscoveryComponent proxy = this.discoveryComponentProxyFactory.getDiscoveryComponentProxy(context.getResourceType(), component, timeout);
            Set results = proxy.discoverResources(context);
            return results;
        }
        catch (TimeoutException te) {
            this.log.warn((Object)("Discovery for Resources of [" + context.getResourceType() + "] has been running for more than " + timeout + " milliseconds. This may be a plugin bug."), (Throwable)te);
            return null;
        }
        catch (BlacklistedException be) {
            this.log.debug((Object)ThrowableUtil.getAllMessages((Throwable)be));
            return null;
        }
    }

    private DiscoveredResourceDetails discoverResource(ResourceDiscoveryComponent component, Configuration pluginConfig, ResourceDiscoveryContext context) throws Exception {
        long timeout = this.getDiscoveryComponentTimeout(context.getResourceType());
        try {
            ManualAddFacet proxy = this.discoveryComponentProxyFactory.getDiscoveryComponentProxy(context.getResourceType(), component, timeout, ManualAddFacet.class);
            DiscoveredResourceDetails result = proxy.discoverResource(pluginConfig, context);
            return result;
        }
        catch (TimeoutException te) {
            this.log.warn((Object)("Manual add of Resource of type [" + context.getResourceType() + "] with plugin configuration [" + pluginConfig.toString(true) + "] has been running for more than " + timeout + " milliseconds. This may be a plugin bug."), (Throwable)te);
            return null;
        }
        catch (BlacklistedException be) {
            this.log.debug((Object)ThrowableUtil.getAllMessages((Throwable)be));
            return null;
        }
    }

    public List<URL> invokeDiscoveryComponentClassLoaderFacet(Resource resource, ResourceDiscoveryComponent component, ResourceContainer parentContainer) throws Throwable {
        ResourceComponent parentComponent = parentContainer.getResourceComponent();
        ResourceContext parentResourceContext = parentContainer.getResourceContext();
        ResourceType resourceType = resource.getResourceType();
        long timeout = this.getDiscoveryComponentTimeout(resourceType);
        ClassLoaderFacet proxy = this.discoveryComponentProxyFactory.getDiscoveryComponentProxy(resourceType, component, timeout, ClassLoaderFacet.class);
        ResourceDiscoveryContext discoveryContext = new ResourceDiscoveryContext(resourceType, parentComponent, parentResourceContext, SystemInfoFactory.createSystemInfo(), null, null, this.configuration.getContainerName(), this.configuration.getPluginContainerDeployment());
        Configuration pluginConfigClone = resource.getPluginConfiguration().deepCopy(false);
        DiscoveredResourceDetails details = new DiscoveredResourceDetails(resourceType, resource.getResourceKey(), resource.getName(), resource.getVersion(), resource.getDescription(), pluginConfigClone, null);
        List results = proxy.getAdditionalClasspathUrls(discoveryContext, details);
        return results;
    }

    public <T extends ResourceComponent> ResourceUpgradeReport invokeDiscoveryComponentResourceUpgradeFacet(ResourceType resourceType, ResourceDiscoveryComponent<T> component, ResourceUpgradeContext<T> inventoriedResource) throws Throwable {
        long timeout = this.getDiscoveryComponentTimeout(resourceType);
        try {
            ResourceUpgradeFacet proxy = this.discoveryComponentProxyFactory.getDiscoveryComponentProxy(resourceType, component, timeout, ResourceUpgradeFacet.class);
            return proxy.upgrade(inventoriedResource);
        }
        catch (BlacklistedException e) {
            this.log.debug((Object)e);
            return null;
        }
    }

    public DiscoveryComponentProxyFactory getDiscoveryComponentProxyFactory() {
        return this.discoveryComponentProxyFactory;
    }

    private long getDiscoveryComponentTimeout(ResourceType type) {
        long timeout = Long.parseLong(System.getProperty("rhq.test.discovery-timeout", "300000"));
        return timeout;
    }

    @Nullable
    public ResourceContainer getResourceContainer(String uuid) {
        return this.resourceContainers.get(uuid);
    }

    @Nullable
    public ResourceContainer getResourceContainer(CanonicalResourceKey canonicalId) {
        ResourceContainer resourceContainer = null;
        HashMap<String, ResourceContainer> copy = new HashMap<String, ResourceContainer>(this.resourceContainers);
        for (Map.Entry entry : copy.entrySet()) {
            Resource parent;
            ResourceContainer container = (ResourceContainer)entry.getValue();
            Resource resource = container.getResource();
            if (resource == null || (parent = resource.getParentResource()) == null) continue;
            try {
                CanonicalResourceKey currentCanonicalId = new CanonicalResourceKey(resource, parent);
                if (!currentCanonicalId.equals(canonicalId)) continue;
                resourceContainer = container;
                break;
            }
            catch (PluginContainerException ignore) {
            }
        }
        copy.clear();
        return resourceContainer;
    }

    @Nullable
    public ResourceContainer getResourceContainer(Resource resource) {
        return this.resourceContainers.get(resource.getUuid());
    }

    @Nullable
    public ResourceContainer getResourceContainer(Integer resourceId) {
        if (resourceId == null || resourceId == 0) {
            this.log.warn((Object)("Cannot get a resource container for an invalid resource ID=" + resourceId));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Stack trace follows:", new Throwable("This is where resource ID=[" + resourceId + "] was passed in"));
            }
            return null;
        }
        ArrayList<ResourceContainer> containers = new ArrayList<ResourceContainer>(this.resourceContainers.values());
        ResourceContainer retContainer = null;
        for (ResourceContainer container : containers) {
            if (!resourceId.equals(container.getResource().getId())) continue;
            retContainer = container;
            break;
        }
        containers.clear();
        return retContainer;
    }

    void executePlatformScan() {
        this.log.debug((Object)"Executing platform scan...");
        Resource discoveredPlatform = this.discoverPlatform();
        try {
            this.mergeResourceFromDiscovery(discoveredPlatform, null);
        }
        catch (PluginContainerException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void updatePluginConfiguration(int resourceId, Configuration newPluginConfiguration) throws InvalidPluginConfigurationClientException, PluginContainerException {
        ResourceContainer container = this.getResourceContainer(resourceId);
        if (container == null) {
            throw new PluginContainerException("Cannot update plugin configuration for unknown Resource with id [" + resourceId + "]");
        }
        Resource resource = container.getResource();
        this.deactivateResource(resource);
        resource.setPluginConfiguration(newPluginConfiguration);
        try {
            this.activateResource(resource, container, true);
        }
        catch (InvalidPluginConfigurationException e) {
            String errorMessage = "Unable to connect to managed resource of type [" + resource.getResourceType().getName() + "] using the specified connection properties.";
            this.log.info((Object)errorMessage, (Throwable)e);
            errorMessage = errorMessage + (e.getLocalizedMessage() != null ? " " + e.getLocalizedMessage() : "");
            throw new InvalidPluginConfigurationClientException(errorMessage, (Throwable)(e.getCause() != null ? new WrappedRemotingException(e.getCause()) : null));
        }
    }

    public InventoryReport executeServerScanImmediately() {
        try {
            return this.inventoryThreadPoolExecutor.submit(this.serverScanExecutor).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Server scan execution was interrupted");
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public InventoryReport executeServiceScanImmediately() {
        try {
            return this.inventoryThreadPoolExecutor.submit(this.serviceScanExecutor).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Service scan execution was interrupted", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public void executeServiceScanDeferred() {
        this.inventoryThreadPoolExecutor.submit(this.serviceScanExecutor);
    }

    public AvailabilityReport executeAvailabilityScanImmediately(boolean changedOnlyReport) {
        try {
            AvailabilityExecutor availExec = new AvailabilityExecutor(this);
            if (changedOnlyReport) {
                availExec.sendChangedOnlyReportNextTime();
            } else {
                availExec.sendFullReportNextTime();
            }
            AvailabilityReport availabilityReport = this.availabilityThreadPoolExecutor.submit(availExec).get();
            this.availabilityExecutor.sendFullReportNextTime();
            return availabilityReport;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Availability scan execution was interrupted", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Availability getCurrentAvailability(Resource resource) {
        AvailabilityType availType = null;
        ResourceContainer resourceContainer = this.getResourceContainer(resource);
        if (resourceContainer != null) {
            if (resourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                Lock lock = resourceContainer.getReadFacetLock();
                if (lock.tryLock()) {
                    try {
                        ResourceCategory resourceCategory = resource.getResourceType().getCategory();
                        long componentTimeout = resourceCategory == ResourceCategory.SERVER ? 10000L : 5000L;
                        AvailabilityFacet resourceComponent = resourceContainer.createResourceComponentProxy(AvailabilityFacet.class, FacetLockType.NONE, componentTimeout, true, true);
                        availType = resourceComponent.getAvailability();
                    }
                    catch (PluginContainerException e) {
                        this.log.error((Object)("Failed to retrieve ResourceComponent for " + resource + "."), (Throwable)e);
                    }
                    catch (RuntimeException e) {
                        this.log.error((Object)("Call to getAvailablity() on ResourceComponent for " + resource + " failed."), (Throwable)e);
                        availType = AvailabilityType.DOWN;
                    }
                    finally {
                        lock.unlock();
                    }
                } else if (resourceContainer.getAvailability() != null) {
                    return resourceContainer.getAvailability();
                }
            }
        } else {
            this.log.error((Object)("No ResourceContainer exists for " + resource + "."));
        }
        return new Availability(resource, new Date(), availType);
    }

    public MergeResourceResponse manuallyAddResource(ResourceType resourceType, int parentResourceId, Configuration pluginConfiguration, int ownerSubjectId) throws InvalidPluginConfigurationClientException, PluginContainerException {
        MergeResourceResponse mergeResourceResponse;
        String resourceTypeString = resourceType.toString();
        resourceType = this.pluginManager.getMetadataManager().getType(resourceType);
        if (resourceType == null) {
            throw new IllegalStateException("Server specified unknown Resource type: " + resourceTypeString);
        }
        Resource resource = null;
        boolean resourceAlreadyExisted = false;
        Throwable startError = null;
        try {
            DiscoveredResourceDetails discoveredResourceDetails;
            ResourceContainer parentResourceContainer = this.getResourceContainer(parentResourceId);
            ResourceComponent parentResourceComponent = parentResourceContainer.getResourceComponent();
            PluginComponentFactory pluginComponentFactory = PluginContainer.getInstance().getPluginComponentFactory();
            ResourceDiscoveryComponent discoveryComponent = pluginComponentFactory.getDiscoveryComponent(resourceType, parentResourceContainer);
            if (discoveryComponent instanceof ManualAddFacet) {
                ResourceDiscoveryContext discoveryContext = new ResourceDiscoveryContext(resourceType, parentResourceComponent, parentResourceContainer.getResourceContext(), SystemInfoFactory.createSystemInfo(), new ArrayList(0), new ArrayList(0), this.configuration.getContainerName(), this.configuration.getPluginContainerDeployment());
                discoveredResourceDetails = this.discoverResource(discoveryComponent, pluginConfiguration, discoveryContext);
                if (discoveredResourceDetails == null) {
                    this.log.info((Object)("Plugin Error: During manual add, discovery component method [" + discoveryComponent.getClass().getName() + ".discoverResource()] returned null " + "(either the Resource type was blacklisted or the plugin developer " + "did not implement support for manually discovered Resources correctly)."));
                    throw new PluginContainerException("The [" + resourceType.getPlugin() + "] plugin does not properly support manual addition of [" + resourceType.getName() + "] Resources.");
                }
            } else {
                this.log.info((Object)("Plugin Warning: Resource type '" + resourceType.getName() + "' from '" + resourceType.getPlugin() + "' is still using the deprecated manual Resource add API, " + "rather than the new ManualAddFacet interface."));
                ArrayList<Configuration> pluginConfigurations = new ArrayList<Configuration>(1);
                pluginConfigurations.add(pluginConfiguration);
                ResourceDiscoveryContext discoveryContext = new ResourceDiscoveryContext(resourceType, parentResourceComponent, parentResourceContainer.getResourceContext(), SystemInfoFactory.createSystemInfo(), new ArrayList(0), pluginConfigurations, this.configuration.getContainerName(), this.configuration.getPluginContainerDeployment());
                try {
                    Set<DiscoveredResourceDetails> discoveredResources = this.invokeDiscoveryComponent(parentResourceContainer, discoveryComponent, discoveryContext);
                    if (discoveredResources == null || discoveredResources.isEmpty()) {
                        this.log.info((Object)("Plugin Error: During manual add, discovery component method [" + discoveryComponent.getClass().getName() + ".discoverResources()] returned " + discoveredResources + " when passed a single plugin configuration " + "(either the resource type was blacklisted or the plugin developer " + "did not implement support for manually discovered resources correctly)."));
                        throw new PluginContainerException("The [" + resourceType.getPlugin() + "] plugin does not properly support manual addition of [" + resourceType.getName() + "] resources.");
                    }
                    discoveredResourceDetails = discoveredResources.iterator().next();
                }
                catch (DiscoverySuspendedException e) {
                    String message = "The discovery class [" + discoveryComponent.getClass().getName() + "]" + " uses a legacy implementation of \"manual add\" functionality. Some of the child resources" + " with the resource type [" + resourceType + "] under the parent resource [" + parentResourceContainer.getResource() + "]" + " failed to upgrade, which makes it impossible to support the legacy manual-add implementation. Either upgrade the plugin [" + resourceType.getPlugin() + "] to successfully upgrade all resources or consider implementing the ManuallAdd facet.";
                    this.log.info((Object)message);
                    throw new PluginContainerException(message, (Throwable)e);
                }
            }
            resource = InventoryManager.createNewResource(discoveredResourceDetails);
            Resource parentResource = this.getResourceContainer(parentResourceId).getResource();
            Resource existingResource = this.findMatchingChildResource(resource, parentResource);
            if (existingResource != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Manual add for resource type [" + resourceType.getName() + "] and parent resource id [" + parentResourceId + "] found a resource that already exists in inventory - updating existing resource [" + existingResource + "]"));
                }
                resourceAlreadyExisted = true;
                resource = existingResource;
                if (resource.getInventoryStatus() != InventoryStatus.COMMITTED) {
                    resource.setPluginConfiguration(pluginConfiguration);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Adding manually discovered resource [" + resource + "] to inventory..."));
                }
                resource.setInventoryStatus(InventoryStatus.COMMITTED);
                parentResource.addChildResource(resource);
                this.initResourceContainer(resource);
            }
            boolean newPluginConfig = true;
            ResourceContainer resourceContainer = this.getResourceContainer(resource);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Activating resource [" + resource + "]..."));
            }
            try {
                this.activateResource(resource, resourceContainer, newPluginConfig);
            }
            catch (Throwable t) {
                startError = t;
            }
            DiscoveryServerService discoveryServerService = this.configuration.getServerServices().getDiscoveryServerService();
            mergeResourceResponse = discoveryServerService.addResource(resource, ownerSubjectId);
            resource.setId(mergeResourceResponse.getResourceId());
            resource.setMtime(0L);
            LinkedHashSet<Resource> newResources = new LinkedHashSet<Resource>();
            newResources.add(resource);
            this.postProcessNewlyCommittedResources(newResources);
            this.performServiceScan(resource.getId());
            if (null != startError) {
                throw new PluginContainerException("The resource [" + resource + "] has been added but could not be started. Verify the supplied configuration values: ", startError);
            }
        }
        catch (Throwable t) {
            if (resource != null && !resourceAlreadyExisted && this.getResourceContainer(resource) != null) {
                this.log.debug((Object)("Rolling back manual add of resource of type [" + resourceType.getName() + "] - removing resource with id [" + resource.getId() + "] from inventory..."));
                this.deactivateResource(resource);
                this.uninventoryResource(resource.getId());
            }
            if (t instanceof InvalidPluginConfigurationException) {
                String errorMessage = "Unable to connect to managed resource of type [" + resourceType.getName() + "] using the specified connection properties - resource will not be added to inventory.";
                this.log.info((Object)errorMessage, t);
                errorMessage = errorMessage + (t.getLocalizedMessage() != null ? " " + t.getLocalizedMessage() : "");
                throw new InvalidPluginConfigurationClientException(errorMessage, (Throwable)(t.getCause() != null ? new WrappedRemotingException(t.getCause()) : null));
            }
            this.log.error((Object)("Manual add failed for resource of type [" + resourceType.getName() + "] and parent resource id [" + parentResourceId + "]"), t);
            throw new PluginContainerException("Failed to add resource with type [" + resourceType.getName() + "] and parent resource id [" + parentResourceId + "]", (Throwable)new WrappedRemotingException(t));
        }
        return mergeResourceResponse;
    }

    static Resource createNewResource(DiscoveredResourceDetails details) {
        Resource resource = new Resource();
        resource.setUuid(UUID.randomUUID().toString());
        resource.setResourceKey(details.getResourceKey());
        resource.setName(details.getResourceName());
        resource.setVersion(details.getResourceVersion());
        resource.setDescription(details.getResourceDescription());
        resource.setResourceType(details.getResourceType());
        Configuration pluginConfiguration = details.getPluginConfiguration();
        ConfigurationUtility.normalizeConfiguration((Configuration)details.getPluginConfiguration(), (ConfigurationDefinition)details.getResourceType().getPluginConfigurationDefinition());
        resource.setPluginConfiguration(pluginConfiguration);
        return resource;
    }

    @Nullable
    public Availability getAvailabilityIfKnown(Resource resource) {
        ResourceContainer resourceContainer = this.getResourceContainer(resource);
        if (resourceContainer != null && ResourceContainer.ResourceComponentState.STARTED == resourceContainer.getResourceComponentState()) {
            Availability availability = resourceContainer.getAvailability();
            return availability;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReport(AvailabilityReport report) {
        if (report == null) {
            if (this.platform != null && this.platform.getInventoryStatus() == InventoryStatus.NEW && this.newPlatformWasDeletedRecently) {
                this.log.info((Object)"No committed resources to send in our availability report - the platform/agent was deleted, let's re-register again");
                this.registerWithServer();
                this.newPlatformWasDeletedRecently = false;
            }
            return;
        }
        List reportAvails = report.getResourceAvailability();
        if (this.configuration.isInsideAgent() && reportAvails.size() > 0) {
            this.inventoryLock.readLock().lock();
            try {
                AvailabilityReport.Datum[] avails;
                for (AvailabilityReport.Datum avail : avails = reportAvails.toArray(new AvailabilityReport.Datum[reportAvails.size()])) {
                    int resourceId = avail.getResourceId();
                    ResourceContainer container = this.getResourceContainer(resourceId);
                    if (container != null && container.getResource().getInventoryStatus() != InventoryStatus.DELETED) continue;
                    reportAvails.remove(avail);
                }
            }
            finally {
                this.inventoryLock.readLock().unlock();
            }
            if (reportAvails.size() > 0) {
                try {
                    boolean ok;
                    this.log.info((Object)"Sending availability report to Server...");
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Availability report content: " + report.toString(this.log.isTraceEnabled())));
                    }
                    if (!(ok = this.configuration.getServerServices().getDiscoveryServerService().mergeAvailabilityReport(report))) {
                        this.availabilityExecutor.sendFullReportNextTime();
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)"Could not transmit availability report to server", (Throwable)e);
                    this.availabilityExecutor.sendFullReportNextTime();
                }
            }
        }
    }

    public boolean handleReport(InventoryReport report) {
        ResourceSyncInfo syncInfo;
        if (!this.configuration.isInsideAgent()) {
            return true;
        }
        try {
            String reportType = report.isRuntimeReport() ? "runtime" : "server";
            this.log.info((Object)("Sending [" + reportType + "] inventory report to Server..."));
            long startTime = System.currentTimeMillis();
            DiscoveryServerService discoveryServerService = this.configuration.getServerServices().getDiscoveryServerService();
            syncInfo = discoveryServerService.mergeInventoryReport(report);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Server DONE merging inventory report [%d] ms.", System.currentTimeMillis() - startTime));
            }
        }
        catch (InvalidInventoryReportException e) {
            this.log.error((Object)"Failure sending inventory report to Server - was this Agent's platform deleted?", (Throwable)e);
            if (this.platform != null && this.platform.getInventoryStatus() == InventoryStatus.NEW && this.newPlatformWasDeletedRecently) {
                this.log.info((Object)"The inventory report was invalid probably because the platform/Agent was deleted; let's re-register...");
                this.registerWithServer();
                this.newPlatformWasDeletedRecently = false;
            }
            return false;
        }
        if (syncInfo != null) {
            this.synchInventory(syncInfo);
        } else {
            this.purgeObsoleteResources(Collections.<String>emptySet());
            this.discoverPlatform();
        }
        return true;
    }

    private void synchInventory(ResourceSyncInfo syncInfo) {
        this.log.info((Object)"Syncing local inventory with Server inventory...");
        long startTime = System.currentTimeMillis();
        LinkedHashSet<Resource> syncedResources = new LinkedHashSet<Resource>();
        LinkedHashSet<Integer> unknownResourceIds = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> modifiedResourceIds = new LinkedHashSet<Integer>();
        LinkedHashSet<Integer> deletedResourceIds = new LinkedHashSet<Integer>();
        LinkedHashSet<Resource> newlyCommittedResources = new LinkedHashSet<Resource>();
        HashSet<String> allServerSideUuids = new HashSet<String>();
        try {
            this.getAllUuids(syncInfo, allServerSideUuids);
            this.log.debug((Object)"Processing Server sync info...");
            this.processSyncInfo(syncInfo, syncedResources, unknownResourceIds, modifiedResourceIds, deletedResourceIds, newlyCommittedResources);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("DONE Processing sync info - took [%d] ms - synced [%d] Resources - found [%d] unknown Resources and [%d] modified Resources.", System.currentTimeMillis() - startTime, syncedResources.size(), unknownResourceIds.size(), modifiedResourceIds.size()));
            }
            this.mergeUnknownResources(unknownResourceIds);
            this.mergeModifiedResources(modifiedResourceIds);
            this.purgeObsoleteResources(allServerSideUuids);
            this.postProcessNewlyCommittedResources(newlyCommittedResources);
            if (this.log.isDebugEnabled()) {
                if (!deletedResourceIds.isEmpty()) {
                    this.log.debug((Object)("Ignored [" + deletedResourceIds.size() + "] DELETED resources."));
                }
                this.log.debug((Object)String.format("DONE syncing local inventory [%d] ms.", System.currentTimeMillis() - startTime));
            }
            if (!(this.resourceUpgradeDelegate.enabled() || syncedResources.isEmpty() && unknownResourceIds.isEmpty() && modifiedResourceIds.isEmpty())) {
                this.performAvailabilityChecks(true);
                this.inventoryThreadPoolExecutor.schedule(this.serviceScanExecutor, 5L, TimeUnit.SECONDS);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)("Failed to synchronize local inventory with Server inventory for Resource [" + syncInfo.getId() + "] and its descendants: " + t.getMessage()));
            throw new RuntimeException(t);
        }
    }

    private void getAllUuids(ResourceSyncInfo syncInfo, Set<String> allServerSideUuids) {
        allServerSideUuids.add(syncInfo.getUuid());
        for (ResourceSyncInfo child : syncInfo.getChildSyncInfos()) {
            this.getAllUuids(child, allServerSideUuids);
        }
    }

    private void registerWithServer() {
        AgentRegistrar registrar = PluginContainer.getInstance().getAgentRegistrar();
        if (registrar != null) {
            try {
                registrar.register(10000L);
                this.inventoryThreadPoolExecutor.submit(this.serverScanExecutor);
            }
            catch (Exception e) {
                this.log.error((Object)"Cannot re-register with the agent, something bad is happening", (Throwable)e);
            }
        }
    }

    public void performServiceScan(int resourceId) {
        ResourceContainer resourceContainer = this.getResourceContainer(resourceId);
        if (resourceContainer == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No resource container for resource with id [" + resourceId + "] found, not performing a serviceScan"));
            }
            return;
        }
        Resource resource = resourceContainer.getResource();
        RuntimeDiscoveryExecutor oneTimeExecutor = new RuntimeDiscoveryExecutor(this, this.configuration, resource);
        try {
            this.inventoryThreadPoolExecutor.submit(oneTimeExecutor).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Error submitting service scan", e);
        }
    }

    @Nullable
    public ResourceComponent<?> getResourceComponent(Resource resource) {
        ResourceContainer resourceContainer = this.resourceContainers.get(resource.getUuid());
        if (resourceContainer == null) {
            return null;
        }
        return resourceContainer.getResourceComponent();
    }

    public void uninventoryResource(int resourceId) {
        ResourceContainer resourceContainer = this.getResourceContainer(resourceId);
        if (resourceContainer == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Could not remove Resource [" + resourceId + "] because its container was null."));
            }
            return;
        }
        boolean scan = this.removeResourceAndIndicateIfScanIsNeeded(resourceContainer.getResource());
        if (!this.resourceUpgradeDelegate.enabled() && scan) {
            this.log.info((Object)("Deleted resource #[" + resourceId + "] - this will trigger a server scan now"));
            this.inventoryThreadPoolExecutor.submit(this.serverScanExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeResourceAndIndicateIfScanIsNeeded(Resource resource) {
        boolean scanIsNeeded = false;
        this.inventoryLock.writeLock().lock();
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Removing [" + resource + "] from local inventory..."));
            }
            this.deactivateResource(resource);
            HashSet children = new HashSet(resource.getChildResources());
            for (Resource child : children) {
                scanIsNeeded |= this.removeResourceAndIndicateIfScanIsNeeded(child);
            }
            Resource parent = resource.getParentResource();
            if (parent != null) {
                parent.removeChildResource(resource);
            }
            PluginContainer.getInstance().getMeasurementManager().unscheduleCollection(Collections.singleton(resource.getId()));
            if (this.resourceContainers.remove(resource.getUuid()) == null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Asked to remove an unknown Resource [" + resource + "] with UUID [" + resource.getUuid() + "]"));
            }
            this.fireResourcesRemoved(Collections.singleton(resource));
            if (this.platform == null || this.platform.getId() == resource.getId()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Platform [" + resource.getId() + "] was deleted - running platform scan now..."));
                }
                this.platform = null;
                this.executePlatformScan();
                this.newPlatformWasDeletedRecently = true;
                scanIsNeeded = true;
            } else {
                boolean isTopLevelServer;
                boolean bl = isTopLevelServer = this.platform.equals((Object)resource.getParentResource()) && resource.getResourceType().getCategory() != ResourceCategory.SERVICE;
                if (isTopLevelServer) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Top-level server [" + resource.getId() + "] was deleted - server discovery is needed."));
                    }
                    scanIsNeeded = true;
                }
            }
        }
        finally {
            this.inventoryLock.writeLock().unlock();
        }
        return scanIsNeeded;
    }

    public Resource getPlatform() {
        return this.platform;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public Availability updateAvailability(Resource resource, AvailabilityType availabilityType) {
        ResourceContainer resourceContainer = this.resourceContainers.get(resource.getUuid());
        return resourceContainer.updateAvailability(availabilityType);
    }

    public void mergeResourcesFromUpgrade(Set<ResourceUpgradeRequest> upgradeRequests) {
        Set serverUpdates = null;
        try {
            ServerServices serverServices = this.configuration.getServerServices();
            if (serverServices != null) {
                DiscoveryServerService discoveryServerService = serverServices.getDiscoveryServerService();
                serverUpdates = discoveryServerService.upgradeResources(upgradeRequests);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to process resource upgrades on the server.", (Throwable)e);
        }
        if (serverUpdates != null) {
            for (ResourceUpgradeResponse upgradeResponse : serverUpdates) {
                String resourceKey = upgradeResponse.getUpgradedResourceKey();
                String name = upgradeResponse.getUpgradedResourceName();
                String description = upgradeResponse.getUpgradedResourceDescription();
                if (resourceKey == null && name == null && description == null) continue;
                ResourceContainer existingResourceContainer = this.getResourceContainer(upgradeResponse.getResourceId());
                if (existingResourceContainer != null) {
                    Resource existingResource = existingResourceContainer.getResource();
                    StringBuilder logMessage = new StringBuilder("Resource [").append(existingResource.toString()).append("] upgraded its ");
                    if (resourceKey != null) {
                        existingResource.setResourceKey(resourceKey);
                        logMessage.append("resourceKey, ");
                    }
                    if (name != null) {
                        existingResource.setName(name);
                        logMessage.append("name, ");
                    }
                    if (description != null) {
                        existingResource.setDescription(description);
                        logMessage.append("description, ");
                    }
                    logMessage.replace(logMessage.length() - 1, logMessage.length(), "to become [").append(existingResource.toString()).append("]");
                    this.log.info((Object)logMessage.toString());
                    continue;
                }
                this.log.error((Object)("Upgraded a resource that is not present on the agent. This should not happen. The id of the missing resource is: " + upgradeResponse.getResourceId()));
            }
        }
    }

    public Resource mergeResourceFromDiscovery(Resource resource, Resource parent) throws PluginContainerException {
        Resource existingResource = this.findMatchingChildResource(resource, parent);
        if (existingResource != null) {
            this.updateResourceVersion(existingResource, resource.getVersion());
            return existingResource;
        }
        if (!this.configuration.isInsideAgent()) {
            resource.setId(this.temporaryKeyIndex.decrementAndGet());
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
        }
        String logMessage = String.format("Detected new %s [%s] - adding to local inventory...", resource.getResourceType().getCategory(), resource);
        if (parent != null) {
            switch (resource.getResourceType().getCategory()) {
                case SERVICE: {
                    this.log.debug((Object)logMessage);
                    break;
                }
                case SERVER: {
                    this.log.info((Object)logMessage);
                    break;
                }
                case PLATFORM: {
                    throw new IllegalStateException("An attempt was made to add a platform Resource as a child of another Resource.");
                }
            }
            parent.addChildResource(resource);
        } else {
            if (resource.getResourceType().getCategory() != ResourceCategory.PLATFORM) {
                throw new IllegalStateException("An attempt was made to add a non-platform Resource as the root Resource.");
            }
            this.log.info((Object)logMessage);
            this.platform = resource;
        }
        ResourceContainer resourceContainer = this.getResourceContainer(resource);
        if (resourceContainer != null) {
            this.log.warn((Object)("Resource container already existed for Resource that was supposed to be NEW: " + resource));
        } else {
            resourceContainer = this.initResourceContainer(resource);
        }
        if (!this.configuration.isInsideAgent()) {
            try {
                this.activateResource(resource, resourceContainer, true);
            }
            catch (InvalidPluginConfigurationException e) {
                this.log.error((Object)("Failed to activate " + resource + ": " + e.getLocalizedMessage()));
                this.handleInvalidPluginConfigurationResourceError(resource, e);
            }
        }
        this.fireResourcesAdded(Collections.singleton(resource));
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyForAllActivatedResources(InventoryEventListener listener) {
        ArrayList<Resource> activatedResources = new ArrayList<Resource>();
        this.inventoryLock.readLock().lock();
        try {
            for (ResourceContainer container : this.resourceContainers.values()) {
                if (container == null || container.getResourceComponentState() != ResourceContainer.ResourceComponentState.STARTED) continue;
                activatedResources.add(container.getResource());
            }
            for (Resource resource : activatedResources) {
                try {
                    listener.resourceActivated(resource);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Listener [" + listener + "] of activated resource [" + resource + "] failed"), t);
                }
            }
        }
        finally {
            this.inventoryLock.readLock().unlock();
            activatedResources.clear();
        }
    }

    private ResourceContainer initResourceContainer(Resource resource) {
        ResourceContainer resourceContainer = this.getResourceContainer(resource);
        if (resourceContainer == null) {
            ClassLoader classLoader;
            PluginComponentFactory factory = PluginContainer.getInstance().getPluginComponentFactory();
            try {
                classLoader = factory.getResourceClassloader(resource);
            }
            catch (PluginContainerException e) {
                this.log.error((Object)("Access to resource [" + resource + "] will fail due to missing classloader"), (Throwable)e);
                classLoader = null;
            }
            resourceContainer = new ResourceContainer(resource, classLoader);
            if (!this.configuration.isInsideAgent()) {
                resourceContainer.setSynchronizationState(ResourceContainer.SynchronizationState.SYNCHRONIZED);
            }
            this.resourceContainers.put(resource.getUuid(), resourceContainer);
        } else if (resourceContainer.getResourceClassLoader() == null) {
            ClassLoader classLoader;
            PluginComponentFactory factory = PluginContainer.getInstance().getPluginComponentFactory();
            try {
                classLoader = factory.getResourceClassloader(resource);
            }
            catch (PluginContainerException e) {
                this.log.error((Object)("Access to resource [" + resource + "] will fail due to missing classloader!"), (Throwable)e);
                classLoader = null;
            }
            resourceContainer.setResourceClassLoader(classLoader);
        }
        return resourceContainer;
    }

    public void activateResource(Resource resource, @NotNull ResourceContainer container, boolean updatedPluginConfig) throws InvalidPluginConfigurationException, PluginContainerException {
        boolean isParentStarted;
        ResourceContainer parentResourceContainer;
        if (this.resourceUpgradeDelegate.hasUpgradeFailed(resource)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Skipping activation of " + resource + " - it has failed to upgrade."));
            }
            return;
        }
        ResourceComponent component = container.getResourceComponent();
        if (component != null && container.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED && !updatedPluginConfig) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Skipping activation of " + resource + " - its component is already started and its plugin " + "config has not been updated since it was last started."));
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Starting component for [" + resource + "], current state=[" + (Object)((Object)container.getResourceComponentState()) + "], new plugin config=[" + updatedPluginConfig + "]..."));
        }
        if (component == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating component for [" + resource + "]..."));
            }
            try {
                component = PluginContainer.getInstance().getPluginComponentFactory().buildResourceComponent(resource);
            }
            catch (Throwable e) {
                throw new PluginContainerException("Could not build component for Resource [" + resource + "]", e);
            }
            container.setResourceComponent(component);
        }
        if (resource.getParentResource() == null) {
            parentResourceContainer = null;
            isParentStarted = true;
        } else {
            parentResourceContainer = this.getResourceContainer(resource.getParentResource());
            boolean bl = isParentStarted = parentResourceContainer.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED;
        }
        if (isParentStarted) {
            PluginComponentFactory factory = PluginContainer.getInstance().getPluginComponentFactory();
            ResourceType type = resource.getResourceType();
            ResourceDiscoveryComponent discoveryComponent = factory.getDiscoveryComponent(type, parentResourceContainer);
            try {
                discoveryComponent = this.discoveryComponentProxyFactory.getDiscoveryComponentProxy(type, discoveryComponent, this.getDiscoveryComponentTimeout(type));
            }
            catch (Exception e) {
                discoveryComponent = null;
                this.log.warn((Object)("Cannot give activated resource its discovery component. Cause: " + e));
            }
            ConfigurationUtility.normalizeConfiguration((Configuration)resource.getPluginConfiguration(), (ConfigurationDefinition)type.getPluginConfigurationDefinition());
            ResourceComponent<?> parentComponent = null;
            if (resource.getParentResource() != null) {
                parentComponent = this.getResourceComponent(resource.getParentResource());
            }
            ResourceContext<ResourceComponent<?>> context = this.createResourceContext(resource, parentComponent, discoveryComponent);
            container.setResourceContext(context);
            component = container.createResourceComponentProxy(ResourceComponent.class, FacetLockType.READ, 60000L, true, false);
            try {
                if (container.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Skipping activation of " + resource + " - its component is already started."));
                    }
                    return;
                }
                component.start(context);
                container.setResourceComponentState(ResourceContainer.ResourceComponentState.STARTED);
                resource.setConnected(true);
            }
            catch (Throwable t) {
                if (updatedPluginConfig || t instanceof InvalidPluginConfigurationException) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Resource has a bad config, waiting for this to go away: " + resource));
                    }
                    ResourceGotActivatedListener iel = new ResourceGotActivatedListener();
                    this.addInventoryEventListener(iel);
                    throw new InvalidPluginConfigurationException("Failed to start component for resource " + resource + ".", t);
                }
                throw new PluginContainerException("Failed to start component for resource " + resource + ".", t);
            }
            this.fireResourceActivated(resource);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Not activating [" + resource + "]; parent isn't started: " + parentResourceContainer));
        }
    }

    private <T extends ResourceComponent> ResourceContext<T> createResourceContext(Resource resource, T parentComponent, ResourceDiscoveryComponent<T> discoveryComponent) {
        File pluginDataDir = new File(this.configuration.getDataDirectory(), resource.getResourceType().getPlugin());
        return new ResourceContext(resource, parentComponent, discoveryComponent, SystemInfoFactory.createSystemInfo(), this.configuration.getTemporaryDirectory(), pluginDataDir, this.configuration.getContainerName(), this.getEventContext(resource), this.getOperationContext(resource), this.getContentContext(resource), (Executor)this.availabilityCollectors, this.configuration.getPluginContainerDeployment());
    }

    public <T extends ResourceComponent> ResourceUpgradeContext<T> createResourceUpgradeContext(Resource resource, ResourceContext<?> parentResourceContext, T parentComponent, ResourceDiscoveryComponent<T> discoveryComponent) {
        File pluginDataDir = new File(this.configuration.getDataDirectory(), resource.getResourceType().getPlugin());
        return new ResourceUpgradeContext(resource, parentResourceContext, parentComponent, discoveryComponent, SystemInfoFactory.createSystemInfo(), this.configuration.getTemporaryDirectory(), pluginDataDir, this.configuration.getContainerName(), this.getEventContext(resource), this.getOperationContext(resource), this.getContentContext(resource), (Executor)this.availabilityCollectors, this.configuration.getPluginContainerDeployment());
    }

    private boolean handleInvalidPluginConfigurationResourceError(Resource resource, Throwable t) {
        resource.setConnected(false);
        ResourceError resourceError = new ResourceError(resource, ResourceErrorType.INVALID_PLUGIN_CONFIGURATION, t.getLocalizedMessage(), ThrowableUtil.getStackAsString((Throwable)t), System.currentTimeMillis());
        return this.sendResourceErrorToServer(resourceError);
    }

    boolean sendResourceErrorToServer(ResourceError resourceError) {
        boolean errorSent = false;
        DiscoveryServerService serverService = null;
        ServerServices serverServices = this.configuration.getServerServices();
        if (serverServices != null) {
            serverService = serverServices.getDiscoveryServerService();
        }
        if (serverService != null) {
            try {
                resourceError.setResource(new Resource(resourceError.getResource().getId()));
                serverService.setResourceError(resourceError);
                errorSent = true;
            }
            catch (RuntimeException e) {
                this.log.warn((Object)("Cannot inform the Server about a Resource error [" + resourceError + "]. Cause: " + e));
            }
        }
        return errorSent;
    }

    private Resource findMatchingChildResource(Resource resource, Resource parent) {
        if (resource != null) {
            if (parent == null) {
                if (this.platform != null && this.matches(resource, this.platform)) {
                    return this.platform;
                }
            } else if (parent.getChildResources() != null) {
                for (Resource child : parent.getChildResources()) {
                    if (child == null || !this.matches(resource, child)) continue;
                    return child;
                }
            }
        }
        return null;
    }

    private boolean matches(Resource newResource, Resource existingResource) {
        try {
            return existingResource.getId() != 0 && existingResource.getId() == newResource.getId() || existingResource.getUuid().equals(newResource.getUuid()) || existingResource.getResourceType().equals((Object)newResource.getResourceType()) && existingResource.getResourceKey().equals(newResource.getResourceKey());
        }
        catch (RuntimeException e) {
            this.log.error((Object)("Runtime error while attempting to compare existing Resource " + existingResource + " to new Resource " + newResource));
            throw e;
        }
    }

    public Set<Resource> getResourcesWithType(ResourceType serverType) {
        return this.getResourcesWithType(serverType, this.platform.getChildResources());
    }

    private Set<Resource> getResourcesWithType(ResourceType serverType, Set<Resource> resources) {
        HashSet<Resource> servers = new HashSet<Resource>();
        if (resources == null) {
            return servers;
        }
        for (Resource server : resources) {
            servers.addAll(this.getResourcesWithType(serverType, server.getChildResources()));
            if (!serverType.equals((Object)server.getResourceType())) continue;
            servers.add(server);
        }
        return servers;
    }

    private void activateFromDisk(Resource resource) throws PluginContainerException {
        if (resource.getId() == 0) {
            return;
        }
        resource.setAgent(this.agent);
        ResourceContainer container = this.getResourceContainer(resource.getId());
        if (container == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Could not find a container for resource: " + resource));
            }
            return;
        }
        if (container.getSynchronizationState() != ResourceContainer.SynchronizationState.SYNCHRONIZED) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Stopped activating resources at unsynchronized resource [" + resource + "]"));
            }
            return;
        }
        try {
            this.activateResource(resource, container, false);
        }
        catch (Exception e) {
            this.log.debug((Object)("Failed to activate from disk [" + resource + "]"));
        }
        for (Resource child : resource.getChildResources()) {
            this.initResourceContainer(child);
            this.activateFromDisk(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromDisk() {
        this.inventoryLock.writeLock().lock();
        File file = null;
        try {
            file = new File(this.configuration.getDataDirectory(), "inventory.dat");
            if (file.exists()) {
                long start = System.currentTimeMillis();
                this.log.info((Object)("Loading inventory from data file [" + file + "]..."));
                InventoryFile inventoryFile = new InventoryFile(file);
                inventoryFile.loadInventory();
                this.platform = inventoryFile.getPlatform();
                this.resourceContainers.clear();
                for (String uuid : inventoryFile.getResourceContainers().keySet()) {
                    ResourceContainer resourceContainer = inventoryFile.getResourceContainers().get(uuid);
                    this.resourceContainers.put(uuid, resourceContainer);
                }
                this.initResourceContainer(this.platform);
                this.activateFromDisk(this.platform);
                this.log.info((Object)("Inventory with size [" + this.resourceContainers.size() + "] initialized from data file in [" + (System.currentTimeMillis() - start) + "ms]"));
            }
        }
        catch (Exception e) {
            this.platform = null;
            this.resourceContainers.clear();
            if (file != null) {
                file.renameTo(new File(file.getAbsolutePath() + ".invalid"));
            }
            this.log.error((Object)"Could not load inventory from data file. The agent has lost knowledge of its previous inventory - it will resync its inventory once it can reconnect with a server.", (Throwable)e);
        }
        finally {
            this.inventoryLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateResource(Resource resource) {
        block8: {
            this.inventoryLock.writeLock().lock();
            try {
                ResourceContainer container = this.getResourceContainer(resource);
                if (container == null || container.getResourceComponentState() != ResourceContainer.ResourceComponentState.STARTED) break block8;
                for (Resource child : resource.getChildResources()) {
                    this.deactivateResource(child);
                }
                try {
                    ResourceComponent component = container.createResourceComponentProxy(ResourceComponent.class, FacetLockType.WRITE, 5000L, true, true);
                    component.stop();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Successfully deactivated resource with id [" + resource.getId() + "]."));
                    }
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Plugin Error: Failed to stop component for [" + resource + "]."));
                }
                container.setResourceComponentState(ResourceContainer.ResourceComponentState.STOPPED);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Set component state to STOPPED for resource with id [" + resource.getId() + "]."));
                }
                this.fireResourceDeactivated(resource);
            }
            finally {
                this.inventoryLock.writeLock().unlock();
            }
        }
    }

    private void persistToDisk() {
        try {
            this.deactivateResource(this.platform);
            File file = new File(this.configuration.getDataDirectory(), "inventory.dat");
            InventoryFile inventoryFile = new InventoryFile(file);
            inventoryFile.storeInventory(this.platform, this.resourceContainers);
        }
        catch (Exception e) {
            this.log.error((Object)"Could not persist inventory data to disk", (Throwable)e);
        }
    }

    private Resource discoverPlatform() {
        PluginManager pluginManager = PluginContainer.getInstance().getPluginManager();
        PluginComponentFactory componentFactory = PluginContainer.getInstance().getPluginComponentFactory();
        SystemInfo systemInfo = SystemInfoFactory.createSystemInfo();
        Set platformTypes = pluginManager.getMetadataManager().getTypesForCategory(ResourceCategory.PLATFORM);
        HashSet<DiscoveredResourceDetails> allDiscoveredPlatforms = new HashSet<DiscoveredResourceDetails>(2);
        if (platformTypes != null && platformTypes.size() > 0) {
            if (platformTypes.size() == 1 && platformTypes.contains(PluginMetadataManager.TEST_PLATFORM_TYPE)) {
                return this.getTestPlatform();
            }
            for (ResourceType platformType : platformTypes) {
                try {
                    ResourceDiscoveryComponent component = componentFactory.getDiscoveryComponent(platformType, null);
                    ResourceDiscoveryContext context = new ResourceDiscoveryContext(platformType, null, null, systemInfo, Collections.EMPTY_LIST, Collections.EMPTY_LIST, this.configuration.getContainerName(), this.configuration.getPluginContainerDeployment());
                    Set<DiscoveredResourceDetails> discoveredResources = null;
                    try {
                        discoveredResources = this.invokeDiscoveryComponent(null, component, context);
                    }
                    catch (DiscoverySuspendedException e) {
                        this.log.error((Object)"Discovery seems to be suspended for platforms due to upgrade error.", (Throwable)e);
                    }
                    catch (Throwable e) {
                        this.log.warn((Object)"Platform plugin discovery failed - skipping", e);
                    }
                    if (discoveredResources == null) continue;
                    allDiscoveredPlatforms.addAll(discoveredResources);
                }
                catch (Throwable e) {
                    this.log.error((Object)"Error in platform discovery", e);
                }
            }
        } else {
            this.log.error((Object)"Missing platform plugin(s) - falling back to dummy platform impl; this should only occur in tests!");
            return this.getTestPlatform();
        }
        if (allDiscoveredPlatforms.isEmpty()) {
            throw new IllegalStateException("Neither a native nor a Java platform was discovered - this should never happen. Known platform types are " + platformTypes + ".");
        }
        if (allDiscoveredPlatforms.size() > 2) {
            this.log.warn((Object)("Platform discovery reported too many platforms - the platform discovery components for platform types " + platformTypes + " " + "should be fixed so together they report no more than 2 platforms total. " + "Reported platforms: " + allDiscoveredPlatforms + "."));
        }
        DiscoveredResourceDetails javaPlatform = null;
        DiscoveredResourceDetails nativePlatform = null;
        for (DiscoveredResourceDetails discoveredPlatform : allDiscoveredPlatforms) {
            if (discoveredPlatform.getResourceType().getName().equalsIgnoreCase("Java")) {
                javaPlatform = discoveredPlatform;
                continue;
            }
            nativePlatform = discoveredPlatform;
        }
        DiscoveredResourceDetails platformToUse = nativePlatform != null ? nativePlatform : javaPlatform;
        Resource platform = InventoryManager.createNewResource(platformToUse);
        platform.setAgent(this.agent);
        return platform;
    }

    private Resource getTestPlatform() {
        ResourceType type = PluginContainer.getInstance().getPluginManager().getMetadataManager().addTestPlatformType();
        if (this.platform != null && this.platform.getResourceType() == type) {
            return this.platform;
        }
        Resource platform = new Resource("testkey" + this.configuration.getContainerName(), "testplatform", type);
        platform.setUuid(UUID.randomUUID().toString());
        platform.setAgent(this.agent);
        return platform;
    }

    public void synchronizeInventory(ResourceSyncInfo syncInfo) {
        this.log.info((Object)("Synchronizing local inventory with Server inventory for Resource [" + syncInfo.getId() + "] and its descendants..."));
        this.synchInventory(syncInfo);
        this.performServiceScan(syncInfo.getId());
    }

    private void syncSchedulesRecursively(Resource resource) {
        if (resource.getInventoryStatus() == InventoryStatus.COMMITTED) {
            if (resource.getResourceType().getCategory() == ResourceCategory.PLATFORM) {
                Set scheduleRequests = this.configuration.getServerServices().getMeasurementServerService().getLatestSchedulesForResourceId(resource.getId(), false);
                this.installSchedules(scheduleRequests);
                HashSet<Integer> childrenIds = new HashSet<Integer>();
                for (Resource child : new HashSet(resource.getChildResources())) {
                    childrenIds.add(child.getId());
                }
                scheduleRequests = this.configuration.getServerServices().getMeasurementServerService().getLatestSchedulesForResourceIds(childrenIds, true);
                this.installSchedules(scheduleRequests);
            } else {
                Set scheduleRequests = this.configuration.getServerServices().getMeasurementServerService().getLatestSchedulesForResourceId(resource.getId(), true);
                this.installSchedules(scheduleRequests);
            }
        }
    }

    private void syncSchedules(Set<Resource> resources) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("syncSchedules(Set<Resource>) for resources: " + resources));
        }
        if (resources.isEmpty()) {
            return;
        }
        HashSet<Integer> committedResourceIds = new HashSet<Integer>();
        for (Resource resource : resources) {
            if (resource.getInventoryStatus() != InventoryStatus.COMMITTED) continue;
            committedResourceIds.add(resource.getId());
        }
        Set scheduleRequests = this.configuration.getServerServices().getMeasurementServerService().getLatestSchedulesForResourceIds(committedResourceIds, false);
        this.installSchedules(scheduleRequests);
    }

    private void postProcessNewlyCommittedResources(Set<Resource> resources) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Post-processing newly committed resources: " + resources));
        }
        if (resources.isEmpty()) {
            return;
        }
        HashSet<Integer> newlyCommittedResourceIds = new HashSet<Integer>();
        for (Resource resource : resources) {
            if (resource.getInventoryStatus() != InventoryStatus.COMMITTED) continue;
            newlyCommittedResourceIds.add(resource.getId());
        }
        Set schedules = this.configuration.getServerServices().getDiscoveryServerService().postProcessNewlyCommittedResources(newlyCommittedResourceIds);
        this.installSchedules(schedules);
    }

    private void installSchedules(Set<ResourceMeasurementScheduleRequest> scheduleRequests) {
        if (PluginContainer.getInstance().getMeasurementManager() != null) {
            PluginContainer.getInstance().getMeasurementManager().scheduleCollection(scheduleRequests);
        } else {
            this.log.info((Object)"MeasurementManager not available, persisting but not yet scheduling schedule requests.");
            for (ResourceMeasurementScheduleRequest resourceRequest : scheduleRequests) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("MeasurementManager unavailable, resource [" + resourceRequest.getResourceId() + "] will have its schedules persisted but not scheduled"));
                }
                ResourceContainer resourceContainer = this.getResourceContainer(resourceRequest.getResourceId());
                resourceContainer.setMeasurementSchedule(resourceRequest.getMeasurementSchedules());
            }
        }
    }

    private void performAvailabilityChecks(boolean sendFullReport) {
        if (sendFullReport) {
            this.availabilityExecutor.sendFullReportNextTime();
        }
        this.availabilityThreadPoolExecutor.schedule(this.availabilityExecutor, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInventoryEventListener(InventoryEventListener listener) {
        Set<InventoryEventListener> set = this.inventoryEventListeners;
        synchronized (set) {
            this.inventoryEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInventoryEventListener(InventoryEventListener listener) {
        Set<InventoryEventListener> set = this.inventoryEventListeners;
        synchronized (set) {
            this.inventoryEventListeners.remove(listener);
        }
    }

    public boolean hasUpgradeMergeFailed() {
        return this.resourceUpgradeDelegate.hasUpgradeMergeFailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<InventoryEventListener> getInventoryEventListeners() {
        Set<InventoryEventListener> set = this.inventoryEventListeners;
        synchronized (set) {
            return new HashSet<InventoryEventListener>(this.inventoryEventListeners);
        }
    }

    void fireResourcesAdded(Set<Resource> resources) {
        if (resources == null) {
            return;
        }
        Set<InventoryEventListener> iteratorSafeListeners = this.getInventoryEventListeners();
        for (InventoryEventListener listener : iteratorSafeListeners) {
            try {
                listener.resourcesAdded(resources);
            }
            catch (Throwable t) {
                this.log.error((Object)"Error while invoking resources added event on listener", t);
            }
        }
    }

    void fireResourceActivated(Resource resource) {
        if (resource == null || resource.getId() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Not firing activated event for resource: " + resource));
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Firing activated for resource: " + resource));
        }
        Set<InventoryEventListener> iteratorSafeListeners = this.getInventoryEventListeners();
        for (InventoryEventListener listener : iteratorSafeListeners) {
            try {
                listener.resourceActivated(resource);
            }
            catch (Throwable t) {
                this.log.error((Object)"Error while invoking resource activated event on listener", t);
            }
        }
    }

    private void fireResourceDeactivated(Resource resource) {
        if (resource == null || resource.getId() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Not firing deactivated event for resource: " + resource));
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Firing deactivated for resource: " + resource));
        }
        Set<InventoryEventListener> iteratorSafeListeners = this.getInventoryEventListeners();
        for (InventoryEventListener listener : iteratorSafeListeners) {
            try {
                listener.resourceDeactivated(resource);
            }
            catch (Throwable t) {
                this.log.error((Object)"Error while invoking resource deactivated event on listener", t);
            }
        }
    }

    void fireResourcesRemoved(Set<Resource> resources) {
        if (resources == null) {
            return;
        }
        Set<InventoryEventListener> iteratorSafeListeners = this.getInventoryEventListeners();
        for (InventoryEventListener listener : iteratorSafeListeners) {
            try {
                listener.resourcesRemoved(resources);
            }
            catch (Throwable t) {
                this.log.error((Object)"Error while invoking resources removed event on listener", t);
            }
        }
    }

    public void enableServiceScans(int serverResourceId, Configuration config) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void disableServiceScans(int serverResourceId) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @NotNull
    Set<Resource> executeComponentDiscovery(ResourceType resourceType, ResourceDiscoveryComponent discoveryComponent, ResourceContainer parentContainer, List<ProcessScanResult> processScanResults) {
        long elapsedTime;
        HashSet<Resource> newResources;
        ResourceContext parentResourceContext = parentContainer.getResourceContext();
        ResourceComponent parentComponent = parentContainer.getResourceComponent();
        Resource parentResource = parentContainer.getResource();
        long startTime = System.currentTimeMillis();
        this.log.debug((Object)("Executing discovery for [" + resourceType.getName() + "] Resources..."));
        try {
            ResourceDiscoveryContext context = new ResourceDiscoveryContext(resourceType, parentComponent, parentResourceContext, SystemInfoFactory.createSystemInfo(), processScanResults, Collections.EMPTY_LIST, this.configuration.getContainerName(), this.configuration.getPluginContainerDeployment());
            newResources = new HashSet<Resource>();
            try {
                Set<DiscoveredResourceDetails> discoveredResources = this.invokeDiscoveryComponent(parentContainer, discoveryComponent, context);
                if (discoveredResources != null && !discoveredResources.isEmpty()) {
                    IdentityHashMap<Configuration, DiscoveredResourceDetails> pluginConfigObjects = new IdentityHashMap<Configuration, DiscoveredResourceDetails>();
                    for (DiscoveredResourceDetails discoveredResource : discoveredResources) {
                        if (discoveredResource == null) {
                            throw new IllegalStateException("Plugin error: Discovery class " + discoveryComponent.getClass().getName() + " returned a Set containing one or more null items.");
                        }
                        if (!discoveredResource.getResourceType().equals((Object)resourceType)) {
                            throw new IllegalStateException("Plugin error: Discovery class " + discoveryComponent.getClass().getName() + " returned a DiscoveredResourceDetails with an incorrect ResourceType (was " + discoveredResource.getResourceType().getName() + " but should have been " + resourceType.getName());
                        }
                        if (null != pluginConfigObjects.put(discoveredResource.getPluginConfiguration(), discoveredResource)) {
                            throw new IllegalStateException("The plugin component " + discoveryComponent.getClass().getName() + " returned multiple resources that point to the same plugin configuration object on the " + "resource type [" + resourceType + "]. This is not allowed, please use " + "ResoureDiscoveryContext.getDefaultPluginConfiguration() " + "for each discovered resource.");
                        }
                        Resource newResource = InventoryManager.createNewResource(discoveredResource);
                        newResources.add(newResource);
                    }
                }
            }
            catch (DiscoverySuspendedException e) {
                for (Resource existingResource : parentResource.getChildResources()) {
                    if (!resourceType.equals((Object)existingResource.getResourceType())) continue;
                    newResources.add(existingResource);
                }
            }
        }
        catch (Throwable e) {
            long elapsedTime2 = System.currentTimeMillis() - startTime;
            this.log.warn((Object)("Failure during discovery for [" + resourceType.getName() + "] Resources - failed after " + elapsedTime2 + " ms."), e);
            return Collections.EMPTY_SET;
        }
        if ((elapsedTime = System.currentTimeMillis() - startTime) > 20000L) {
            this.log.info((Object)("Discovery for [" + resourceType.getName() + "] resources took [" + elapsedTime + "] ms"));
        } else {
            this.log.debug((Object)("Discovery for [" + resourceType.getName() + "] resources completed in [" + elapsedTime + "] ms"));
        }
        return newResources;
    }

    @Nullable
    private EventContext getEventContext(Resource resource) {
        EventContextImpl eventContext = resource.getResourceType().getEventDefinitions() != null && !resource.getResourceType().getEventDefinitions().isEmpty() ? new EventContextImpl(resource) : null;
        return eventContext;
    }

    private OperationContext getOperationContext(Resource resource) {
        if (resource.getResourceType().getOperationDefinitions() == null || resource.getResourceType().getOperationDefinitions().isEmpty()) {
            return null;
        }
        if (resource.getId() == 0) {
            this.log.warn((Object)"RESOURCE ID IS 0! Operation features may not work - resource needs to be synced with server");
        }
        OperationManager operationManager = PluginContainer.getInstance().getOperationManager();
        OperationServicesAdapter operationServices = new OperationServicesAdapter(operationManager);
        OperationContextImpl operationContext = new OperationContextImpl(resource.getId(), operationServices);
        return operationContext;
    }

    private ContentContext getContentContext(Resource resource) {
        ResourceType resourceType = resource.getResourceType();
        boolean hasPackageTypes = resourceType.getPackageTypes() != null && !resourceType.getPackageTypes().isEmpty();
        boolean hasContentBasedCreatableChildren = false;
        if (resourceType.getChildResourceTypes() != null) {
            for (ResourceType childResourceType : resourceType.getChildResourceTypes()) {
                if (!childResourceType.isCreatable() || childResourceType.getCreationDataType() != ResourceCreationDataType.CONTENT) continue;
                hasContentBasedCreatableChildren = true;
                break;
            }
        }
        if (!hasPackageTypes && !hasContentBasedCreatableChildren) {
            return null;
        }
        if (resource.getId() == 0) {
            this.log.warn((Object)"RESOURCE ID IS 0! Content features may not work - Resource needs to be synced with server");
        }
        ContentManager contentManager = PluginContainer.getInstance().getContentManager();
        ContentContextImpl contentContext = new ContentContextImpl(resource.getId(), contentManager);
        return contentContext;
    }

    private ResourceComponent<?> createTestPlatformComponent() {
        return new ResourceComponent(){

            public AvailabilityType getAvailability() {
                return AvailabilityType.UP;
            }

            public void start(ResourceContext context) {
            }

            public void stop() {
            }
        };
    }

    private void updateResourceVersion(Resource resource, String version) {
        boolean versionChanged;
        String existingVersion = resource.getVersion();
        boolean bl = existingVersion != null ? !existingVersion.equals(version) : (versionChanged = version != null);
        if (versionChanged) {
            boolean versionShouldBeUpdated;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Discovery reported that version of [" + resource + "] changed from [" + existingVersion + "] to [" + version + "]"));
            }
            boolean bl2 = versionShouldBeUpdated = resource.getInventoryStatus() != InventoryStatus.COMMITTED || this.updateResourceVersionOnServer(resource, version);
            if (versionShouldBeUpdated) {
                resource.setVersion(version);
                this.log.info((Object)("Version of [" + resource + "] changed from [" + existingVersion + "] to [" + version + "]"));
            }
        }
    }

    private boolean updateResourceVersionOnServer(Resource resource, String newVersion) {
        boolean versionUpdated = false;
        ServerServices serverServices = this.configuration.getServerServices();
        if (serverServices != null) {
            try {
                DiscoveryServerService discoveryServerService = serverServices.getDiscoveryServerService();
                discoveryServerService.updateResourceVersion(resource.getId(), newVersion);
                versionUpdated = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("New version for [" + resource + "] (" + newVersion + ") was successfully synced to the Server."));
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to sync-to-Server new version for [" + resource + "]"));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sync-to-Server of new version for [" + resource + "] cannot be done, because Plugin Container is not connected to Server."));
        }
        return versionUpdated;
    }

    private void processSyncInfo(ResourceSyncInfo syncInfo, Set<Resource> syncedResources, Set<Integer> unknownResourceIds, Set<Integer> modifiedResourceIds, Set<Integer> deletedResourceIds, Set<Resource> newlyCommittedResources) {
        if (InventoryStatus.DELETED == syncInfo.getInventoryStatus()) {
            deletedResourceIds.add(syncInfo.getId());
        } else {
            ResourceContainer container = this.resourceContainers.get(syncInfo.getUuid());
            if (container == null) {
                unknownResourceIds.add(syncInfo.getId());
                this.log.info((Object)("Got unknown resource: " + syncInfo.getId()));
            } else {
                Resource resource = container.getResource();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Local Resource: id=" + resource.getId() + ", status=" + resource.getInventoryStatus() + ", mtime=" + resource.getMtime()));
                    this.log.debug((Object)("Sync Resource: " + syncInfo.getId() + ", status=" + syncInfo.getInventoryStatus() + ", mtime=" + syncInfo.getMtime()));
                }
                if (resource.getInventoryStatus() != InventoryStatus.COMMITTED && syncInfo.getInventoryStatus() == InventoryStatus.COMMITTED) {
                    newlyCommittedResources.add(resource);
                }
                if (resource.getId() == 0) {
                    resource.setId(syncInfo.getId());
                    resource.setMtime(syncInfo.getMtime());
                    resource.setInventoryStatus(syncInfo.getInventoryStatus());
                    this.refreshResourceComponentState(container, true);
                    syncedResources.add(resource);
                } else if (resource.getId() != syncInfo.getId()) {
                    this.log.error((Object)("PC Resource id (" + resource.getId() + ") does not match Server Resource id (" + syncInfo.getId() + ") for Resource with uuid " + resource.getUuid() + ": " + resource));
                    modifiedResourceIds.add(syncInfo.getId());
                } else if (resource.getMtime() < syncInfo.getMtime()) {
                    modifiedResourceIds.add(resource.getId());
                } else {
                    this.refreshResourceComponentState(container, false);
                }
                for (ResourceSyncInfo childSyncInfo : syncInfo.getChildSyncInfos()) {
                    this.processSyncInfo(childSyncInfo, syncedResources, unknownResourceIds, modifiedResourceIds, deletedResourceIds, newlyCommittedResources);
                }
            }
        }
    }

    private void mergeModifiedResources(Set<Integer> modifiedResourceIds) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Merging [" + modifiedResourceIds.size() + "] modified Resources into local inventory..."));
        }
        Set modifiedResources = this.configuration.getServerServices().getDiscoveryServerService().getResources(modifiedResourceIds, false);
        this.syncSchedules(modifiedResources);
        for (Resource modifiedResource : modifiedResources) {
            this.mergeResource(modifiedResource);
        }
    }

    private void mergeUnknownResources(Set<Integer> unknownResourceIds) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Merging [" + unknownResourceIds.size() + "] unknown Resources and their descendants into local inventory..."));
        }
        if (!unknownResourceIds.isEmpty()) {
            PluginMetadataManager pmm = this.pluginManager.getMetadataManager();
            Set unknownResources = this.configuration.getServerServices().getDiscoveryServerService().getResources(unknownResourceIds, true);
            HashSet<Integer> toBeIgnored = new HashSet<Integer>();
            for (Resource unknownResource : unknownResources) {
                ResourceType resourceType = pmm.getType(unknownResource.getResourceType());
                if (resourceType != null) {
                    this.mergeResource(unknownResource);
                    this.syncSchedulesRecursively(unknownResource);
                    continue;
                }
                toBeIgnored.add(unknownResource.getId());
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("During an inventory sync, the server gave us resource [" + unknownResource + "] but its type is disabled in the agent; ignoring it"));
            }
            unknownResourceIds.removeAll(toBeIgnored);
        }
    }

    private void print(Resource resourceTreeNode, int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append("   ");
        }
        this.log.info((Object)(builder.toString() + resourceTreeNode.getId() + " " + resourceTreeNode.getUuid()));
        for (Resource child : resourceTreeNode.getChildResources()) {
            this.print(child, level + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeResource(Resource resource) {
        ResourceContainer resourceContainer;
        Resource parentResource;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Merging [" + resource + "] into local inventory..."));
        }
        Resource passedResource = resource;
        if (resource.getParentResource() != null) {
            ResourceContainer parentResourceContainer = this.getResourceContainer(resource.getParentResource());
            if (parentResourceContainer == null) {
                parentResourceContainer = this.getResourceContainer(resource.getParentResource().getId());
            }
            parentResource = parentResourceContainer != null ? parentResourceContainer.getResource() : null;
        } else {
            parentResource = null;
        }
        Resource existingResource = this.findMatchingChildResource(resource, parentResource);
        if (parentResource == null && existingResource == null) {
            this.log.error((Object)("Existing platform [" + this.platform + "] has different Resource type and/or Resource key than " + "platform in Server inventory: " + resource));
        }
        boolean pluginConfigUpdated = false;
        this.inventoryLock.writeLock().lock();
        try {
            if (existingResource != null) {
                resourceContainer = this.resourceContainers.remove(existingResource.getUuid());
                if (resourceContainer != null) {
                    this.resourceContainers.put(resource.getUuid(), resourceContainer);
                }
                if (parentResource != null) {
                    parentResource.removeChildResource(existingResource);
                }
                pluginConfigUpdated = this.mergeResource(resource, existingResource);
                resource = existingResource;
            }
            if (parentResource != null) {
                parentResource.addChildResource(resource);
            } else {
                this.platform = resource;
            }
            ResourceType fullResourceType = this.pluginManager.getMetadataManager().getType(resource.getResourceType());
            if (fullResourceType == null) {
                this.log.error((Object)("Unable to merge Resource " + resource + " - its type is unknown - perhaps the [" + resource.getResourceType().getPlugin() + "] plugin jar was manually removed from the Server's rhq-plugins dir?"));
                return;
            }
            resource.setResourceType(fullResourceType);
            resourceContainer = this.initResourceContainer(resource);
        }
        finally {
            this.inventoryLock.writeLock().unlock();
        }
        this.refreshResourceComponentState(resourceContainer, pluginConfigUpdated);
        HashSet childResources = new HashSet(passedResource.getChildResources());
        for (Resource childResource : childResources) {
            this.mergeResource(childResource);
        }
    }

    private boolean mergeResource(Resource sourceResource, Resource targetResource) {
        if (targetResource.getId() != 0 && targetResource.getId() != sourceResource.getId()) {
            this.log.warn((Object)("Id for " + targetResource + " changed from [" + targetResource.getId() + "] to [" + sourceResource.getId() + "]."));
        }
        targetResource.setId(sourceResource.getId());
        targetResource.setUuid(sourceResource.getUuid());
        if (!targetResource.getResourceKey().equals(sourceResource.getResourceKey())) {
            this.log.warn((Object)("Resource key for " + targetResource + " changed from [" + targetResource.getResourceKey() + "] to [" + sourceResource.getResourceKey() + "]."));
        }
        targetResource.setResourceKey(sourceResource.getResourceKey());
        targetResource.setResourceType(sourceResource.getResourceType());
        targetResource.setMtime(sourceResource.getMtime());
        targetResource.setInventoryStatus(sourceResource.getInventoryStatus());
        boolean pluginConfigUpdated = !targetResource.getPluginConfiguration().equals((Object)sourceResource.getPluginConfiguration());
        targetResource.setPluginConfiguration(sourceResource.getPluginConfiguration());
        targetResource.setName(sourceResource.getName());
        targetResource.setDescription(sourceResource.getDescription());
        targetResource.setLocation(sourceResource.getLocation());
        return pluginConfigUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeObsoleteResources(Set<String> allUuids) {
        this.log.debug((Object)"Purging obsolete Resources...");
        if (this.resourceContainers == null) {
            this.log.debug((Object)"No containers present, immediately returning ..");
            return;
        }
        this.inventoryLock.writeLock().lock();
        try {
            int removedResources = 0;
            HashMap<String, ResourceContainer> mapForIterating = new HashMap<String, ResourceContainer>(this.resourceContainers);
            for (String uuid : mapForIterating.keySet()) {
                if (allUuids.contains(uuid)) continue;
                ResourceContainer resourceContainer = this.resourceContainers.get(uuid);
                if (resourceContainer != null) {
                    Resource resource = resourceContainer.getResource();
                    if (resource.getId() == 0) continue;
                    this.uninventoryResource(resource.getId());
                    ++removedResources;
                    continue;
                }
                this.log.debug((Object)("No container found for uuid: " + uuid));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Purged [" + removedResources + "] obsolete Resources."));
            }
        }
        finally {
            this.inventoryLock.writeLock().unlock();
        }
    }

    private void refreshResourceComponentState(ResourceContainer container, boolean pluginConfigUpdated) {
        Resource resource = container.getResource();
        switch (resource.getInventoryStatus()) {
            case COMMITTED: {
                try {
                    if (pluginConfigUpdated) {
                        this.deactivateResource(resource);
                    }
                    this.activateResource(resource, container, pluginConfigUpdated);
                    break;
                }
                catch (InvalidPluginConfigurationException ipce) {
                    this.handleInvalidPluginConfigurationResourceError(resource, ipce);
                    this.log.warn((Object)("Cannot start component for " + resource + " from synchronized merge due to invalid plugin config: " + ipce.getLocalizedMessage()));
                    break;
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to start component for " + resource + " from synchronized merge."), (Throwable)e);
                }
            }
        }
        container.setSynchronizationState(ResourceContainer.SynchronizationState.SYNCHRONIZED);
    }

    private void upgradeResources() {
        try {
            if (!this.configuration.isInsideAgent()) {
                this.log.debug((Object)"Skipping resource upgrade in embedded mode.");
                return;
            }
            this.log.debug((Object)"Executing resource upgrade.");
            boolean syncResult = this.handleReport(new InventoryReport(this.getAgent()));
            if (!syncResult) {
                this.log.warn((Object)"Resource upgrade failed to sync up the inventory with the server.");
                return;
            }
            this.upgradeResource(this.getPlatform());
            this.log.debug((Object)"Sending the upgrade requests to the server.");
            this.resourceUpgradeDelegate.sendRequests();
            this.resourceUpgradeDelegate.disable();
            this.log.debug((Object)"Resource upgrade finished.");
        }
        catch (Throwable t) {
            this.log.error((Object)"Resource upgrade failed with an exception.", t);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void upgradeResource(Resource resource) {
        ResourceContainer container = this.getResourceContainer(resource);
        if (container != null) {
            if (container.getResourceComponentState() == ResourceContainer.ResourceComponentState.STARTED) {
                try {
                    if (!this.resourceUpgradeDelegate.processAndQueue(container)) return;
                    for (Resource child : resource.getChildResources()) {
                        this.upgradeResource(child);
                    }
                    return;
                }
                catch (PluginContainerException e) {
                    this.log.error((Object)("Exception thrown while upgrading [" + resource + "]."), (Throwable)e);
                    return;
                }
            } else {
                String message = "The resource container for resource [" + resource + "] wasn't started while upgrading.";
                if (resource.getChildResources().isEmpty()) {
                    this.log.info((Object)(message + " If this is the first time the plugin container starts up and has completely empty inventory, you can ignore this message."));
                    return;
                } else {
                    this.log.error((Object)(message + " This can potentially cause the discovery to find resources logically equivalent to already " + "existing resources if the corresponding plugins support upgrade for that particular resource type."));
                }
            }
            return;
        } else {
            this.log.error((Object)("Resource container not initialized for resource [" + resource + "] during upgrade. This should not happen."));
        }
    }

    class ResourceGotActivatedListener
    implements InventoryEventListener {
        ResourceGotActivatedListener() {
        }

        @Override
        public void resourceActivated(Resource resource) {
            if (resource != null && resource.getId() > 0) {
                DiscoveryServerService serverService;
                if (InventoryManager.this.log.isDebugEnabled()) {
                    InventoryManager.this.log.debug((Object)("Resource got finally activated, cleaning out config errors: " + resource));
                }
                if ((serverService = InventoryManager.this.configuration.getServerServices().getDiscoveryServerService()) != null) {
                    serverService.clearResourceConfigError(resource.getId());
                }
            }
            InventoryManager.this.removeInventoryEventListener(this);
        }

        @Override
        public void resourceDeactivated(Resource resource) {
        }

        @Override
        public void resourcesAdded(Set<Resource> resources) {
        }

        @Override
        public void resourcesRemoved(Set<Resource> resources) {
        }
    }
}

