/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.event.log;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.event.EventContext;
import org.rhq.core.pluginapi.event.log.Log4JLogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogFileEventPoller;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.system.SystemInfoFactory;

public class LogFileEventResourceComponentHelper {
    public static final String LOG_ENTRY_EVENT_TYPE = "logEntry";
    public static final String LOG_EVENT_SOURCES_CONFIG_PROP = "logEventSources";
    public static final String LOG_EVENT_SOURCE_CONFIG_PROP = "logEventSource";
    private static final int POLLING_INTERVAL_IN_SECONDS = 60;
    private final Log log = LogFactory.getLog(this.getClass());
    private ResourceContext<?> resourceContext;
    private List<PropertyMap> startedEventSources = new ArrayList<PropertyMap>();

    public LogFileEventResourceComponentHelper(ResourceContext<?> resourceContext) {
        this.resourceContext = resourceContext;
    }

    public void startLogFileEventPollers() {
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        PropertyList logEventSources = pluginConfig.getList(LOG_EVENT_SOURCES_CONFIG_PROP);
        if (logEventSources == null) {
            throw new IllegalStateException("List property [logEventSources] not defined in plugin configuration for " + this.resourceContext.getResourceType().getName() + " Resource with key [" + this.resourceContext.getResourceKey() + "].");
        }
        ArrayList<PropertyMap> enabledEventSources = new ArrayList<PropertyMap>();
        for (Property prop : logEventSources.getList()) {
            PropertyMap logEventSource = (PropertyMap)prop;
            String enabled = logEventSource.getSimpleValue("enabled", null);
            if (enabled == null) {
                throw new IllegalStateException("Required property [enabled] is not defined in map.");
            }
            if (!Boolean.valueOf(enabled).booleanValue()) continue;
            enabledEventSources.add(logEventSource);
        }
        boolean sigarAvailable = this.resourceContext.getSystemInformation().isNative();
        if (!sigarAvailable && !enabledEventSources.isEmpty()) {
            boolean nativeSystemInfoDisabled = SystemInfoFactory.isNativeSystemInfoDisabled();
            ResourceType resourceType = this.resourceContext.getResourceType();
            List<String> logFilePaths = this.getLogFilePaths(enabledEventSources);
            this.log.warn((Object)("Log files " + logFilePaths + " for [" + resourceType.getPlugin() + ":" + resourceType.getName() + "] Resource with key [" + this.resourceContext.getResourceKey() + "] cannot be polled, because log file polling requires RHQ native support, which " + (nativeSystemInfoDisabled ? "has been disabled for this Agent" : "is not available on this platform") + "."));
            return;
        }
        for (PropertyMap logEventSource : enabledEventSources) {
            String minimumSeverityString;
            String includesPatternString;
            String logFilePath = logEventSource.getSimpleValue("logFilePath", null);
            if (logFilePath == null) {
                throw new IllegalStateException("Required property [logFilePath] is not defined in map.");
            }
            File logFile = new File(logFilePath);
            if (!logFile.canRead()) {
                this.log.error((Object)("LOGFILE: Logfile at location " + logFilePath + " does not exist or is not readable. Can not start watching the event log."));
                continue;
            }
            Log4JLogEntryProcessor processor = new Log4JLogEntryProcessor(LOG_ENTRY_EVENT_TYPE, logFile);
            String dateFormatString = logEventSource.getSimpleValue("dateFormat", null);
            if (dateFormatString != null) {
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
                    processor.setDateFormat(dateFormat);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidPluginConfigurationException("Date format [" + dateFormatString + "] is not a valid simple date format.");
                }
            }
            if ((includesPatternString = logEventSource.getSimpleValue("includesPattern", null)) != null) {
                try {
                    Pattern includesPattern = Pattern.compile(includesPatternString);
                    processor.setIncludesPattern(includesPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new InvalidPluginConfigurationException("Includes pattern [" + includesPatternString + "] is not a valid regular expression.");
                }
            }
            if ((minimumSeverityString = logEventSource.getSimpleValue("minimumSeverity", null)) != null) {
                EventSeverity minimumSeverity = EventSeverity.valueOf((String)minimumSeverityString.toUpperCase());
                processor.setMinimumSeverity(minimumSeverity);
            }
            EventContext eventContext = this.resourceContext.getEventContext();
            LogFileEventPoller poller = new LogFileEventPoller(eventContext, LOG_ENTRY_EVENT_TYPE, logFile, processor);
            eventContext.registerEventPoller(poller, 60, logFile.getPath());
            this.startedEventSources.add(logEventSource);
        }
    }

    public void stopLogFileEventPollers() {
        boolean sigarAvailable = this.resourceContext.getSystemInformation().isNative();
        if (!sigarAvailable) {
            return;
        }
        Iterator<PropertyMap> iterator = this.startedEventSources.iterator();
        while (iterator.hasNext()) {
            PropertyMap logEventSource = iterator.next();
            EventContext eventContext = this.resourceContext.getEventContext();
            String logFilePath = logEventSource.getSimpleValue("logFilePath", null);
            eventContext.unregisterEventPoller(LOG_ENTRY_EVENT_TYPE, logFilePath);
            iterator.remove();
        }
    }

    private List<String> getLogFilePaths(List<PropertyMap> enabledEventSources) {
        ArrayList<String> logFilePaths = new ArrayList<String>(enabledEventSources.size());
        for (PropertyMap logEventSource : enabledEventSources) {
            String logFilePath = logEventSource.getSimpleValue("logFilePath", null);
            if (logFilePath == null) {
                throw new IllegalStateException("Required property [logFilePath] is not defined in map.");
            }
            logFilePaths.add(logFilePath);
        }
        return logFilePaths;
    }

    public static abstract class LogEventSourcePropertyNames {
        public static final String LOG_FILE_PATH = "logFilePath";
        public static final String ENABLED = "enabled";
        public static final String DATE_FORMAT = "dateFormat";
        public static final String INCLUDES_PATTERN = "includesPattern";
        public static final String MINIMUM_SEVERITY = "minimumSeverity";
    }
}

