/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

public class CommandLineOption {
    private String shortName;
    private String longName;
    private boolean expectsValue;

    public CommandLineOption(char shortName, String longName) {
        this(new String(new char[]{shortName}), longName, true);
    }

    public CommandLineOption(char shortName, String longName, boolean expectsValue) {
        this(new String(new char[]{shortName}), longName, expectsValue);
    }

    public CommandLineOption(String shortName, String longName) {
        this(shortName, longName, true);
    }

    public CommandLineOption(String shortName, String longName, boolean expectsValue) {
        if (shortName == null && longName == null) {
            throw new IllegalArgumentException("ShortName and longName cannot both be null.");
        }
        this.shortName = shortName;
        this.longName = longName;
        this.expectsValue = expectsValue;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public boolean isExpectsValue() {
        return this.expectsValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.shortName != null) {
            buffer.append('-').append(this.shortName);
            if (this.expectsValue) {
                buffer.append("=VALUE");
            }
            if (this.longName != null) {
                buffer.append('|');
            }
        }
        if (this.longName != null) {
            buffer.append("--").append(this.longName);
            if (this.expectsValue) {
                buffer.append("=VALUE");
            }
        }
        return buffer.toString();
    }
}

