/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pluginapi.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hyperic.sigar.ProcExe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.pluginapi.util.CommandLineOption;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessInfo;

public class ServerStartScriptDiscoveryUtility {
    private static final boolean OS_IS_WINDOWS = File.separatorChar == '\\';
    private static final char OPTION_PREFIX = (char)(OS_IS_WINDOWS ? 47 : 45);
    private static final String CORE_ENV_VAR_PATH_UNIX = "/bin:/usr/bin";
    private static final Set<String> CORE_ENV_VAR_NAME_INCLUDES = new HashSet<String>(Arrays.asList("PATH", "LD_LIBRARY_PATH"));
    private static final String NOHUP_PATH = "/usr/bin/nohup";
    private static final String SUDO_PATH = "/usr/bin/sudo";

    private ServerStartScriptDiscoveryUtility() {
    }

    @Nullable
    public static File getStartScript(ProcessInfo serverParentProcess) {
        File startScriptFile;
        String[] serverParentProcessCommandLine = serverParentProcess.getCommandLine();
        Integer startScriptIndex = ServerStartScriptDiscoveryUtility.getStartScriptIndex(serverParentProcessCommandLine);
        if (startScriptIndex != null) {
            String startScript = serverParentProcessCommandLine.length > startScriptIndex ? serverParentProcessCommandLine[startScriptIndex] : null;
            startScriptFile = new File(startScript);
            if (!startScriptFile.isAbsolute()) {
                ProcExe parentProcessExe = serverParentProcess.getExecutable();
                if (parentProcessExe == null) {
                    startScriptFile = new File("bin", startScriptFile.getName());
                } else {
                    String cwd = parentProcessExe.getCwd();
                    startScriptFile = new File(cwd, startScriptFile.getPath());
                    startScriptFile = new File(FileUtils.getCanonicalPath(startScriptFile.getPath()));
                }
            }
        } else {
            startScriptFile = null;
        }
        return startScriptFile;
    }

    @Nullable
    public static String getStartScriptPrefix(ProcessInfo serverProcess, ProcessInfo thisProcess) {
        String prefix = null;
        if (!OS_IS_WINDOWS) {
            File sudo;
            StringBuilder buffer = new StringBuilder();
            File nohup = new File(NOHUP_PATH);
            if (nohup.canExecute()) {
                buffer.append(nohup.getPath());
            }
            if ((sudo = new File(SUDO_PATH)).canExecute() && serverProcess.getCredentials() != null && thisProcess.getCredentials() != null) {
                boolean sudoNeededForGroup;
                long processUid = serverProcess.getCredentials().getUid();
                long processGid = serverProcess.getCredentials().getGid();
                long agentProcessUid = thisProcess.getCredentials().getUid();
                long agentProcessGid = thisProcess.getCredentials().getGid();
                boolean sudoNeededForUser = processUid != agentProcessUid;
                boolean bl = sudoNeededForGroup = processGid != agentProcessGid;
                if (sudoNeededForUser || sudoNeededForGroup) {
                    if (buffer.length() > 0) {
                        buffer.append(' ');
                    }
                    buffer.append(sudo.getPath());
                    if (sudoNeededForUser) {
                        buffer.append(" -u ");
                        if (serverProcess.getCredentialsName() != null) {
                            buffer.append(serverProcess.getCredentialsName().getUser());
                        } else {
                            buffer.append(serverProcess.getCredentials().getUid());
                        }
                    }
                    if (sudoNeededForUser) {
                        buffer.append(" -g ");
                        if (serverProcess.getCredentialsName() != null) {
                            buffer.append(serverProcess.getCredentialsName().getGroup());
                        } else {
                            buffer.append(serverProcess.getCredentials().getGid());
                        }
                    }
                }
            }
            if (buffer.length() > 0) {
                prefix = buffer.toString();
            }
        }
        return prefix;
    }

    @NotNull
    public static List<String> getStartScriptArgs(ProcessInfo serverParentProcess, List<String> serverArgs, Set<CommandLineOption> optionExcludes) {
        String[] startScriptCommandLine = serverParentProcess.getCommandLine();
        Integer startScriptIndex = ServerStartScriptDiscoveryUtility.getStartScriptIndex(startScriptCommandLine);
        ArrayList<String> startScriptArgs = new ArrayList<String>();
        if (startScriptIndex != null) {
            for (int i = startScriptIndex + 1; i < startScriptCommandLine.length; ++i) {
                startScriptArgs.add(startScriptCommandLine[i]);
            }
        } else if (optionExcludes != null && !optionExcludes.isEmpty()) {
            int serverArgsSize = serverArgs.size();
            for (int i = 0; i < serverArgsSize; ++i) {
                String serverArg = serverArgs.get(i);
                CommandLineOption option = null;
                for (CommandLineOption optionExclude : optionExcludes) {
                    if ((optionExclude.getShortName() == null || !serverArg.equals('-' + optionExclude.getShortName()) && !serverArg.startsWith('-' + optionExclude.getShortName() + "=")) && (optionExclude.getLongName() == null || !serverArg.equals("--" + optionExclude.getLongName()) && !serverArg.startsWith("--" + optionExclude.getLongName() + "="))) continue;
                    option = optionExclude;
                    break;
                }
                if (option != null) {
                    if (!option.isExpectsValue() || i + 1 >= serverArgsSize || (option.getShortName() == null || !serverArg.equals('-' + option.getShortName())) && (option.getLongName() == null || !serverArg.equals("--" + option.getLongName()))) continue;
                    ++i;
                    continue;
                }
                startScriptArgs.add(serverArg);
            }
        } else {
            startScriptArgs.addAll(serverArgs);
        }
        return startScriptArgs;
    }

    @NotNull
    public static Map<String, String> getStartScriptEnv(ProcessInfo serverProcess, ProcessInfo serverParentProcess, Set<String> envVarNameIncludes) {
        Map processEnvVars = ServerStartScriptDiscoveryUtility.getStartScript(serverParentProcess) != null ? serverParentProcess.getEnvironmentVariables() : serverProcess.getEnvironmentVariables();
        ArrayList<String> fullEnvVarNameIncludes = envVarNameIncludes != null ? new ArrayList<String>(envVarNameIncludes) : new ArrayList();
        fullEnvVarNameIncludes.addAll(CORE_ENV_VAR_NAME_INCLUDES);
        LinkedHashMap<String, String> startScriptEnv = new LinkedHashMap<String, String>();
        for (String envVarName : fullEnvVarNameIncludes) {
            String envVarValue = (String)processEnvVars.get(envVarName);
            if (envVarValue == null) continue;
            startScriptEnv.put(envVarName, envVarValue);
        }
        if (File.separatorChar == '\\') {
            String systemRoot = (String)processEnvVars.get("SYSTEMROOT");
            systemRoot = systemRoot == null ? "C:\\Windows" : systemRoot;
            String path = systemRoot + "\\system32;" + systemRoot;
            startScriptEnv.put("PATH", path);
        } else {
            startScriptEnv.put("PATH", CORE_ENV_VAR_PATH_UNIX);
        }
        return startScriptEnv;
    }

    @Nullable
    private static Integer getStartScriptIndex(String[] serverParentProcessCommandLine) {
        String arg;
        int startScriptIndex;
        if (serverParentProcessCommandLine.length == 1) {
            return null;
        }
        for (startScriptIndex = 1; startScriptIndex < serverParentProcessCommandLine.length && ((arg = serverParentProcessCommandLine[startScriptIndex]) == null || arg.isEmpty() || arg.charAt(0) == OPTION_PREFIX); ++startScriptIndex) {
        }
        if (startScriptIndex == serverParentProcessCommandLine.length) {
            return null;
        }
        String possibleStartScript = serverParentProcessCommandLine[startScriptIndex];
        return ServerStartScriptDiscoveryUtility.isScript(possibleStartScript) ? Integer.valueOf(startScriptIndex) : null;
    }

    private static boolean isScript(String filePath) {
        return filePath != null && (filePath.endsWith(".sh") || filePath.matches(".*\\.((bat)|(cmd))$(?i)"));
    }

    static {
        if (OS_IS_WINDOWS) {
            CORE_ENV_VAR_NAME_INCLUDES.add("OS");
            CORE_ENV_VAR_NAME_INCLUDES.add("SYSTEMROOT");
        }
    }
}

